/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CspNetMessage;
import com.bowman.cardserv.crypto.DESUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;

public class CspConnection {
    private int sequenceNr = 0;
    private Socket conn;
    private DataInputStream is;
    private DataOutputStream os;
    private long lastTrafficTimeStamp = System.currentTimeMillis();

    public CspConnection(Socket conn) {
        this.conn = conn;
    }

    public void init() throws IOException {
        this.is = new DataInputStream(new BufferedInputStream(this.conn.getInputStream()));
        this.os = new DataOutputStream(new BufferedOutputStream(this.conn.getOutputStream()));
    }

    public int sendCspMessage(CspNetMessage msg) throws IOException {
        int seq = this.sequenceNr++;
        if (this.sequenceNr > 65535) {
            this.sequenceNr = 0;
        }
        return this.sendCspMessage(msg, seq);
    }

    public synchronized int sendCspMessage(CspNetMessage msg, int seqNr) throws IOException {
        msg.setSeqNr(seqNr);
        this.os.writeByte(msg.getType());
        this.os.writeShort(msg.getSeqNr());
        switch (msg.getType()) {
            case 1: {
                this.writeEcmReq(msg.getCamdMessage());
                break;
            }
            case 2: {
                this.writeDcwRpl(msg.getCamdMessage());
                break;
            }
            case 3: 
            case 5: {
                this.writeStatusUpdate(msg);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IOException("Unknown CspNetMessage type: " + DESUtil.byteToString((byte)msg.getType()));
            }
        }
        this.os.flush();
        this.lastTrafficTimeStamp = System.currentTimeMillis();
        if (msg.getCamdMessage() != null) {
            msg.getCamdMessage().setSent(this.conn.getInetAddress().getHostAddress(), new byte[0], "Csp");
        }
        return msg.getSeqNr();
    }

    private void writeEcmReq(CamdNetMessage camdMsg) throws IOException {
        this.os.writeByte(camdMsg.getCommandTag());
        this.os.writeInt(camdMsg.getOriginId());
        this.os.writeShort(camdMsg.getNetworkId());
        this.os.writeShort(camdMsg.getCaId());
        this.os.writeInt(camdMsg.getProviderIdent());
        this.os.writeShort(camdMsg.getServiceId());
        this.os.writeShort(camdMsg.getDataLength());
        this.os.write(camdMsg.getCustomData());
    }

    private void writeDcwRpl(CamdNetMessage camdMsg) throws IOException {
        this.os.writeByte(camdMsg.getCommandTag());
        this.os.writeShort(camdMsg.getServiceId());
        this.os.writeByte(camdMsg.getDataLength());
        this.os.write(camdMsg.getCustomData());
    }

    private void writeStatusUpdate(CspNetMessage msg) throws IOException {
        int count = msg.getUpdateCount();
        this.os.writeInt(msg.getOriginId());
        this.os.writeByte(count);
        if (count > 0) {
            Iterator iter = msg.getStatusUpdates().iterator();
            block5: while (iter.hasNext()) {
                CspNetMessage.StatusChange sc = (CspNetMessage.StatusChange)iter.next();
                this.os.writeByte(sc.available ? 1 : 0);
                this.os.writeByte(sc.type);
                this.os.writeShort(sc.key.onid);
                this.os.writeShort(sc.key.caid);
                switch (sc.type) {
                    case 1: 
                    case 4: {
                        Integer[] shortItems = sc.getUpdatedItemsInt();
                        this.os.writeShort(shortItems.length);
                        for (int i = 0; i < shortItems.length; ++i) {
                            this.os.writeShort(shortItems[i]);
                        }
                        continue block5;
                    }
                    case 2: {
                        Integer[] items = sc.getUpdatedItemsInt();
                        this.os.writeShort(items.length);
                        for (int i = 0; i < items.length; ++i) {
                            this.os.writeInt(items[i]);
                        }
                        continue block5;
                    }
                    case 3: {
                        Long[] longItems = sc.getUpdatedItemsLong();
                        this.os.writeShort(longItems.length);
                        for (int i = 0; i < longItems.length; ++i) {
                            this.os.writeLong(longItems[i]);
                        }
                        continue block5;
                    }
                    default: {
                        throw new IOException("Unknown state type:" + DESUtil.byteToString((byte)sc.type));
                    }
                }
            }
        }
    }

    public CspNetMessage readMessage() throws IOException {
        if (this.is == null) {
            return null;
        }
        CspNetMessage msg = new CspNetMessage(this.is.readUnsignedByte(), this.is.readUnsignedShort());
        switch (msg.getType()) {
            case 1: {
                msg.setCamdMessage(CamdNetMessage.parseCspEcmReq(this.is, this.getRemoteAddress(), msg.getSeqNr()));
                break;
            }
            case 2: {
                msg.setCamdMessage(CamdNetMessage.parseCspDcwRpl(this.is, this.getRemoteAddress(), msg.getSeqNr()));
                break;
            }
            case 3: 
            case 5: {
                CspNetMessage.parseStatusChange(this.is, msg);
                break;
            }
            case 4: {
                break;
            }
            case 72: {
                this.readHttpReply();
                break;
            }
            default: {
                throw new IOException("Unknown CspNetMessage type: " + DESUtil.byteToString((byte)msg.getType()));
            }
        }
        this.lastTrafficTimeStamp = System.currentTimeMillis();
        return msg;
    }

    private void readHttpReply() throws IOException {
        int b;
        StringBuffer sb = new StringBuffer("HTT");
        while ((b = this.is.read()) != -1) {
            sb.append((char)b);
        }
        String reply = sb.toString().split(String.valueOf('\r'))[0];
        this.close();
        throw new IOException(reply);
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.conn != null;
    }

    public long getLastTrafficTimeStamp() {
        return this.lastTrafficTimeStamp;
    }

    public synchronized String getRemoteAddress() {
        if (this.isConnected()) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return "0.0.0.0";
    }

    public void setSoTimeout(int soTimeout) throws SocketException {
        if (this.isConnected()) {
            this.conn.setSoTimeout(soTimeout);
        }
    }
}

