/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc.dcc;

import com.bowman.irc.dcc.DCCFileEvent;
import com.bowman.irc.dcc.DCCFileListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class DCCFileReceiver
implements Runnable {
    private int blockSize;
    private Thread receiverThread;
    private File file;
    private String host;
    private int port;
    private int filesize;
    private Vector listeners;

    public DCCFileReceiver(File file, String host, int port, int filesize, int blockSize) {
        this.blockSize = blockSize;
        this.host = host;
        this.port = port;
        this.filesize = filesize;
        this.file = file;
        this.listeners = new Vector();
    }

    public void addDCCFileListener(DCCFileListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeDCCFileListener(DCCFileListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireDCCFileEvent(DCCFileEvent ev) {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((DCCFileListener)e.nextElement()).onDCCFileEvent(ev);
        }
    }

    public void start() {
        this.fireDCCFileEvent(new DCCFileEvent(0, null, 9));
        this.fireDCCFileEvent(new DCCFileEvent(7, null, this.filesize));
        this.receiverThread = new Thread((Runnable)this, "DCCFileReceiverThread");
        this.receiverThread.start();
    }

    public void run() {
        FileOutputStream osFile = null;
        InputStream isSocket = null;
        OutputStream osSocket = null;
        try {
            osFile = new FileOutputStream(this.file);
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Unable to open output file.", 0));
        }
        Socket clientSocket = null;
        try {
            clientSocket = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Unable to connect.", 0));
        }
        try {
            isSocket = clientSocket.getInputStream();
            osSocket = clientSocket.getOutputStream();
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Unable to open streams.", 0));
        }
        try {
            clientSocket.setSoTimeout(90000);
        }
        catch (Exception e) {
            // empty catch block
        }
        int totalBytes = this.filesize;
        int totalBytesReceived = 0;
        byte[] outputBuffer = new byte[4];
        byte[] inputBuffer = new byte[this.blockSize];
        this.fireDCCFileEvent(new DCCFileEvent(1, null, 0));
        try {
            int length;
            while ((length = isSocket.read(inputBuffer)) != -1) {
                osFile.write(inputBuffer, 0, length);
                outputBuffer[0] = (byte)((totalBytesReceived += length) >> 24 & 0xFF);
                outputBuffer[1] = (byte)(totalBytesReceived >> 16 & 0xFF);
                outputBuffer[2] = (byte)(totalBytesReceived >> 8 & 0xFF);
                outputBuffer[3] = (byte)(totalBytesReceived >> 0 & 0xFF);
                osSocket.write(outputBuffer);
                this.fireDCCFileEvent(new DCCFileEvent(5, null, length));
            }
            clientSocket.close();
        }
        catch (InterruptedIOException e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Timed out waiting for data.", 0));
            try {
                osFile.close();
            }
            catch (Exception e1) {}
        }
        catch (Exception e) {
            this.fireDCCFileEvent(new DCCFileEvent(2, "Error reading data..", 0));
            try {
                osFile.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        this.fireDCCFileEvent(new DCCFileEvent(3, null, 0));
        try {
            osFile.close();
        }
        catch (Exception e3) {
            // empty catch block
        }
    }
}

