/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.httpd;

import com.bowman.httpd.HttpConstants;
import com.bowman.httpd.HttpRequest;
import com.bowman.httpd.PseudoHttpd;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;

public class HttpResponse
implements HttpConstants {
    private static final Properties errors = new Properties();
    public static final HttpResponse CONNECT_RESPONSE = new HttpResponse(200, "OK");
    private int responseCode;
    private String responseMsg;
    private Map headers = new LinkedHashMap();
    private byte[] content;
    private String encoding;
    private boolean gzip;
    private HttpRequest request;
    static /* synthetic */ Class class$com$bowman$httpd$HttpResponse;

    public static HttpResponse getErrorResponse(int responseCode) {
        return HttpResponse.getErrorResponse(responseCode, null);
    }

    public static HttpResponse getErrorResponse(int responseCode, String param) {
        String name = errors.getProperty(responseCode + ".name");
        String text = errors.getProperty(responseCode + ".text");
        if (text == null) {
            text = name;
        }
        if (name == null) {
            throw new IllegalArgumentException("Undefined responseCode: " + responseCode);
        }
        if (param == null) {
            param = "";
        }
        text = MessageFormat.format(text, param);
        return new HttpResponse(responseCode, name, text);
    }

    public static HttpResponse getAuthReqResponse(String realm) {
        HttpResponse response = HttpResponse.getErrorResponse(401, "Authorization required");
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        return response;
    }

    public static HttpResponse getErrorResponse(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("<br><br><pre>");
        e.printStackTrace(pw);
        pw.print("</pre>");
        return HttpResponse.getErrorResponse(500, sw.getBuffer().toString());
    }

    public static HttpResponse getFileResponse(byte[] fileData, String filePath, PseudoHttpd httpd) {
        HttpResponse response = new HttpResponse(fileData, PseudoHttpd.getMimeType(filePath));
        if (httpd != null) {
            response.setGzipContent(httpd.isGzipExt(filePath));
        }
        return response;
    }

    public HttpResponse(int responseCode, String responseMsg) {
        this.responseCode = responseCode;
        this.responseMsg = responseMsg;
        this.setHeader("Date", new Date());
        this.setHeader("Server", "Java PseudoHttpd/0.4.5");
    }

    public HttpResponse(int responseCode, String responseMsg, byte[] content, String contentType) {
        this(responseCode, responseMsg);
        this.setContent(content, contentType);
    }

    public HttpResponse(int responseCode, String responseMsg, String errorMsg) {
        this(responseCode, responseMsg);
        Object[] params = new Object[]{new Integer(responseCode), responseMsg, errorMsg};
        this.setContent(MessageFormat.format("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<html><head><title>{0} {1}</title></head><body><h1>{1}</h1><p>{2}</p><hr><address>Java PseudoHttpd Server 0.4.5</address></body></html>", params), "text/html");
    }

    public HttpResponse(byte[] content, String contentType) {
        this(200, "OK");
        this.setContent(content, contentType);
    }

    public HttpResponse(String contentStr, String contentType) {
        this(200, "OK");
        this.setContent(contentStr, contentType);
    }

    public HttpResponse(String contentStr, String contentType, boolean gzip) {
        this(200, "OK");
        this.setContent(contentStr, contentType);
        this.gzip = gzip;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMsg() {
        return this.responseMsg;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void setContent(String contentStr, String contentType) {
        byte[] tmp;
        this.encoding = "UTF-8";
        try {
            tmp = contentStr.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            tmp = contentStr.getBytes();
            this.encoding = System.getProperty("file.encoding");
        }
        if (contentType != null) {
            if (contentType.toLowerCase().indexOf("charset") == -1) {
                contentType = contentType + "; charset=" + this.encoding;
            }
        } else {
            contentType = "text/plain; charset=" + this.encoding;
        }
        this.setContent(tmp, contentType);
    }

    protected void setContent(byte[] content, String contentType) {
        this.content = content;
        if (contentType.startsWith("text")) {
            this.encoding = "UTF-8";
            if (contentType.toLowerCase().indexOf("charset") == -1) {
                contentType = contentType + "; charset=" + this.encoding;
            }
        }
        this.setHeader("Content-Length", String.valueOf(content.length));
        this.setHeader("Content-Type", contentType);
    }

    protected void setGzipContent(boolean gzip) {
        this.gzip = gzip;
    }

    private void gzipContent() {
        String acceptList = this.request.getHeader("accept-encoding");
        if (acceptList != null && acceptList.toLowerCase().indexOf("gzip") > -1) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(this.content);
                gzos.close();
                this.content = baos.toByteArray();
                this.setHeader("Content-Length", String.valueOf(this.content.length));
                this.setHeader("Content-Encoding", "gzip");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setHeader(String name, Date date) {
        this.headers.put(name, PseudoHttpd.formatDate(HttpConstants.httpDateFmt, date));
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, -1, null);
    }

    public void setCookie(String name, String value, int maxAge, String path) {
        Date expDate = maxAge < 0 ? null : new Date(System.currentTimeMillis() + (long)(maxAge * 1000));
        StringBuffer sb = new StringBuffer();
        sb.append(name).append("=").append(value);
        if (expDate != null) {
            sb.append("; Expires=").append(PseudoHttpd.formatDate(HttpConstants.cookieDateFmt, expDate));
        }
        if (path == null) {
            path = "";
        }
        sb.append("; Path=").append(path);
        this.setHeader("Set-Cookie", sb.toString());
    }

    public String toString() {
        return this.responseCode + " " + this.responseMsg;
    }

    protected void setRequest(HttpRequest request) {
        this.request = request;
        if (this.gzip && !PseudoHttpd.neverGzip) {
            this.gzipContent();
        }
    }

    protected HttpRequest getRequest() {
        return this.request;
    }

    public Map getHeaders() {
        return this.headers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            errors.load((class$com$bowman$httpd$HttpResponse == null ? (class$com$bowman$httpd$HttpResponse = HttpResponse.class$("com.bowman.httpd.HttpResponse")) : class$com$bowman$httpd$HttpResponse).getResourceAsStream("errors.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

