/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.interfaces.CommandManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Command {
    protected static CommandManager manager;
    protected static List commands;
    String name;
    String label;
    String groupLabel;
    String description;
    Object handler;
    Command override;
    protected Method method;
    Map params = new LinkedHashMap();

    public static void setManager(CommandManager commandManager) {
        manager = commandManager;
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            manager.registerCommand((Command)iter.next());
            iter.remove();
        }
    }

    protected static String methodifyName(String xmlName, String prefix) {
        String[] parts = xmlName.split("-");
        StringBuffer sb = new StringBuffer(prefix);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].toLowerCase();
            sb.append(Character.toUpperCase(parts[i].charAt(0))).append(parts[i].substring(1));
        }
        return sb.toString();
    }

    public Command(String name, String label, String description) {
        this.name = name;
        this.label = label;
        this.description = description;
    }

    public void unregister() {
        if (manager != null) {
            manager.unregisterCommand(this);
        } else {
            commands.remove(this);
        }
    }

    public void register(Object handler) throws NoSuchMethodException {
        this.register(handler, null, false);
    }

    public void register(Object handler, boolean override) throws NoSuchMethodException {
        this.register(handler, null, override);
    }

    public void register(Object handler, String label) throws NoSuchMethodException {
        this.register(handler, label, false);
    }

    public abstract void register(Object var1, String var2, boolean var3) throws NoSuchMethodException;

    public CommandParam addParam(String name, String label) {
        CommandParam cp = new CommandParam(name, label);
        this.params.put(name, cp);
        return cp;
    }

    public CommandParam getParam(String name) {
        return (CommandParam)this.params.get(name);
    }

    public void setOverride(Command override) {
        if (override != null) {
            override.params = this.params;
        }
        this.override = override;
    }

    protected String getHandlerName() {
        String name = this.handler.getClass().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    static {
        commands = new ArrayList();
    }

    public static class CommandParam {
        String name;
        String label;
        String value;
        Collection options;
        boolean allowArbitrary = true;
        int size = -1;
        boolean optional = false;
        boolean adminOnly = false;

        CommandParam(String name, String label) {
            this.name = name;
            this.label = label;
        }

        public CommandParam setOptions(Collection options, boolean allowArbitrary) {
            this.options = options;
            this.allowArbitrary = allowArbitrary;
            return this;
        }

        public CommandParam setOptions(String id, boolean allowArbitrary) {
            if (!id.startsWith("@")) {
                id = "@" + id;
            }
            this.options = Arrays.asList(id);
            this.allowArbitrary = allowArbitrary;
            return this;
        }

        public String[] getOptions() {
            if (this.options == null) {
                return new String[0];
            }
            String[] opts = new String[this.options.size()];
            Iterator iter = this.options.iterator();
            for (int i = 0; i < opts.length; ++i) {
                opts[i] = iter.next().toString();
            }
            return opts;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public void setAdminOnly(boolean adminOnly) {
            this.adminOnly = adminOnly;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

