/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ThinURLConnection
extends HttpURLConnection
implements Runnable {
    protected static final String CRLF = "\r\n";
    protected static List headerOrder = new ArrayList();
    protected static final int MAX_HEADERSIZE = 10250;
    protected URL url;
    protected String method;
    protected String filePath;
    protected boolean connected;
    protected Map responseHeaders;
    protected Map requestHeaders;
    protected int responseCode;
    protected String responseMessage;
    protected long soTimeout;
    protected Socket conn;
    protected Thread readerThread;
    protected IOException lastException;

    protected static Map initRequestHeaders(URL url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)");
        headers.put("Accept", "*/*");
        headers.put("Accept-Language", "en");
        headers.put("Accept-Encoding", "gzip, deflate");
        headers.put("Connection", "Close");
        headers.put("Host", url.getHost() + (-1 == url.getPort() ? "" : ":" + url.getPort()));
        return headers;
    }

    protected ThinURLConnection(URL url) {
        super(null);
        if (!"HTTP".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("Unsupported protocol: " + url.getProtocol());
        }
        this.url = url;
        this.method = "GET";
        this.soTimeout = 60000L;
        this.requestHeaders = ThinURLConnection.initRequestHeaders(url);
        this.filePath = url.getFile();
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if ("POST".equalsIgnoreCase(method) || "GET".equalsIgnoreCase(method)) {
            this.method = method.toUpperCase();
        }
        throw new ProtocolException("Illegal method: " + method);
    }

    public long getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(long soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.lastException != null && this.responseCode == 0) {
            throw this.lastException;
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.lastException != null && this.responseMessage == null) {
            throw this.lastException;
        }
        return this.responseMessage;
    }

    public int getContentLength() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
        if (!this.responseHeaders.containsKey("content-length")) {
            return -1;
        }
        return Integer.parseInt((String)this.responseHeaders.get("content-length"));
    }

    public void setContentLength(int length) {
        this.requestHeaders.put("Content-Length", String.valueOf(length));
    }

    public String getContentType() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
        return (String)this.responseHeaders.get("content-type");
    }

    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.responseHeaders.get(name.toLowerCase());
    }

    public String getHeaderFieldKey(int n) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    public String getRequestProperty(String key) {
        return (String)this.requestHeaders.get(key);
    }

    public void disconnect() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.conn = null;
        this.url = null;
    }

    public boolean usingProxy() {
        return false;
    }

    public synchronized void connect() throws IOException {
        if (this.url == null) {
            throw new IOException("Illegal state, connection already performed.");
        }
        if (this.connected) {
            return;
        }
        this.conn = new Socket(this.url.getHost(), this.url.getPort() == -1 ? 80 : this.url.getPort());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.conn.getOutputStream()));
        if ("POST".equals(this.method) && !this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
        out.write(this.method + " " + this.filePath + " HTTP/1.1");
        Iterator iter = headerOrder.iterator();
        while (iter.hasNext()) {
            String hKey = (String)iter.next();
            if (!this.requestHeaders.containsKey(hKey)) continue;
            out.write(this.getReqHeaderStr(hKey));
        }
        out.write(CRLF);
        out.flush();
        this.connected = true;
        this.readerThread = new Thread((Runnable)this, "ThinURLConnectionReaderThread");
        this.readerThread.start();
        if ("GET".equals(this.method)) {
            try {
                this.wait(this.soTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String getReqHeaderStr(String key) {
        return key + ": " + this.requestHeaders.get(key) + CRLF;
    }

    private void parseReplyLine(String line) throws ProtocolException {
        StringTokenizer tok = new StringTokenizer(line);
        try {
            String temp = tok.nextToken();
            if (!temp.startsWith("HTTP/")) {
                throw new ProtocolException("Invalid reply: " + line);
            }
            temp = tok.nextToken();
            this.responseCode = Integer.parseInt(temp);
            this.responseMessage = tok.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new ProtocolException("Missing term, invalid reply: " + line);
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException("Bad response code, invalid reply: " + line);
        }
    }

    private void parseHeaderLine(String line) throws ProtocolException {
        int idx = line.indexOf(":");
        if (idx == -1) {
            throw new ProtocolException("Invalid header line: " + line);
        }
        String key = line.substring(0, idx);
        String value = line.substring(idx + 1);
        this.responseHeaders.put(key.toLowerCase(), value.trim());
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.lastException != null) {
            throw this.lastException;
        }
        return this.conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!"POST".equals(this.method)) {
            throw new IOException("Request method is GET.");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.conn.getOutputStream();
    }

    public synchronized void run() {
        try {
            String line;
            StringBuffer headerBuf = new StringBuffer();
            InputStream is = this.conn.getInputStream();
            int c = 0;
            int chr = 0;
            boolean headerFound = false;
            do {
                if ((chr = is.read()) == -1) {
                    throw new ProtocolException("Connection reset before complete reply header.");
                }
                if (c > 10250) {
                    throw new ProtocolException("End of header not found within 10250 bytes");
                }
                headerBuf.append((char)chr);
                if (c > 5 && headerBuf.charAt(c) == '\r' && headerBuf.charAt(c - 1) == '\n' && headerBuf.charAt(c - 2) == '\r' && headerBuf.charAt(c - 3) == '\n') {
                    headerFound = true;
                }
                ++c;
            } while (!headerFound);
            BufferedReader in = new BufferedReader(new StringReader(headerBuf.toString()));
            this.responseHeaders = new HashMap();
            boolean first = true;
            while (!"".equals(line = in.readLine())) {
                if (first) {
                    this.parseReplyLine(line);
                    first = false;
                    continue;
                }
                this.parseHeaderLine(line);
            }
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            ioe.printStackTrace();
            this.disconnect();
        }
        this.notify();
    }

    public static void main(String[] args) throws Exception {
        String line;
        URL url = new URL("http://www.stockholmsborsen.se/stocklist.asp?lang=swe&list=SSE37&group=Kursnoteringar&listName=Alla%20aktier");
        ThinURLConnection tu = new ThinURLConnection(url);
        System.out.println(tu.getResponseCode());
        System.out.println(tu.getResponseMessage());
        System.out.println(tu.getContentType());
        System.out.println(tu.getContentLength());
        BufferedReader reader = new BufferedReader(new InputStreamReader(tu.getInputStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }

    static {
        headerOrder.add("Accept");
        headerOrder.add("Referer");
        headerOrder.add("Accept-Language");
        headerOrder.add("Content-Type");
        headerOrder.add("Accept-Encoding");
        headerOrder.add("User-Agent");
        headerOrder.add("Host");
        headerOrder.add("Content-Length");
        headerOrder.add("Connection");
        headerOrder.add("Cache-Control");
        headerOrder.add("Cookie");
    }
}

