/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.appletgui;

import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CharsetHandler {
    private int MIN_GAP = 2;
    private byte[] fontData;
    private int WIDTH;
    private int HEIGHT;
    private Image strImg;
    private int xoStart = 0;
    private int actLen = 0;

    public CharsetHandler(InputStream is) {
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            byte[] raw = new byte[32768];
            int ret = 0;
            int len = 0;
            while ((ret = zis.read()) != -1) {
                raw[len++] = (byte)ret;
            }
            zis.closeEntry();
            this.WIDTH = raw[0];
            this.HEIGHT = raw[1];
            this.fontData = new byte[len - 2];
            System.arraycopy(raw, 2, this.fontData, 0, this.fontData.length);
            System.out.println("BowmaN CharsetRenderer 0.1 - Loading complete");
            System.out.println("Charset Size: " + len);
            System.out.println("Charset Width: " + this.WIDTH + " Height: " + this.HEIGHT);
            zis.close();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getClass().getName() + " - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private int drawChar(char c, Graphics g, int xo, int yo, boolean measure) {
        int offs = c - 32;
        int bits = this.WIDTH * this.HEIGHT;
        int x = offs * bits % 8;
        offs = offs * bits / 8;
        byte cu = 0;
        boolean done = false;
        int ptr = x;
        int ypos = 0;
        int xpos = 0;
        int bitCount = 0;
        int maxSetWidth = 0;
        cu = this.fontData[offs++];
        while (!done) {
            if (ptr == 8) {
                cu = this.fontData[offs++];
                ptr = 0;
            }
            if ((1 << ptr & cu) != 0) {
                if (!measure) {
                    g.drawLine(xo + xpos, yo + ypos, xo + xpos, yo + ypos);
                }
                if (xpos > maxSetWidth) {
                    maxSetWidth = xpos;
                }
            }
            ++ptr;
            ++xpos;
            if (++bitCount == bits) {
                done = true;
            }
            if (bitCount % this.WIDTH != 0) continue;
            ++ypos;
            xpos = 0;
        }
        this.actLen = c != ' ' ? (this.actLen += maxSetWidth + this.MIN_GAP) : (this.actLen += this.MIN_GAP * 2);
        if (c != ' ') {
            return maxSetWidth + this.MIN_GAP;
        }
        return this.MIN_GAP * 2;
    }

    public int drawString(String s, Graphics g, int xo, int yo) {
        this.xoStart = xo;
        for (int i = 0; i < s.length(); ++i) {
            xo += this.drawChar(s.charAt(i), g, xo, yo, false);
        }
        return xo - this.xoStart;
    }

    public int measureString(String s) {
        return this.measureString(s, 0);
    }

    public int measureString(String s, int breakLen) {
        int sLen = s.length();
        this.actLen = 0;
        int xo = 0;
        for (int i = 0; i < sLen; ++i) {
            xo += this.drawChar(s.charAt(i), null, xo, 0, true);
            if (breakLen <= 0 || this.actLen < breakLen) continue;
            return i - 1;
        }
        if (breakLen > 0) {
            return 0;
        }
        return xo;
    }

    public void setMinGap(int gap) {
        this.MIN_GAP = gap;
    }

    public int getMaxHeight() {
        return this.HEIGHT;
    }

    public int getMaxWidth() {
        return this.WIDTH;
    }
}

