/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.CronTimerListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class CronTimer
implements Runnable {
    private static Set allTimers = new HashSet();
    private static Thread checkThread;
    private Thread taskThread;
    private Vector listeners;
    private boolean alive = true;
    private int[] hours;
    private int[] mins;
    private int[] doms;
    private int[] mons;
    private int[] dows;

    private static void checkTimeAll() {
        Iterator iter = allTimers.iterator();
        while (iter.hasNext()) {
            ((CronTimer)iter.next()).checkTime();
        }
    }

    public static void abortAll() {
        Iterator iter = allTimers.iterator();
        while (iter.hasNext()) {
            ((CronTimer)iter.next()).stop();
        }
        allTimers.clear();
        checkThread = null;
    }

    private static String convertExtendedSyntax(String token, int max) {
        if (token.indexOf("/") > -1) {
            if (!token.startsWith("*/")) {
                throw new IllegalArgumentException("Expected */x type param, not: " + token);
            }
            try {
                int interval = Integer.parseInt(token.substring(2));
                String expandedStr = "";
                if (interval > max / 2) {
                    throw new NumberFormatException();
                }
                for (int i = 0; i < max; i += interval) {
                    expandedStr = expandedStr + i + ",";
                }
                return expandedStr.substring(0, expandedStr.length() - 1);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected */x type param, where x is <= " + max / 2 + ". Got: " + token);
            }
        }
        if (token.indexOf("-") > -1) {
            int idx = token.indexOf("-");
            try {
                int start = Integer.parseInt(token.substring(0, idx));
                int end = Integer.parseInt(token.substring(idx + 1));
                if (start >= end || start < 0 || end > max) {
                    throw new NumberFormatException();
                }
                String expandedStr = "";
                for (int i = start; i <= end; ++i) {
                    expandedStr = expandedStr + i + ",";
                }
                return expandedStr.substring(0, expandedStr.length() - 1);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Expected x-y type param, where x < y and y <= " + max + ". Got: " + token);
            }
        }
        return token;
    }

    public CronTimer(String cronString) throws IllegalArgumentException {
        try {
            int i;
            this.listeners = new Vector();
            StringTokenizer tok = new StringTokenizer(cronString, " ");
            if (tok.countTokens() != 5) {
                throw new IllegalArgumentException("Illegal parameter count");
            }
            StringTokenizer fTok = new StringTokenizer(CronTimer.convertExtendedSyntax(tok.nextToken(), 60), ",");
            int count = fTok.countTokens();
            String element = fTok.nextToken();
            if (!element.equals("*")) {
                this.mins = new int[count];
                this.mins[0] = Integer.parseInt(element);
                for (i = 1; i < count; ++i) {
                    element = fTok.nextToken();
                    this.mins[i] = Integer.parseInt(element);
                }
            }
            fTok = new StringTokenizer(CronTimer.convertExtendedSyntax(tok.nextToken(), 23), ",");
            count = fTok.countTokens();
            element = fTok.nextToken();
            if (!element.equals("*")) {
                this.hours = new int[count];
                this.hours[0] = Integer.parseInt(element);
                for (i = 1; i < count; ++i) {
                    element = fTok.nextToken();
                    this.hours[i] = Integer.parseInt(element);
                }
            }
            fTok = new StringTokenizer(CronTimer.convertExtendedSyntax(tok.nextToken(), 31), ",");
            count = fTok.countTokens();
            element = fTok.nextToken();
            if (!element.equals("*")) {
                this.doms = new int[count];
                this.doms[0] = Integer.parseInt(element);
                for (i = 1; i < count; ++i) {
                    element = fTok.nextToken();
                    this.doms[i] = Integer.parseInt(element);
                }
            }
            fTok = new StringTokenizer(CronTimer.convertExtendedSyntax(tok.nextToken(), 12), ",");
            count = fTok.countTokens();
            element = fTok.nextToken();
            if (!element.equals("*")) {
                this.mons = new int[count];
                this.mons[0] = Integer.parseInt(element);
                for (i = 1; i < count; ++i) {
                    element = fTok.nextToken();
                    this.mons[i] = Integer.parseInt(element);
                }
            }
            fTok = new StringTokenizer(CronTimer.convertExtendedSyntax(tok.nextToken(), 7), ",");
            count = fTok.countTokens();
            element = fTok.nextToken();
            if (!element.equals("*")) {
                this.dows = new int[count];
                this.dows[0] = Integer.parseInt(element);
                for (i = 1; i < count; ++i) {
                    element = fTok.nextToken();
                    this.dows[i] = Integer.parseInt(element);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public synchronized void addTimerListener(CronTimerListener l) {
        this.listeners.addElement(l);
    }

    public synchronized void removeTimerListener(CronTimerListener l) {
        this.listeners.removeElement(l);
    }

    public void start() {
        if (checkThread == null) {
            checkThread = new Thread((Runnable)this, "CronTimerCheckThread");
            checkThread.setDaemon(true);
            checkThread.start();
        }
        allTimers.add(this);
    }

    public synchronized void stop() {
        this.alive = false;
        this.listeners.clear();
        allTimers.remove(this);
        if (this.taskThread != null) {
            this.taskThread.interrupt();
        }
        this.taskThread = null;
    }

    public synchronized void run() {
        if (Thread.currentThread() == checkThread) {
            while (checkThread != null) {
                try {
                    Calendar now = Calendar.getInstance();
                    int second = now.get(13);
                    this.wait(1000 * (61 - second));
                    CronTimer.checkTimeAll();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (Thread.currentThread() == this.taskThread) {
            this.fireTimeoutEvent();
            this.taskThread = null;
        }
    }

    private void checkTime() {
        int i;
        boolean found;
        if (!this.alive) {
            return;
        }
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int min = now.get(12);
        int dow = now.get(7);
        switch (dow) {
            case 2: {
                dow = 1;
                break;
            }
            case 3: {
                dow = 2;
                break;
            }
            case 4: {
                dow = 3;
                break;
            }
            case 5: {
                dow = 4;
                break;
            }
            case 6: {
                dow = 5;
                break;
            }
            case 7: {
                dow = 6;
                break;
            }
            case 1: {
                dow = 7;
            }
        }
        int mon = now.get(2) + 1;
        int dom = now.get(5);
        if (this.hours != null) {
            found = false;
            for (i = 0; i < this.hours.length; ++i) {
                if (this.hours[i] != hour) continue;
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (this.mins != null) {
            found = false;
            for (i = 0; i < this.mins.length; ++i) {
                if (this.mins[i] != min) continue;
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (this.dows != null) {
            found = false;
            for (i = 0; i < this.dows.length; ++i) {
                if (this.dows[i] != dow) continue;
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (this.mons != null) {
            found = false;
            for (i = 0; i < this.mons.length; ++i) {
                if (this.mons[i] != mon) continue;
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (this.doms != null) {
            found = false;
            for (i = 0; i < this.doms.length; ++i) {
                if (this.doms[i] != dom) continue;
                found = true;
            }
            if (!found) {
                return;
            }
        }
        this.runTasksThreaded();
    }

    private void runTasksThreaded() {
        if (!this.listeners.isEmpty() && this.taskThread == null) {
            this.taskThread = new Thread((Runnable)this, "CronTimerThread - " + this.listeners.firstElement().getClass().getName());
            this.taskThread.setDaemon(true);
            this.taskThread.start();
        }
    }

    private void fireTimeoutEvent() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            CronTimerListener listener = (CronTimerListener)enumeration.nextElement();
            listener.timeout(this);
        }
    }
}

