/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.DreamboxPlugin;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.LogManager;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.TcpIpForwardFilter;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;

public class AgentSshd
implements XmlConfigurable {
    private DreamboxPlugin parent;
    private SshServer sshd;
    int listenPort;
    int rangeStart;
    int rangeCount;
    private Map tunnelSessions = new HashMap();
    private Set reservedPorts = new HashSet();

    public AgentSshd(DreamboxPlugin parent) {
        this.parent = parent;
        try {
            LogManager lm = LogManager.getLogManager();
            if (lm.getLogger("org.apache.sshd.SshServer") == null) {
                lm.readConfiguration(AgentSshd.class.getResourceAsStream("sshd-logging.properties"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.listenPort = xml.getPortValue("listen-port");
        xml = xml.getSubConfig("tunnel-port-range");
        this.rangeStart = xml.getIntValue("start");
        this.rangeCount = xml.getIntValue("count", 10);
    }

    public void start() throws IOException {
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(this.listenPort);
        this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider("etc/hostkey.ser"));
        this.sshd.setPublickeyAuthenticator(new PublickeyAuthenticator(){

            public boolean authenticate(String s, PublicKey publicKey, ServerSession session) {
                if (AgentSshd.this.parent.getBox(s) == null) {
                    ((AgentSshd)AgentSshd.this).parent.logger.warning("Unknown box (" + s + ") ssh login from: " + session.getIoSession().getRemoteAddress());
                    return false;
                }
                return true;
            }
        });
        this.sshd.setTcpIpForwardFilter(new TcpIpForwardFilter(){

            public boolean canListen(InetSocketAddress address, ServerSession session) {
                TunnelSession ts = AgentSshd.this.getTunnelSession(session.getUsername());
                if (ts != null) {
                    ((AgentSshd)AgentSshd.this).parent.logger.warning("Tunnel session already exists for box: " + session.getUsername() + " (closing old...)");
                    ts.close();
                }
                ((AgentSshd)AgentSshd.this).parent.logger.info("Tunnel session granted: " + AgentSshd.this.addTunnelSession(address.getPort(), session));
                return true;
            }

            public boolean canConnect(InetSocketAddress address, ServerSession session) {
                return false;
            }
        });
        this.sshd.start();
    }

    public void stop() {
        try {
            this.sshd.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized int findTunnelPort() {
        TreeSet<Integer> usedPorts = new TreeSet<Integer>();
        usedPorts.addAll(this.reservedPorts);
        Iterator iter = this.tunnelSessions.keySet().iterator();
        while (iter.hasNext()) {
            TunnelSession ts = this.getTunnelSession((String)iter.next());
            if (ts == null) continue;
            usedPorts.add(new Integer(ts.listenPort));
        }
        Integer i = new Integer(this.rangeStart);
        while (usedPorts.contains(i)) {
            i = new Integer(i + 1);
        }
        if (i > this.rangeStart + this.rangeCount) {
            return -1;
        }
        this.reservedPorts.add(i);
        return i;
    }

    public int getBoxPort(String id) {
        TunnelSession ts = this.getTunnelSession(id);
        if (ts == null) {
            return -1;
        }
        return ts.listenPort;
    }

    private TunnelSession addTunnelSession(int port, ServerSession session) {
        TunnelSession newSession;
        String id = session.getUsername();
        TunnelSession oldSession = this.tunnelSessions.put(id, newSession = new TunnelSession(port, id, session));
        if (oldSession != null) {
            oldSession.close();
        }
        return newSession;
    }

    private TunnelSession getTunnelSession(String id) {
        TunnelSession session = (TunnelSession)this.tunnelSessions.get(id);
        if (session != null && !session.isAlive()) {
            this.tunnelSessions.remove(session);
            this.reservedPorts.remove(new Integer(session.listenPort));
            session = null;
        }
        return session;
    }

    public boolean closeTunnelSession(String id) {
        TunnelSession session = this.getTunnelSession(id);
        if (session != null) {
            session.close();
            this.reservedPorts.remove(new Integer(session.listenPort));
            return true;
        }
        return false;
    }

    public int getPort() {
        return this.listenPort;
    }

    public static void main(String[] args) throws IOException {
        AgentSshd sshd = new AgentSshd(null);
        sshd.listenPort = 2222;
        sshd.start();
    }

    private static class TunnelSession {
        int listenPort;
        String boxId;
        ServerSession session;

        TunnelSession(int listenPort, String boxId, ServerSession session) {
            this.listenPort = listenPort;
            this.boxId = boxId;
            this.session = session;
        }

        boolean isAlive() {
            if (this.session == null) {
                return false;
            }
            boolean connected = this.session.getIoSession().isConnected();
            if (!connected) {
                this.session = null;
            }
            return connected;
        }

        void close() {
            if (this.session != null) {
                this.session.close(true);
            }
        }

        public String toString() {
            return this.boxId + " (port: " + this.listenPort + " remote-ip: " + (this.session == null ? null : this.session.getIoSession().getRemoteAddress() + ")");
        }
    }
}

