/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import java.io.IOException;
import java.net.Socket;

public class BoxOperation {
    private static int counter = 0;
    private String cmdLine;
    private String scriptName;
    private String params;
    private String outFile;
    private int id;
    private long startTimeStamp = -1L;
    private long stopTimeStamp = -1L;
    private StringBuffer output;
    private Socket conn;

    public BoxOperation(String s, String params, String outFile) {
        if (s.startsWith("cmd:")) {
            this.cmdLine = s.substring(4);
        } else if (s.startsWith("script:")) {
            this.scriptName = s.substring(7);
        } else {
            throw new IllegalArgumentException(s);
        }
        this.params = params;
        this.outFile = outFile;
        this.id = counter++;
    }

    public String toString() {
        if (this.scriptName != null) {
            return this.scriptName + (this.outFile == null ? "" : " > f");
        }
        if (this.cmdLine != null) {
            return this.cmdLine.length() > 10 ? this.cmdLine.substring(0, 10) + "..." : this.cmdLine;
        }
        return "(invalid)";
    }

    public String getCmdLine() {
        return this.cmdLine;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getParams() {
        if (this.params == null) {
            return "";
        }
        return this.params;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public boolean isScript() {
        return this.scriptName != null;
    }

    public int getId() {
        return this.id;
    }

    public void start(Socket conn) {
        if (this.startTimeStamp != -1L) {
            throw new IllegalStateException("start() on already started op: " + this.id);
        }
        this.startTimeStamp = System.currentTimeMillis();
        this.output = new StringBuffer();
        this.conn = conn;
    }

    public void end() {
        this.stopTimeStamp = System.currentTimeMillis();
        this.conn = null;
    }

    public void abort() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return this.startTimeStamp != -1L && this.stopTimeStamp == -1L;
    }

    public boolean isStarted() {
        return this.startTimeStamp != -1L;
    }

    public long getStartTime() {
        return this.startTimeStamp;
    }

    public long getStopTime() {
        return this.stopTimeStamp;
    }

    public void appendOutput(String line) {
        this.output.append(line).append("\n");
    }

    public String getOutput() {
        if (this.output == null) {
            return null;
        }
        return this.output.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxOperation that = (BoxOperation)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

