/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.AgentSshd;
import com.bowman.cardserv.AgentWeb;
import com.bowman.cardserv.BoxMetaData;
import com.bowman.cardserv.BoxOperation;
import com.bowman.cardserv.BoxRegistry;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.FileUploadPermission;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.util.PluginClassLoader;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.Command;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.XmlHelper;
import com.bowman.xml.XMLConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DreamboxPlugin
implements ProxyPlugin {
    private static String AGENT_VERSION;
    public static final String PLUGIN_JAR = "plugins/dreamboxplugin.jar";
    protected RemoteHandler proxy;
    protected ProxyLogger logger;
    protected int checkInterval;
    private BoxRegistry registry = new BoxRegistry();
    private File registryFile;
    private Set commands = new HashSet();
    private AgentWeb web;
    private AgentSshd sshd;
    private static final String[] sshdDeps;
    private Set scripts = new HashSet();
    private Map uploadPermissions = new HashMap();
    private Set validFileNames = new TreeSet();

    public DreamboxPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
        this.registryFile = new File("etc", "registry.dat");
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        ProxyXmlConfig sshdXml = null;
        try {
            sshdXml = xml.getSubConfig("agent-sshd");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (sshdXml != null && "true".equalsIgnoreCase(sshdXml.getStringValue("enabled", "true"))) {
            if (this.sshd == null) {
                try {
                    PluginClassLoader pcl = (PluginClassLoader)this.getClass().getClassLoader();
                    pcl.resolveDependencies(sshdDeps, this.logger);
                    this.sshd = new AgentSshd(this);
                    this.sshd.configUpdated(sshdXml);
                }
                catch (Exception e) {
                    this.logger.severe("Failed to load sshd: " + e, (Throwable)e);
                    this.sshd = null;
                }
            }
        } else if (this.sshd != null) {
            this.sshd.stop();
            this.sshd = null;
        }
        if (this.web == null) {
            this.web = new AgentWeb(this);
        }
        this.web.configUpdated(xml.getSubConfig("agent-web"));
        this.checkInterval = xml.getIntValue("check-interval", 5) * 60;
        this.uploadPermissions.clear();
        this.validFileNames.clear();
        ProxyXmlConfig fileUploadXml = null;
        try {
            fileUploadXml = xml.getSubConfig("file-upload");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (fileUploadXml != null && "true".equalsIgnoreCase(fileUploadXml.getStringValue("enabled", "true"))) {
            Iterator iter = fileUploadXml.getMultipleSubConfigs("file");
            while (iter.hasNext()) {
                ProxyXmlConfig fileXml = (ProxyXmlConfig)iter.next();
                String user = fileXml.getStringValue("user");
                String fileName = fileXml.getStringValue("name");
                this.validFileNames.add(fileName);
                FileUploadPermission fue = (FileUploadPermission)this.uploadPermissions.get(user);
                if (fue != null) {
                    fue.add(fileName, fileXml.getStringValue("target-path"));
                    continue;
                }
                this.uploadPermissions.put(user, new FileUploadPermission(user, fileName, fileXml.getStringValue("target-path")));
            }
        }
        this.applyUploadPermissions();
        this.listScripts();
    }

    private void applyUploadPermissions() {
        if (this.registry == null || this.registry.size() == 0) {
            return;
        }
        BoxMetaData[] boxes = this.registry.findBox(null);
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i].setFileUploadEntry((FileUploadPermission)this.uploadPermissions.get(boxes[i].getUser()));
        }
    }

    private void listScripts() {
        this.scripts.clear();
        String path = "web/open/scripts/";
        try {
            ZipFile jar = new ZipFile(PLUGIN_JAR);
            Enumeration<? extends ZipEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith(path) || entry.getName().endsWith("/")) continue;
                this.scripts.add(entry.getName().substring(path.length()));
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to list scripts in jar: " + e);
            this.logger.throwing((Throwable)e);
        }
    }

    private Set listScriptsDir() {
        HashSet<String> set = new HashSet<String>();
        File dir = new File("dreamboxplugin", "scripts");
        if (dir.exists() && dir.isDirectory()) {
            set.addAll(Arrays.asList(dir.list()));
        }
        return set;
    }

    public byte[] getFile(String path) {
        File file;
        File dir;
        String[] tokens;
        byte[] buf = this.getResource("open/" + path, false);
        if (buf == null && (tokens = path.split("/")).length == 2 && (dir = new File("dreamboxplugin", tokens[0])).exists() && dir.isDirectory() && (file = new File(dir, tokens[1])).exists() && file.length() > 0L) {
            buf = new byte[(int)file.length()];
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(file));
                dis.readFully(buf);
                dis.close();
            }
            catch (IOException e) {
                this.logger.warning("Failed to read file '" + file.getAbsolutePath() + "': " + e);
                this.logger.throwing((Throwable)e);
            }
        }
        return buf;
    }

    public int getTunnelPort() {
        if (this.sshd == null) {
            return -1;
        }
        return this.sshd.findTunnelPort();
    }

    public int getSshdPort() {
        if (this.sshd == null) {
            return -1;
        }
        return this.sshd.getPort();
    }

    public static String getBoxCpuArch(BoxMetaData box) {
        if (box == null) {
            return null;
        }
        return box.getProperty("machine");
    }

    public void start(CardServProxy proxy) {
        this.proxy = proxy.getRemoteHandler();
        this.loadRegistry();
        this.registerCommands();
        this.web.start();
        if (this.sshd != null) {
            try {
                this.sshd.start();
            }
            catch (IOException e) {
                this.logger.warning("Failed to start sshd: " + e);
                this.logger.throwing((Throwable)e);
            }
        }
        this.createDirs();
    }

    protected void createDirs() {
        File binaries;
        File scripts;
        boolean success = true;
        File dir = new File("dreamboxplugin");
        if (!dir.exists()) {
            boolean bl = success = success && dir.mkdirs();
        }
        if (!(scripts = new File(dir, "scripts")).exists()) {
            boolean bl = success = success && scripts.mkdirs();
        }
        if (!(binaries = new File(dir, "binaries")).exists()) {
            boolean bl = success = success && binaries.mkdirs();
        }
        if (!success) {
            this.logger.warning("Failed to initialize dir structure: dreamboxplugin/");
        } else {
            try {
                FileOutputStream fos;
                byte[] buf = this.getResource("fetch_binaries.sh", false);
                File script = new File(dir, "fetch_binaries.sh");
                if (!script.exists()) {
                    fos = new FileOutputStream(script);
                    fos.write(buf);
                    fos.close();
                }
                buf = this.getResource("test.sh", false);
                script = new File(scripts, "test.sh");
                if (!script.exists()) {
                    fos = new FileOutputStream(script);
                    fos.write(buf);
                    fos.close();
                }
                buf = this.getResource("setup_mgcamd.sh", false);
                script = new File(scripts, "setup_mgcamd.sh");
                if (!script.exists()) {
                    fos = new FileOutputStream(script);
                    fos.write(buf);
                    fos.close();
                }
            }
            catch (IOException e) {
                this.logger.warning("Exception extracting helper scripts to 'dreamboxplugin/': " + e);
                this.logger.throwing((Throwable)e);
            }
        }
    }

    protected void registerCommands() {
        try {
            this.commands.addAll(XmlHelper.registerControlCommands((InputStream)DreamboxPlugin.class.getResourceAsStream("ctrl-commands.xml"), (Object)this, null));
        }
        catch (Exception e) {
            this.logger.severe("Failed to load/parse internal control commands (ctrl-commands.xml).", (Throwable)e);
        }
        try {
            this.commands.addAll(XmlHelper.registerStatusCommands((InputStream)DreamboxPlugin.class.getResourceAsStream("status-commands.xml"), (Object)this, null));
        }
        catch (Exception e) {
            this.logger.severe("Failed to load/parse internal status commands (status-commands.xml).", (Throwable)e);
        }
    }

    protected void loadRegistry() {
        if (this.registryFile.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.registryFile)));
                this.registry = (BoxRegistry)ois.readObject();
                this.logger.fine("Loaded registry, " + this.registry.size() + " entries.");
                ois.close();
                this.applyUploadPermissions();
            }
            catch (Exception e) {
                this.logger.throwing((Throwable)e);
                this.logger.warning("Failed to load registry ('" + this.registryFile.getPath() + "'): " + e);
            }
        }
    }

    protected void saveRegistry() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.registryFile)));
            oos.writeObject(this.registry);
            this.logger.fine("Saved box registry, " + this.registry.size() + " entries.");
            oos.close();
        }
        catch (IOException e) {
            this.logger.throwing((Throwable)e);
            this.logger.warning("Failed to save registry ('" + this.registryFile.getPath() + "'): " + e);
        }
    }

    public void stop() {
        this.saveRegistry();
        Iterator iter = this.commands.iterator();
        while (iter.hasNext()) {
            ((Command)iter.next()).unregister();
        }
        this.commands.clear();
        if (this.web != null) {
            this.web.stop();
            this.web = null;
        }
        if (this.sshd != null) {
            this.sshd.stop();
            this.sshd = null;
        }
    }

    protected void registerBox(BoxMetaData box) {
        box.setFileUploadEntry((FileUploadPermission)this.uploadPermissions.get(box.getUser()));
        this.registry.registerBox(box);
    }

    protected BoxMetaData[] findBox(String macAddr, String user) {
        return this.registry.findBox(macAddr, user);
    }

    protected BoxMetaData getBox(String boxId) {
        return this.registry.getBox(boxId);
    }

    protected String getAgentVersion() {
        if (AGENT_VERSION == null) {
            try {
                String[] scriptLines = new String(this.getResource("open/cspagent.sh", false), "ISO-8859-1").split("\n");
                for (int i = 0; i < scriptLines.length; ++i) {
                    if (!scriptLines[i].startsWith("AGENTV=")) continue;
                    AGENT_VERSION = scriptLines[i].substring("AGENTV=".length());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return AGENT_VERSION == null ? "0.0" : AGENT_VERSION;
    }

    public void runStatusCmdListBoxes(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String userName = (String)params.get("user");
        boolean activeOnly = "true".equalsIgnoreCase((String)params.get("hide-inactive"));
        boolean admin = this.proxy.isAdmin(user);
        if (!admin) {
            userName = user;
        }
        BoxMetaData[] boxes = this.registry.findBox(userName, activeOnly);
        xb.appendElement("boxes", "count", boxes.length).appendAttr("active", this.registry.getActiveCount());
        xb.appendAttr("httpd-port", this.web.getFrontendPort());
        if (this.sshd != null) {
            xb.appendAttr("sshd-port", this.sshd.getPort());
        }
        xb.appendAttr("admin", admin).endElement(false);
        for (int i = 0; i < boxes.length; ++i) {
            if (this.sshd != null) {
                boxes[i].setTunnelPort(this.sshd.getBoxPort(boxes[i].getBoxId()));
            }
            DreamboxPlugin.xmlFormatBox(xb, boxes[i], false, admin);
        }
        xb.closeElement("boxes");
        if (admin) {
            HashMap<String, Set> map = new HashMap<String, Set>();
            TreeSet set = new TreeSet(this.listScriptsDir());
            set.addAll(this.scripts);
            if (this.sshd == null) {
                set.remove("ssh_tunnel.sh");
            }
            map.put("@scripts", set);
            if (!this.validFileNames.isEmpty()) {
                map.put("@filenames", this.validFileNames);
            }
            XmlHelper.xmlFormatOptionLists((XmlStringBuffer)xb, map);
        }
    }

    public void runStatusCmdBoxDetails(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String boxId = (String)params.get("id");
        BoxMetaData box = this.registry.getBox(boxId);
        boolean admin = this.proxy.isAdmin(user);
        if (box == null) {
            return;
        }
        if (!admin && !box.getUser().equals(user)) {
            return;
        }
        if (this.sshd != null) {
            box.setTunnelPort(this.sshd.getBoxPort(boxId));
        }
        DreamboxPlugin.xmlFormatBox(xb, box, true, admin);
    }

    public void runStatusCmdInstallerDetails(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        xb.appendElement("installer", "user", user).appendAttr("path", "/installer.sh");
        xb.appendAttr("host", this.web.getFrontendHost()).appendAttr("port", this.web.getFrontendPort());
        xb.endElement(true);
    }

    public void runStatusCmdSetOperations(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.proxy.isAdmin(user)) {
            xb.appendElement("error", "description", "Admin user required.", true);
        } else {
            String op = (String)params.get("operation");
            String p = (String)params.get("params");
            String of = (String)params.get("filename");
            String id = (String)params.get("boxid");
            if (id == null) {
                XMLConfig xml = (XMLConfig)params.get("xml");
                Enumeration e = xml.getMultipleSubConfigs("box");
                while (e.hasMoreElements()) {
                    BoxMetaData box = this.registry.getBox(((XMLConfig)e.nextElement()).getString("id"));
                    if (box == null) continue;
                    if (!box.isUploadAllowed(of)) {
                        of = null;
                    }
                    if ("".equals(op) || op == null) {
                        box.setPendingOperation(null);
                        continue;
                    }
                    box.setPendingOperation(new BoxOperation(op, p, of));
                }
            } else {
                BoxMetaData box = this.registry.getBox(id);
                if (box != null) {
                    if (!box.isUploadAllowed(of)) {
                        of = null;
                    }
                    if ("".equals(op) || op == null) {
                        box.setPendingOperation(null);
                    } else {
                        box.setPendingOperation(new BoxOperation(op, p, of));
                    }
                }
            }
        }
    }

    public void runStatusCmdSetTag(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.proxy.isAdmin(user)) {
            xb.appendElement("error", "description", "Admin user required.", true);
        } else {
            String id = (String)params.get("boxid");
            String bt = (String)params.get("tag");
            if ("".equals(bt) || "null".equals(bt)) {
                bt = null;
            }
            if (id == null) {
                XMLConfig xml = (XMLConfig)params.get("xml");
                Enumeration e = xml.getMultipleSubConfigs("box");
                while (e.hasMoreElements()) {
                    BoxMetaData box = this.registry.getBox(((XMLConfig)e.nextElement()).getString("id"));
                    if (box == null) continue;
                    box.setTag(bt);
                }
            } else {
                BoxMetaData box = this.registry.getBox(id);
                if (box != null) {
                    box.setTag(bt);
                }
            }
        }
    }

    public CtrlCommandResult runCtrlCmdDeleteBox(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String boxId = (String)params.get("id");
        if (boxId == null) {
            resultMsg = "Missing parameter: id";
        } else {
            BoxMetaData box = this.registry.getBox(boxId);
            if (box == null) {
                resultMsg = "Invalid/unknown id: " + boxId;
            } else {
                this.registry.removeBox(boxId);
                resultMsg = "Box deleted";
                result = true;
            }
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdCloseTunnel(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String boxId = (String)params.get("id");
        if (boxId == null) {
            resultMsg = "Missing parameter: id";
        } else if (this.sshd != null) {
            if (this.sshd.closeTunnelSession(boxId)) {
                resultMsg = "Tunnel closed";
                result = true;
            } else {
                resultMsg = "No open tunnel found for box: " + boxId;
            }
        } else {
            resultMsg = "Sshd not enabled";
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdAbortOperation(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String boxId = (String)params.get("id");
        if (boxId == null) {
            resultMsg = "Missing parameter: id";
        } else {
            BoxMetaData box = this.registry.getBox(boxId);
            if (box == null) {
                resultMsg = "Invalid/unknown id: " + boxId;
            } else {
                int opId = -1;
                try {
                    opId = Integer.parseInt((String)params.get("op"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (opId == -1) {
                    if (box.getPendingOperation() != null) {
                        BoxOperation op = box.getPendingOperation();
                        resultMsg = "Pending operation '" + (op.isScript() ? op.getScriptName() : op.getCmdLine()) + "' aborted";
                        box.setPendingOperation(null);
                        result = true;
                    } else {
                        resultMsg = "Missing parameter: op";
                    }
                } else {
                    BoxOperation bo = box.getOperation(opId);
                    if (bo == null) {
                        resultMsg = "No such operation: " + opId;
                    } else {
                        bo.abort();
                        resultMsg = "Operation aborted";
                        result = true;
                    }
                }
            }
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdClearHistory(Map params) throws RemoteException {
        BoxMetaData[] boxes = this.registry.findBox(null);
        int count = 0;
        for (int i = 0; i < boxes.length; ++i) {
            count += boxes[i].clearOperations();
        }
        return new CtrlCommandResult(true, "Deleted " + count + " operation logs", (Object)new Integer(count));
    }

    private static void xmlFormatBox(XmlStringBuffer xb, BoxMetaData box, boolean details, boolean admin) {
        if (details) {
            xb.appendElement("box-details", "id", box.getBoxId());
        } else {
            xb.appendElement("box", "id", box.getBoxId());
        }
        xb.appendAttr("user", box.getUser());
        xb.appendAttr("active", box.isActive());
        if (box.getTag() != null) {
            xb.appendAttr("tag", box.getTag());
        }
        if (box.getTunnelPort() > 0) {
            xb.appendAttr("tunnel-port", box.getTunnelPort());
        }
        if (box.getPendingOperation() != null) {
            xb.appendAttr("pending-operation", box.getPendingOperation().toString());
        }
        if (box.getOperationCount() > 0) {
            xb.appendAttr("operation-count", box.getOperationCount());
            boolean running = false;
            for (BoxOperation op : box.getOperations()) {
                if (!op.isRunning()) continue;
                running = true;
                break;
            }
            if (running) {
                xb.appendAttr("running-operations", true);
            }
        }
        xb.appendAttr("mac", box.getMacAddr());
        xb.appendAttr("created", XmlHelper.formatTimeStamp((long)box.getCreateTimeStamp()));
        xb.appendAttr("last-checkin", XmlHelper.formatTimeStamp((long)box.getLastCheckinTimeStamp()));
        long next = (long)(box.getInterval() * 1000) - (System.currentTimeMillis() - box.getLastCheckinTimeStamp());
        if (next > 0L) {
            xb.appendAttr("next-checkin", XmlHelper.formatDuration((long)(next / 1000L)));
        } else {
            xb.appendAttr("next-checkin", "?");
        }
        xb.appendAttr("interval", box.getInterval());
        if (details) {
            xb.endElement(false);
            xb.appendElement("properties");
            Enumeration<?> e = box.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                xb.appendElement("property", "name", name);
                xb.appendAttr("value", box.getProperty(name)).endElement(true);
            }
            xb.closeElement("properties");
            if (admin && box.getOperationCount() > 0) {
                DreamboxPlugin.xmlFormatOperations(xb, box);
            }
            xb.closeElement(details ? "box-details" : "box");
        } else {
            String[] props = new String[]{"type", "agent-version", "external-ip", "local-ip", "image-guess", "sid", "onid"};
            for (int i = 0; i < props.length; ++i) {
                xb.appendAttr(props[i], box.getProperty(props[i]));
            }
            if (box.getProperty("load") != null) {
                xb.appendAttr("load", box.getProperty("load"));
            }
            if ("true".equals(box.getProperty("cpu-warn"))) {
                xb.appendAttr("cpu-warn", "true");
            }
            xb.endElement(true);
        }
    }

    private static void xmlFormatOperations(XmlStringBuffer xb, BoxMetaData box) {
        xb.appendElement("operations", "count", box.getOperationCount());
        for (BoxOperation op : box.getOperations()) {
            String output;
            xb.appendElement("op", "id", op.getId());
            xb.appendAttr("script", op.isScript());
            xb.appendAttr("text", op.isScript() ? op.getScriptName() + " " + op.getParams() : op.getCmdLine());
            if (op.isStarted()) {
                xb.appendAttr("start", XmlHelper.formatTimeStamp((long)op.getStartTime()));
                if (!op.isRunning()) {
                    xb.appendAttr("stop", XmlHelper.formatTimeStamp((long)op.getStopTime()));
                }
            }
            if ((output = op.getOutput()) != null) {
                xb.endElement(false);
                xb.appendElement("output");
                xb.appendCdata(output);
                xb.closeElement("output");
                xb.closeElement("op");
                continue;
            }
            xb.endElement(true);
        }
        xb.closeElement("operations");
    }

    public String getName() {
        return "DreamboxPlugin";
    }

    public String getDescription() {
        return "Remote monitoring and maintenance of dreamboxes or other linux STBs.";
    }

    public Properties getProperties() {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession proxySession, CamdNetMessage msg) {
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            InputStream is = DreamboxPlugin.class.getResourceAsStream("/web/" + path);
            if (is == null) {
                return null;
            }
            DataInputStream dis = new DataInputStream(is);
            byte[] buf = new byte[dis.available()];
            dis.readFully(buf);
            return buf;
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    public String getUserPasswd(String user) {
        if (this.proxy != null) {
            return this.proxy.getUserPasswd(user);
        }
        return null;
    }

    static {
        sshdDeps = new String[]{"http://repo1.maven.org/maven2/org/apache/sshd/sshd-core/0.3.0/sshd-core-0.3.0.jar", "http://repo1.maven.org/maven2/org/apache/mina/mina-core/2.0.0-M6/mina-core-2.0.0-M6.jar", "http://repo2.maven.org/maven2/org/slf4j/slf4j-api/1.5.2/slf4j-api-1.5.2.jar", "http://repo2.maven.org/maven2/org/slf4j/slf4j-jdk14/1.5.2/slf4j-jdk14-1.5.2.jar"};
    }
}

