/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.ServiceMapping;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CspNetMessage
implements Serializable {
    public static final int TYPE_NEW = 0;
    public static final int TYPE_ECMREQ = 1;
    public static final int TYPE_DCWRPL = 2;
    public static final int TYPE_FULLSTATE = 3;
    public static final int TYPE_STATEACK = 4;
    public static final int TYPE_INCRSTATE = 5;
    public static final int STATE_DELETE = 255;
    public static final int STATE_SIDS = 1;
    public static final int STATE_PROVIDERS = 2;
    public static final int STATE_CUSTOM = 3;
    public static final int STATE_EXTRA = 4;
    private int type;
    private int seqNr;
    private int originId;
    private List statusUpdates;
    private Map statusLookup;
    private CamdNetMessage camdMessage;

    public static void parseStatusChange(DataInputStream is, CspNetMessage msg) throws IOException {
        msg.originId = is.readInt();
        int count = is.readUnsignedByte();
        msg.statusUpdates = new ArrayList(count);
        msg.statusLookup = new HashMap();
        for (int i = 0; i < count; ++i) {
            int caid;
            int operation = is.readUnsignedByte();
            int stateType = is.readUnsignedByte();
            int onid = is.readUnsignedShort();
            ProfileKey key = new ProfileKey(onid, caid = is.readUnsignedShort());
            ArrayList<StatusChange> updates = (ArrayList<StatusChange>)msg.statusLookup.get(key);
            if (updates == null) {
                updates = new ArrayList<StatusChange>();
                msg.statusLookup.put(key, updates);
            }
            StatusChange sc = new StatusChange(key, stateType, operation);
            int itemCount = is.readUnsignedShort();
            if (itemCount > 0) {
                switch (stateType) {
                    case 2: {
                        Integer[] items = new Integer[itemCount];
                        for (int n = 0; n < itemCount; ++n) {
                            items[n] = new Integer(is.readInt());
                        }
                        sc.setUpdatedItems(items);
                        break;
                    }
                    case 1: 
                    case 4: {
                        Integer[] shortItems = new Integer[itemCount];
                        for (int n = 0; n < itemCount; ++n) {
                            shortItems[n] = new Integer(is.readUnsignedShort());
                        }
                        sc.setUpdatedItems(shortItems);
                        break;
                    }
                    case 3: {
                        Long[] longItems = new Long[itemCount];
                        for (int n = 0; n < itemCount; ++n) {
                            longItems[n] = new Long(is.readLong());
                        }
                        sc.setUpdatedItems(longItems);
                        break;
                    }
                    default: {
                        throw new IOException("unknown state type:" + stateType);
                    }
                }
            }
            msg.statusUpdates.add(sc);
            updates.add(sc);
        }
    }

    public static int statusHashCode(List updates) {
        return updates.toString().hashCode();
    }

    public static List buildProfileUpdate(CaProfile profile, boolean sendExtra) {
        int i;
        if (profile.getNetworkId() <= 0 || profile.getCaId() <= 0) {
            return null;
        }
        ArrayList<StatusChange> updates = new ArrayList<StatusChange>();
        ProfileKey key = new ProfileKey(profile);
        ServiceMapping[] sm = profile.getServices(true);
        Integer[] sids = new Integer[sm.length];
        Long[] customs = new Long[sm.length];
        boolean hasCustom = false;
        for (int i2 = 0; i2 < sm.length; ++i2) {
            sids[i2] = new Integer(sm[i2].serviceId);
            customs[i2] = new Long(sm[i2].getCustomData());
            if (sm[i2].getCustomId() == 0 && sm[i2].getProviderIdent() == 0xFFFFFF) continue;
            hasCustom = true;
        }
        for (i = 1; i < 5; ++i) {
            StatusChange sc = new StatusChange(key, i, 1);
            switch (i) {
                case 1: {
                    sc.setUpdatedItems(sids);
                    break;
                }
                case 2: {
                    sc.setUpdatedItems(profile.getProviderIdents());
                    break;
                }
                case 3: {
                    if (!hasCustom) break;
                    sc.setUpdatedItems(customs);
                    break;
                }
                case 4: {
                    if (!sendExtra) break;
                    ProxyConfig config = ProxyConfig.getInstance();
                    int mcww = (int)config.getConnManager().getMaxCwWait(profile);
                    int mcaw = (int)config.getCacheHandler().getMaxCacheWait(mcww);
                    sc.setUpdatedItems(new Integer[]{new Integer(mcww), new Integer(mcaw)});
                }
            }
            updates.add(sc);
        }
        hasCustom = false;
        sm = profile.getServices(false);
        sids = new Integer[sm.length];
        customs = new Long[sm.length];
        for (i = 0; i < sm.length; ++i) {
            sids[i] = new Integer(sm[i].serviceId);
            customs[i] = new Long(sm[i].getCustomData());
            if (sm[i].getCustomId() == 0 && sm[i].getProviderIdent() == 0xFFFFFF) continue;
            hasCustom = true;
        }
        StatusChange sc = new StatusChange(key, 1, 0);
        sc.setUpdatedItems(sids);
        updates.add(sc);
        if (hasCustom) {
            sc = new StatusChange(key, 3, 0);
            sc.setUpdatedItems(customs);
            updates.add(sc);
        }
        return updates;
    }

    public static List getStatusItems(int type, boolean available, List updates) {
        if (updates == null) {
            return null;
        }
        Iterator iter = updates.iterator();
        while (iter.hasNext()) {
            StatusChange sc = (StatusChange)iter.next();
            if (sc.type != type || sc.available != available) continue;
            return sc.list;
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean isDeletion(List updates) {
        if (updates == null || updates.isEmpty()) {
            return false;
        }
        StatusChange sc = (StatusChange)updates.get(0);
        return sc.type == 255;
    }

    public CspNetMessage(int type) {
        this.type = type;
    }

    public CspNetMessage(int type, int seqNr) {
        this(type);
        this.seqNr = seqNr;
    }

    public int getType() {
        return this.type;
    }

    public int getSeqNr() {
        return this.seqNr;
    }

    public void setSeqNr(int seqNr) {
        this.seqNr = seqNr;
    }

    public CamdNetMessage getCamdMessage() {
        return this.camdMessage;
    }

    public void setCamdMessage(CamdNetMessage camdMessage) {
        this.camdMessage = camdMessage;
    }

    public int getOriginId() {
        return this.originId;
    }

    public void setOriginId(int originId) {
        this.originId = originId;
    }

    public boolean isKeepAlive() {
        return this.type == 5 && this.isEmpty();
    }

    public boolean isEmpty() {
        return this.statusUpdates == null || this.statusUpdates.isEmpty();
    }

    public int getUpdateCount() {
        if (this.statusUpdates == null) {
            return 0;
        }
        return this.statusUpdates.size();
    }

    public List getStatusUpdates() {
        return this.statusUpdates;
    }

    public List getStatusUpdatesForKey(ProfileKey key) {
        return (List)this.statusLookup.get(key);
    }

    public Set getProfileKeys() {
        return this.statusLookup.keySet();
    }

    public void addStatusUpdate(StatusChange sc) {
        if (this.statusUpdates == null) {
            this.statusUpdates = new ArrayList();
        }
        this.statusUpdates.add(sc);
    }

    public void addSidUpdate(ProfileKey key, Integer sid, boolean available) {
        StatusChange sc = new StatusChange(key, 1, available ? 1 : 0);
        sc.setUpdatedItems(new Integer[]{sid});
        this.addStatusUpdate(sc);
    }

    public void addDeleteUpdate(ProfileKey key) {
        StatusChange sc = new StatusChange(key, 255, 0);
        this.addStatusUpdate(sc);
    }

    public void addStatusUpdates(ProfileKey key, List updates) {
        if (this.statusUpdates == null) {
            this.statusUpdates = new ArrayList();
        }
        if (this.statusLookup == null) {
            this.statusLookup = new HashMap();
        }
        this.statusUpdates.addAll(updates);
        this.statusLookup.put(key, updates);
    }

    public void setStatusUpdates(List statusUpdates) {
        this.statusUpdates = statusUpdates;
    }

    public static class ProfileKey
    implements Serializable {
        public int onid;
        public int caid;

        public ProfileKey(String s) {
            String[] pair = s.split("-");
            this.onid = Integer.parseInt(pair[0], 16);
            this.caid = Integer.parseInt(pair[1], 16);
        }

        public ProfileKey(CaProfile profile) {
            this.onid = profile.getNetworkId();
            this.caid = profile.getCaId();
        }

        public ProfileKey(int onid, int caid) {
            this.onid = onid;
            this.caid = caid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfileKey that = (ProfileKey)o;
            if (this.caid != that.caid) {
                return false;
            }
            return this.onid == that.onid;
        }

        public int hashCode() {
            int result = this.onid;
            result = 31 * result + this.caid;
            return result;
        }

        public String toString() {
            return DESUtil.intToHexString(this.onid, 4) + "-" + DESUtil.intToHexString(this.caid, 4);
        }
    }

    public static class StatusChange
    implements Serializable {
        ProfileKey key;
        int type;
        boolean available;
        private List list = new ArrayList();

        public StatusChange(ProfileKey key, int type, int available) {
            this.key = key;
            this.type = type;
            this.available = available == 1;
        }

        public void setUpdatedItems(Integer[] items) {
            this.list.addAll(Arrays.asList(items));
        }

        public void setUpdatedItems(Long[] items) {
            this.list.addAll(Arrays.asList(items));
        }

        public Integer[] getUpdatedItemsInt() {
            return this.list.toArray(new Integer[this.list.size()]);
        }

        public Long[] getUpdatedItemsLong() {
            return this.list.toArray(new Long[this.list.size()]);
        }

        public String toString() {
            if (this.list.isEmpty()) {
                return "";
            }
            return this.type + " " + this.list;
        }
    }
}

