/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.SidCacheLinker;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CacheListener;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.PluginClassLoader;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.util.FileChangeListener;
import com.bowman.util.FileWatchdog;
import com.bowman.xml.XMLConfig;
import com.bowman.xml.XMLConfigException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class ProxyConfig
implements FileChangeListener {
    public static final String DEFAULT_CONFIG = "config/proxy.xml";
    public static final long DEFAULT_INTERVAL = 3000L;
    private static ProxyConfig instance = null;
    private XmlConfigurable rootConfigurable;
    private File cfgFile;
    private FileWatchdog fw;
    private int proxyOriginId = (int)System.currentTimeMillis();
    private int logRotateCount;
    private int logRotateLimit;
    private String logFile;
    private String logLevel;
    private String wtBadFlags;
    private int wtMaxDelay;
    private int etMinCount;
    private int maxThreads;
    private int sessionTimeout;
    private int newcamdMaxMsgSize;
    private int maxPending;
    private int maxConnectionsIP;
    private boolean silent;
    private boolean debug;
    private boolean userAllowOnFailure;
    private boolean logFailures;
    private boolean logEcm;
    private boolean logEmm;
    private boolean logZap;
    private boolean hideIPs;
    private boolean blockCaidMismatch;
    private boolean wtIncludeFile;
    private boolean userAllowDifferentIp;
    private boolean firstRead = true;
    private boolean started = false;
    private byte[] defaultProfileDesKey;
    private byte[] defaultConnectorDesKey;
    private byte[] defaultClientId;
    private int defaultConnectorKeepAlive;
    private int defaultConnectorMinDelay;
    private int defaultConnectorMaxQueue;
    private int sessionKeepAlive;
    private Set sessionKeepAliveClients = Collections.EMPTY_SET;
    private Set defaultDenyList = new HashSet();
    private CacheHandler cacheHandler;
    private UserManager userManager;
    private CwsConnectorManager connManager;
    private RemoteHandler remoteHandler;
    private ProxyLogger logger;
    private CamdMessageListener defaultListener;
    private Map proxyPlugins = new HashMap();
    private Map pluginLoadData = new HashMap();
    private Map profiles = new HashMap();
    private Map profilesById = new HashMap();
    private Set disabledProfiles = new HashSet();
    private boolean sidLinkerEnabled;
    private SidCacheLinker sidLinker;
    private Properties previousPortCfg;
    private ListenPort extendedPort;

    public static ProxyConfig getInstance() {
        if (instance == null) {
            instance = new ProxyConfig();
        }
        return instance;
    }

    private ProxyConfig() {
    }

    public Map getProfiles() {
        return this.profiles;
    }

    public Set getRealProfiles() {
        HashSet real = new HashSet(this.profiles.values());
        real.remove(CaProfile.MULTIPLE);
        return real;
    }

    public CaProfile getProfile(String name) {
        if (name == null) {
            return null;
        }
        return (CaProfile)this.profiles.get(name);
    }

    public CaProfile getProfile() {
        return (CaProfile)this.profiles.values().iterator().next();
    }

    public CaProfile getProfileById(int networkId, int caId) {
        if (networkId == 0) {
            return null;
        }
        return (CaProfile)this.profilesById.get(CaProfile.getKeyStr(networkId, caId));
    }

    public String getProfileNameById(int networkId, int caId) {
        CaProfile profile = this.getProfileById(networkId, caId);
        if (profile == null) {
            return null;
        }
        return profile.getName();
    }

    public boolean isLogEcm() {
        return this.logEcm;
    }

    public boolean isLogEmm() {
        return this.logEmm;
    }

    public boolean isLogZap() {
        return this.logZap;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public int getProxyOriginId() {
        return this.proxyOriginId;
    }

    public int getLogRotateCount() {
        return this.logRotateCount;
    }

    public int getLogRotateLimit() {
        return this.logRotateLimit;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isIncludeFileEvents() {
        return this.wtIncludeFile;
    }

    public boolean isHideIPs() {
        return this.hideIPs;
    }

    public boolean isUserAllowOnFailure() {
        return this.userAllowOnFailure;
    }

    public boolean isUserAllowDifferentIp() {
        return this.userAllowDifferentIp;
    }

    public boolean isLogFailures() {
        return this.logFailures;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isBlockCaidMismatch() {
        return this.blockCaidMismatch;
    }

    public byte[] getDefaultProfileDesKey() {
        return this.defaultProfileDesKey;
    }

    public Set getDefaultDenyList() {
        return this.defaultDenyList;
    }

    public byte[] getDefaultConnectorDesKey() {
        return this.defaultConnectorDesKey;
    }

    public byte[] getDefaultClientId() {
        return this.defaultClientId;
    }

    public int getDefaultConnectorKeepAlive() {
        return this.defaultConnectorKeepAlive;
    }

    public int getSessionKeepAlive() {
        return this.sessionKeepAlive;
    }

    public Set getKeepAliveExcludedClients() {
        return this.sessionKeepAliveClients;
    }

    public int getDefaultConnectorMinDelay() {
        return this.defaultConnectorMinDelay;
    }

    public int getDefaultConnectorMaxQueue() {
        return this.defaultConnectorMaxQueue;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getNewcamdMaxMsgSize() {
        return this.newcamdMaxMsgSize;
    }

    public CwsConnectorManager getConnManager() {
        return this.connManager;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public SidCacheLinker getSidCacheLinker() {
        if (!this.sidLinkerEnabled) {
            return null;
        }
        return this.sidLinker;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public RemoteHandler getRemoteHandler() {
        return this.remoteHandler;
    }

    public void setRemoteHandler(RemoteHandler remoteHandler) {
        this.remoteHandler = remoteHandler;
    }

    public Map getProxyPlugins() {
        return this.proxyPlugins;
    }

    public int getServiceCount() {
        int count = 0;
        Iterator iter = this.profiles.values().iterator();
        while (iter.hasNext()) {
            Map services = ((CaProfile)iter.next()).getServices();
            if (services == null) continue;
            count += services.size();
        }
        return count;
    }

    public TvService getService(CamdNetMessage msg) {
        CaProfile profile = this.getProfile(msg.getProfileName());
        if (profile == null) {
            profile = this.getProfileById(msg.getNetworkId(), msg.getCaId());
        }
        String profileName = profile == null ? "*" : profile.getName();
        return this.getService(profileName, new ServiceMapping(msg));
    }

    public TvService getService(String profileName, ServiceMapping id) {
        TvService service = this.getService(profileName, id.serviceId);
        return new TvService(service, id.getCustomData());
    }

    public TvService getService(String profileName, int serviceId) {
        if (serviceId == 0 || profileName == null || this.connManager.isServiceUnknown(profileName, serviceId)) {
            return TvService.getUnknownService(profileName, serviceId);
        }
        Integer id = new Integer(serviceId);
        CaProfile profile = (CaProfile)this.profiles.get(profileName);
        TvService service = (TvService)profile.getServices().get(id);
        if (service == null) {
            return TvService.getUnknownService(profileName, serviceId);
        }
        return service;
    }

    public String getServiceName(String profileName, ServiceMapping id) {
        TvService service = this.getService(profileName, id.serviceId);
        if (service == null) {
            return id.toString();
        }
        return id + "/" + service.getName();
    }

    public String getServiceName(CamdNetMessage msg) {
        TvService service = this.getService(msg);
        if (service == null) {
            return new ServiceMapping(msg).toString();
        }
        return new ServiceMapping(service) + "/" + service.getName();
    }

    public String getServiceName(String profileName, int serviceId) {
        TvService service = this.getService(profileName, serviceId);
        if (service == null) {
            return Integer.toHexString(serviceId);
        }
        return Integer.toHexString(serviceId) + "/" + service.getName();
    }

    public int getServiceType(String profileName, int serviceId) {
        TvService service = this.getService(profileName, serviceId);
        if (service == null) {
            return -1;
        }
        return service.getType();
    }

    public boolean isTransactionWarning(String flags, int duration) {
        boolean warning;
        block3: {
            block1: {
                block2: {
                    warning = false;
                    if (duration <= this.wtMaxDelay) break block1;
                    if (flags.indexOf(68) <= -1) break block2;
                    if ((long)duration >= this.connManager.getMaxCwWait(null)) break block3;
                    warning = true;
                    break block3;
                }
                warning = true;
                break block3;
            }
            for (int i = 0; i < flags.length(); ++i) {
                if (this.wtBadFlags.indexOf(flags.charAt(i)) <= -1) continue;
                warning = true;
                break;
            }
        }
        return warning;
    }

    public synchronized void parseConfig(ProxyXmlConfig currentConfig) throws ConfigException {
        String version = currentConfig.getStringValue("ver");
        if (!version.equals("0.9.0")) {
            throw new ConfigException("Config file version '" + version + " does not match application version '" + "0.9.0" + "'.");
        }
        ProxyXmlConfig logConfig = currentConfig.getSubConfig("logging");
        this.logEcm = "true".equalsIgnoreCase(logConfig.getStringValue("log-ecm", "true"));
        this.logEmm = "true".equalsIgnoreCase(logConfig.getStringValue("log-emm", "true"));
        this.logZap = "true".equalsIgnoreCase(logConfig.getStringValue("log-zapping", "true"));
        this.logRotateLimit = 0;
        this.logRotateCount = 0;
        try {
            ProxyXmlConfig logFileConfig = logConfig.getSubConfig("log-file");
            this.logRotateCount = logFileConfig.getIntValue("rotate-count");
            if (this.logRotateCount < 1) {
                this.logRotateCount = 0;
            }
            this.logRotateLimit = logFileConfig.getIntValue("rotate-max-size");
            if (this.logRotateLimit < 1) {
                this.logRotateLimit = 0;
            }
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.logFile = logConfig.getFileValue("log-file", true);
        if (this.logRotateCount <= 0 || this.logRotateLimit <= 0 || !new File(this.logFile).delete()) {
            // empty if block
        }
        this.logLevel = logConfig.getStringValue("log-level");
        this.silent = "true".equalsIgnoreCase(logConfig.getStringValue("silent", "false"));
        this.debug = "true".equalsIgnoreCase(logConfig.getStringValue("debug", "false"));
        this.hideIPs = "true".equalsIgnoreCase(logConfig.getStringValue("hide-ip-addresses", "false"));
        try {
            CustomFormatter.setDateFormat(new SimpleDateFormat(logConfig.getStringValue("log-dateformat", "yyMMdd HH:mm:ss.SSS")));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(logConfig.getFullName(), "Illegal date format: " + e.getMessage());
        }
        try {
            ProxyXmlConfig wtConfig = logConfig.getSubConfig("warning-threshold");
            this.wtBadFlags = wtConfig.getStringValue("bad-flags");
            this.wtMaxDelay = wtConfig.getTimeValue("max-delay", "ms");
            this.wtIncludeFile = "true".equalsIgnoreCase(wtConfig.getStringValue("include-file-events", "true"));
        }
        catch (ConfigException e) {
            this.wtBadFlags = "YMNTSAOQGXWDHU-";
            this.wtMaxDelay = 5000;
            this.wtIncludeFile = true;
        }
        try {
            ProxyXmlConfig etConfig = logConfig.getSubConfig("event-threshold");
            this.etMinCount = etConfig.getIntValue("min-count", 1);
        }
        catch (ConfigException e) {
            this.etMinCount = 1;
        }
        ProxyXmlConfig umConfig = currentConfig.getSubConfig("user-manager");
        this.userAllowOnFailure = "true".equalsIgnoreCase(umConfig.getStringValue("allow-on-failure", "false"));
        this.userAllowDifferentIp = "true".equalsIgnoreCase(umConfig.getStringValue("allow-different-ip", "false"));
        this.logFailures = "true".equalsIgnoreCase(umConfig.getStringValue("log-failures", "true"));
        ProxyXmlConfig profileConf = currentConfig.getSubConfig("ca-profiles");
        try {
            this.defaultProfileDesKey = profileConf.getBytesValue("default-des-key");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.defaultDenyList.clear();
        try {
            String denyList = profileConf.getStringValue("default-deny-list");
            this.defaultDenyList.addAll(Arrays.asList(denyList.split(" ")));
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.maxThreads = profileConf.getIntValue("max-threads", 1000);
        this.maxPending = profileConf.getIntValue("max-pending", 3);
        this.sessionTimeout = profileConf.getTimeValue("session-timeout", 240, "m");
        this.newcamdMaxMsgSize = profileConf.getIntValue("newcamd-maxmsgsize", 400);
        this.blockCaidMismatch = "true".equalsIgnoreCase(profileConf.getStringValue("block-caid-mismatch", "true"));
        this.maxConnectionsIP = profileConf.getIntValue("max-connections-ip", 0);
        ProxyXmlConfig keepAliveConf = null;
        try {
            keepAliveConf = profileConf.getSubConfig("session-keepalive");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (keepAliveConf != null) {
            this.sessionKeepAlive = profileConf.getTimeValue("session-keepalive", 0, "m");
            String skacStr = keepAliveConf.getStringValue("exclude-clients", "").toLowerCase();
            this.sessionKeepAliveClients = skacStr.length() > 0 ? new HashSet<String>(Arrays.asList(skacStr.split(" "))) : Collections.EMPTY_SET;
        } else {
            this.sessionKeepAliveClients = Collections.EMPTY_SET;
            this.sessionKeepAlive = 0;
        }
        ProxyXmlConfig connManConf = currentConfig.getSubConfig("connection-manager");
        try {
            this.defaultConnectorDesKey = connManConf.getBytesValue("default-des-key");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        try {
            this.defaultClientId = connManConf.getBytesValue("default-client-id");
        }
        catch (ConfigException e) {
            this.defaultClientId = new byte[]{0, 0};
        }
        this.defaultConnectorKeepAlive = connManConf.getTimeValue("default-keepalive-interval", 0, "s");
        this.defaultConnectorMinDelay = connManConf.getTimeValue("default-min-delay", 20, "ms");
        this.defaultConnectorMaxQueue = connManConf.getIntValue("default-max-queue", 50);
        ProxyXmlConfig cacheConf = currentConfig.getSubConfig("cache-handler");
        this.sidLinkerEnabled = "true".equalsIgnoreCase(cacheConf.getStringValue("enable-service-linking", "false"));
        if (this.logger == null) {
            this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        }
        this.loadProfiles(currentConfig);
        this.loadPlugins(currentConfig);
        if (this.rootConfigurable != null) {
            this.rootConfigurable.configUpdated(currentConfig);
        }
        if (!this.firstRead) {
            this.updateModules(currentConfig);
            this.loadCacheLinker();
        }
    }

    public synchronized void readConfig(XmlConfigurable root, File cfgFile) throws FileNotFoundException, ConfigException {
        ProxyXmlConfig currentConfig;
        if (cfgFile == null) {
            this.cfgFile = new File(DEFAULT_CONFIG);
            if (!this.cfgFile.exists()) {
                System.err.println("Config file '" + this.cfgFile.getPath() + "' not found, generating template...");
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(CardServProxy.class.getResourceAsStream("proxy.xml"), "UTF-8"));
                    StringBuffer sb = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    String xml = sb.toString();
                    xml = MessageFormat.format(xml, "0.9.0");
                    this.saveCfgFile(xml.getBytes("UTF-8"));
                    System.err.println("Default su credentials: admin/secret (statusweb @ port 8082)");
                }
                catch (IOException e) {
                    throw new ConfigException("Failed to generate default config: " + e, e);
                }
            }
        } else {
            this.cfgFile = cfgFile;
        }
        this.rootConfigurable = root;
        if (this.fw == null) {
            this.fw = new FileWatchdog(this.cfgFile.getPath(), 3000L);
            this.fw.addFileChangeListener(this);
            this.fw.start();
        }
        try {
            currentConfig = new ProxyXmlConfig(new XMLConfig(new FileInputStream(this.cfgFile), false, "UTF-8"));
        }
        catch (XMLConfigException e) {
            throw new ConfigException("Unable to parse " + this.cfgFile + ": " + e.getMessage(), e);
        }
        this.parseConfig(currentConfig);
        if (this.firstRead) {
            this.firstRead = false;
            this.loadModules(currentConfig);
            this.loadCacheLinker();
        }
    }

    private void loadCacheLinker() {
        if (this.sidLinker == null) {
            this.sidLinker = new SidCacheLinker();
        }
        if (this.sidLinkerEnabled) {
            this.sidLinker.init();
            this.cacheHandler.setListener(this.sidLinker);
        } else {
            this.cacheHandler.setListener(null);
        }
        Iterator iter = this.proxyPlugins.values().iterator();
        while (iter.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)iter.next();
            if (!(plugin instanceof CacheListener)) continue;
            plugin.start((CardServProxy)this.rootConfigurable);
        }
    }

    private void loadProfiles(ProxyXmlConfig currentConfig) throws ConfigException {
        CaProfile profile;
        this.disabledProfiles.clear();
        ProxyXmlConfig profileConf = currentConfig.getSubConfig("ca-profiles");
        Iterator iter = profileConf.getMultipleSubConfigs("profile");
        HashSet<String> newProfiles = new HashSet<String>();
        while (iter.hasNext()) {
            ProxyXmlConfig profileConfig = (ProxyXmlConfig)iter.next();
            profile = (CaProfile)this.profiles.get(profileConfig.getStringValue("name"));
            if (profile == null) {
                profile = new CaProfile();
                profile.configUpdated(profileConfig);
                this.addProfile(profile);
                this.profileChanged(profile, true);
            } else {
                this.profilesById.remove(profile.getKeyStr());
                profile.configUpdated(profileConfig);
                if (!profile.isEnabled()) {
                    this.profiles.remove(profile.getName());
                    this.disabledProfiles.add(profile.getName());
                } else {
                    this.profilesById.put(profile.getKeyStr(), profile);
                }
                this.profileChanged(profile, false);
            }
            newProfiles.add(profile.getName());
        }
        iter = new ArrayList(this.profiles.keySet()).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (CaProfile.MULTIPLE.getName().equals(name) || newProfiles.contains(name)) continue;
            profile = (CaProfile)this.profiles.remove(name);
            this.profilesById.remove(profile.getKeyStr());
            profile.setEnabled(false);
            this.disabledProfiles.remove(profile.getName());
            this.profileChanged(profile, false);
        }
        if (!this.profiles.containsKey(CaProfile.MULTIPLE.getName())) {
            this.addProfile(CaProfile.MULTIPLE);
        }
        this.loadExtendedPort(profileConf);
    }

    public void addProfile(CaProfile profile) throws ConfigException {
        if (profile.isEnabled()) {
            if (this.profiles.containsKey(profile.getName())) {
                throw new ConfigException("ca-profiles", "Duplicate profile definition: " + profile.getName());
            }
            if (this.getProfileById(profile.getNetworkId(), profile.getCaId()) != null) {
                throw new ConfigException("ca-profiles", "Duplicate profile definition for network-id '" + profile.getNetworkIdStr() + "' and ca-id '" + profile.getCaIdStr() + "'.");
            }
            this.profiles.put(profile.getName(), profile);
            this.profilesById.put(profile.getKeyStr(), profile);
            if (this.defaultListener != null) {
                profile.startListening(this.defaultListener);
            }
        } else {
            this.disabledProfiles.add(profile.getName());
        }
    }

    private void loadExtendedPort(ProxyXmlConfig profileConfig) throws ConfigException {
        ProxyXmlConfig port = null;
        try {
            port = profileConfig.getSubConfig("extended-newcamd");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (port != null && "true".equalsIgnoreCase(port.getStringValue("enabled", "true"))) {
            Properties newPortCfg = port.toProperties();
            try {
                boolean debug = "true".equalsIgnoreCase(port.getStringValue("debug"));
                CaProfile.MULTIPLE.setDebug(debug);
            }
            catch (ConfigException e) {
                // empty catch block
            }
            if (newPortCfg.equals(this.previousPortCfg)) {
                return;
            }
            this.previousPortCfg = newPortCfg;
            if (this.extendedPort != null) {
                this.extendedPort.configUpdated(port);
                this.extendedPort.destroy();
                CaProfile.MULTIPLE.removeListenPort(this.extendedPort);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.extendedPort = new ListenPort("ExtNewcamd");
            this.extendedPort.configUpdated(port);
            if (this.defaultListener != null) {
                this.extendedPort.start(this.defaultListener, CaProfile.MULTIPLE);
            }
            CaProfile.MULTIPLE.addListenPort(this.extendedPort);
            this.profileChanged(CaProfile.MULTIPLE, false);
        } else {
            if (this.extendedPort != null) {
                CaProfile.MULTIPLE.removeListenPort(this.extendedPort);
                this.extendedPort.destroy();
                this.extendedPort = null;
            }
            this.previousPortCfg = null;
            this.profileChanged(CaProfile.MULTIPLE, false);
        }
    }

    private void profileChanged(CaProfile profile, boolean added) {
        if (this.connManager != null) {
            this.connManager.cwsProfileChanged(profile, added);
        }
    }

    private void loadModules(ProxyXmlConfig currentConfig) throws ConfigException {
        this.cacheHandler = (CacheHandler)ProxyConfig.loadInstance(currentConfig.getSubConfig("cache-handler"), "cache-config", CacheHandler.class);
        this.userManager = (UserManager)ProxyConfig.loadInstance(currentConfig.getSubConfig("user-manager"), "auth-config", UserManager.class);
        this.connManager = new CwsConnectorManager();
        this.connManager.configUpdated(currentConfig.getSubConfig("connection-manager"));
    }

    private void loadPlugins(ProxyXmlConfig currentConfig) throws ConfigException {
        ProxyXmlConfig pluginConf;
        this.stopPlugins();
        try {
            pluginConf = currentConfig.getSubConfig("proxy-plugins");
        }
        catch (ConfigException e) {
            return;
        }
        Iterator iter = pluginConf.getMultipleSubConfigs("plugin");
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            ProxyXmlConfig tmp = (ProxyXmlConfig)iter.next();
            if (!"true".equalsIgnoreCase(tmp.getStringValue("enabled", "true"))) continue;
            this.loadPlugin(tmp);
        }
    }

    private ProxyPlugin loadPlugin(ProxyXmlConfig tmp) throws ConfigException {
        String jarName;
        ProxyPlugin plugin = (ProxyPlugin)ProxyConfig.loadInstance(tmp, "plugin-config", ProxyPlugin.class);
        this.proxyPlugins.put(plugin.getName().toLowerCase(), plugin);
        if (this.fw != null && (jarName = tmp.getStringValue("jar-file", "")).length() > 0) {
            String jarFile = new File("plugins", jarName).getPath();
            this.pluginLoadData.put(plugin.getName().toLowerCase(), new PluginMetaData(tmp, jarFile));
            this.fw.addFile(jarFile);
        }
        return plugin;
    }

    public void stopPlugins() {
        if (!this.proxyPlugins.isEmpty() && this.logger != null) {
            this.logger.info("Stopping " + this.proxyPlugins.size() + " loaded plugins...");
        }
        Iterator iter = this.proxyPlugins.values().iterator();
        while (iter.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)iter.next();
            this.stopPlugin(plugin);
            iter.remove();
        }
        this.proxyPlugins.clear();
        this.pluginLoadData.clear();
        System.gc();
        System.runFinalization();
    }

    private void stopPlugin(ProxyPlugin plugin) {
        String jarFile;
        block5: {
            try {
                plugin.stop();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.warning("Uncaught exception in plugin stop() for '" + plugin.getName() + "': " + t);
                }
                if (this.logger == null) break block5;
                this.logger.throwing(t);
            }
        }
        ClassLoader cl = plugin.getClass().getClassLoader();
        if (cl instanceof PluginClassLoader) {
            ((PluginClassLoader)cl).flush();
        }
        if (this.fw != null && this.pluginLoadData.containsKey(plugin.getName()) && (jarFile = ((PluginMetaData)this.pluginLoadData.get((Object)plugin.getName().toLowerCase())).jarFile) != null) {
            this.fw.removeFile(jarFile);
        }
    }

    private void updateModules(ProxyXmlConfig currentConfig) throws ConfigException {
        this.cacheHandler.configUpdated(currentConfig.getSubConfig("cache-handler").getSubConfig("cache-config"));
        this.userManager.configUpdated(currentConfig.getSubConfig("user-manager").getSubConfig("auth-config"));
        this.connManager.configUpdated(currentConfig.getSubConfig("connection-manager"));
    }

    public static Object loadInstance(ProxyXmlConfig subConf, String confName, Class intf) throws ConfigException {
        return ProxyConfig.loadInstance(subConf, confName, intf, null);
    }

    private static Object loadInstance(ProxyXmlConfig subConf, String confName, Class intf, ClassLoader cl) throws ConfigException {
        XmlConfigurable xc;
        Class<?> c;
        String jarName;
        String className = subConf.getStringValue("class");
        if (cl == null && !"".equals(jarName = subConf.getStringValue("jar-file", ""))) {
            File jarFile = null;
            try {
                jarFile = new File("plugins", jarName);
                if (!jarFile.exists()) {
                    throw new ConfigException(subConf.getFullName(), "File not found: " + jarFile.getAbsolutePath());
                }
                cl = new PluginClassLoader(jarFile, ProxyConfig.class.getClassLoader());
            }
            catch (IOException e) {
                throw new ConfigException(subConf.getFullName(), "Bad jar-file: " + jarFile.getAbsolutePath(), e);
            }
        }
        try {
            c = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
            if (!intf.isAssignableFrom(c)) {
                throw new ConfigException(subConf.getFullName(), "Class '" + className + "' does not implement interface: " + intf.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException(subConf.getFullName(), "Class not found: " + className);
        }
        catch (NoClassDefFoundError e) {
            throw new ConfigException(subConf.getFullName(), "Class defs not found: " + e.getMessage());
        }
        try {
            xc = (XmlConfigurable)c.newInstance();
        }
        catch (Exception e) {
            throw new ConfigException(subConf.getFullName(), "Unable to instantiate class '" + className + "': " + e, e);
        }
        if (confName != null) {
            ProxyXmlConfig pluginConfig = null;
            try {
                pluginConfig = subConf.getSubConfig(confName);
            }
            catch (ConfigException e) {
                // empty catch block
            }
            if (pluginConfig == null) {
                xc.configUpdated(new ProxyXmlConfig("plugin-config", "/cardserv-proxy/proxy-plugins/plugin"));
            } else {
                xc.configUpdated(pluginConfig);
            }
        }
        return xc;
    }

    public void fileChanged(String fileName) {
        if (this.logger == null) {
            this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        }
        this.logger.info("File changes detected: " + fileName);
        if (this.cfgFile.getPath().equals(fileName)) {
            try {
                this.readConfig(this.rootConfigurable, new File(fileName));
            }
            catch (FileNotFoundException e) {
                this.logger.severe("Configuration file not found: " + fileName);
            }
            catch (ConfigException e) {
                ProxyConfig.logConfigException(this.logger, e);
            }
            catch (Exception e) {
                this.logger.severe("Internal error updating configuration: " + e, e);
            }
        } else if (fileName.endsWith(".jar")) {
            Iterator iter = new ArrayList(this.proxyPlugins.keySet()).iterator();
            while (iter.hasNext()) {
                PluginMetaData pm;
                String name = (String)iter.next();
                if (name == null || (pm = (PluginMetaData)this.pluginLoadData.get(name)) == null || !fileName.equals(pm.jarFile)) continue;
                this.logger.info("Stopping plugin '" + this.proxyPlugins.get(name).getClass() + "'...");
                this.stopPlugin((ProxyPlugin)this.proxyPlugins.get(name));
                this.proxyPlugins.remove(name);
                this.pluginLoadData.remove(name);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.gc();
                System.runFinalization();
                ProxyPlugin plugin = null;
                try {
                    plugin = this.loadPlugin(pm.config);
                    this.logger.info("Starting plugin '" + this.proxyPlugins.get(name).getClass() + "'...");
                    plugin.start((CardServProxy)this.rootConfigurable);
                }
                catch (ConfigException e) {
                    ProxyConfig.logConfigException(this.logger, e);
                    if (plugin == null) continue;
                    this.proxyPlugins.remove(plugin.getName().toLowerCase());
                }
            }
        }
    }

    public void setDefaultMsgListener(CamdMessageListener listener) {
        this.defaultListener = listener;
        this.started = true;
        if (this.extendedPort != null) {
            this.extendedPort.start(listener, CaProfile.MULTIPLE);
        }
    }

    public CamdMessageListener getDefaultMsgListener() {
        return this.defaultListener;
    }

    public File getCfgFile() {
        return this.cfgFile;
    }

    public void saveCfgFile(byte[] newFile) throws IOException {
        if (this.fw != null) {
            this.fw.removeFile(this.cfgFile.getPath());
        }
        if (!this.cfgFile.exists() || !this.cfgFile.renameTo(new File(this.cfgFile.getPath() + ".bak"))) {
            // empty if block
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.cfgFile));
        bos.write(newFile);
        bos.close();
        if (this.fw != null) {
            this.fw.addFile(this.cfgFile.getPath());
        }
    }

    public int getEtMinCount() {
        return this.etMinCount;
    }

    public int getMaxPending() {
        return this.maxPending;
    }

    public int getMaxConnectionsIP() {
        return this.maxConnectionsIP;
    }

    public boolean isProfileDisabled(String profileName) {
        return this.disabledProfiles.contains(profileName);
    }

    public static void logConfigException(ProxyLogger logger, ConfigException e) {
        logger.severe("Configuration error:");
        if (e.getLabel() != null) {
            if (e.getLabel().indexOf(32) == -1) {
                logger.severe("- Element: <" + e.getLabel() + ">");
            } else {
                logger.severe("- Element: <" + e.getLabel());
                if (e.getSubLabel() != null) {
                    logger.severe("- Attribute: " + e.getSubLabel());
                }
            }
        }
        logger.severe("- Message: " + e.getMessage());
    }

    public static String providerIdentsToString(Set providers) {
        TreeSet<String> set = new TreeSet<String>();
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            set.add(DESUtil.intToByteString((Integer)iter.next(), 3));
        }
        return ((Object)set).toString();
    }

    public static String providerIdentsToString(Integer[] providers) {
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < providers.length; ++i) {
            set.add(DESUtil.intToByteString(providers[i], 3));
        }
        return ((Object)set).toString();
    }

    public static Set getServiceTokens(String param, String list, boolean excludeCdata) throws ConfigException {
        HashSet<ServiceMapping> result = new HashSet<ServiceMapping>();
        String[] tokens = list.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            String[] service = tokens[i].split(":");
            try {
                ServiceMapping sm = new ServiceMapping(Integer.parseInt(service[0], 16), 0L);
                boolean identSet = false;
                if (!excludeCdata && service.length >= 2) {
                    if (service[1].length() > 4) {
                        sm.setProviderIdent(Integer.parseInt(service[1], 16));
                        identSet = true;
                    } else {
                        sm.setCustomId(Integer.parseInt(service[1], 16));
                    }
                    if (service.length == 3) {
                        if (service[2].length() > 4) {
                            sm.setProviderIdent(Integer.parseInt(service[1], 16));
                            identSet = true;
                        } else {
                            sm.setCustomId(Integer.parseInt(service[2], 16));
                        }
                    }
                }
                if (!identSet) {
                    sm.setProviderIdent(0xFFFFFF);
                }
                result.add(sm);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigException(param, "Bad hex integer value: " + e.getMessage());
            }
        }
        return result;
    }

    private static class PluginMetaData {
        ProxyXmlConfig config;
        String jarFile;

        private PluginMetaData(ProxyXmlConfig config, String jarFile) {
            this.config = config;
            this.jarFile = jarFile;
        }
    }
}

