/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.NewcamdConnection;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.AbstractCwsConnector;
import com.bowman.cardserv.cws.ChameleonCwsConnector;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.QueueEntry;
import com.bowman.cardserv.interfaces.CamdConstants;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class NewcamdCwsConnector
extends AbstractCwsConnector
implements CamdConstants {
    String user;
    String password;
    private byte[] configKey14;
    byte[] clientId;
    boolean noEncrypt;
    boolean overrideChecks;
    private boolean tracing;
    CardData remoteCard;
    private Thread keepAliveThread = null;
    private int keepAliveInterval;
    private int emmCount;
    private int keepAliveCount;
    NewcamdConnection conn;
    private ProxyXmlConfig lastXml;
    private Map caidProfileMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        Object auUsersStr;
        byte[] configKey14;
        boolean enabled;
        String password;
        String user;
        int port;
        String host;
        block26: {
            super.configUpdated(xml);
            host = xml.getStringValue("host");
            port = xml.getPortValue("port");
            user = xml.getStringValue("user");
            password = xml.getStringValue("password");
            enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
            this.noEncrypt = "true".equalsIgnoreCase(xml.getStringValue("no-encryption", "false"));
            try {
                configKey14 = xml.getBytesValue("des-key");
            }
            catch (ConfigException e) {
                configKey14 = this.config.getDefaultConnectorDesKey();
                if (configKey14 != null) break block26;
                throw e;
            }
        }
        this.keepAliveInterval = xml.getTimeValue("keepalive-interval", 0, "s");
        if (this.keepAliveInterval == 0) {
            this.keepAliveInterval = this.config.getDefaultConnectorKeepAlive();
        }
        this.clientId = new byte[]{0, 0};
        try {
            this.clientId = xml.getBytesValue("client-id");
        }
        catch (ConfigException e) {
            this.clientId = this.config.getDefaultClientId();
        }
        try {
            this.auUsers.clear();
            UserManager um = this.config.getUserManager();
            auUsersStr = xml.getStringValue("au-users");
            StringTokenizer st = new StringTokenizer((String)auUsersStr);
            while (st.hasMoreTokens()) {
                String auUser = st.nextToken().trim();
                if (!um.exists(auUser)) {
                    this.logger.warning("AU-user '" + auUser + "' for " + this.getLabel() + " doesn't exist, skipping...");
                    continue;
                }
                this.auUsers.add(auUser);
            }
        }
        catch (ConfigException e) {
            this.auUsers.clear();
        }
        this.tracing = "true".equalsIgnoreCase(xml.getStringValue("tracing", "false"));
        if (this.conn != null) {
            this.conn.setTraceLabel(this.tracing ? this.name : null);
        }
        this.overrideChecks = "true".equalsIgnoreCase(xml.getStringValue("override-checks", "false"));
        this.asynchronous = "true".equalsIgnoreCase(xml.getStringValue("asynchronous", "false"));
        if (this.asynchronous) {
            this.logger.info("Using asynchronous newcamd mode.");
        }
        boolean changed = !host.equals(this.host) || port != this.port || !user.equals(this.user) || !password.equals(this.password) || enabled != this.enabled || !Arrays.equals(configKey14, this.configKey14);
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.enabled = enabled;
        this.configKey14 = configKey14;
        if (!enabled) {
            this.close();
        }
        if (changed && enabled) {
            this.close();
            if (this.connManager != null) {
                auUsersStr = this.connManager;
                synchronized (auUsersStr) {
                    this.connManager.notifyAll();
                }
            }
        }
        if (this.noProfile && !(this instanceof ChameleonCwsConnector)) {
            String mapStr = xml.getStringValue("caid-profile-map");
            String[] pairs = mapStr.split(" ");
            if (pairs.length < 1) {
                throw new ConfigException(xml.getFullName(), "caid-profile-map", "Invalid profile map: " + mapStr);
            }
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (int i = 0; i < pairs.length; ++i) {
                String[] kv = pairs[i].split("=");
                if (kv.length != 2) {
                    throw new ConfigException(xml.getFullName(), "caid-profile-map", "Invalid map entry: " + pairs[i]);
                }
                if (this.config.getProfile(kv[1]) == null) {
                    if (this.config.isProfileDisabled(kv[1])) continue;
                    throw new ConfigException(xml.getFullName(), "caid-profile-map", "Invalid map entry in '" + mapStr + "', unknown profile: " + kv[1]);
                }
                try {
                    map.put(new Integer(Integer.parseInt(kv[0], 16)), kv[1]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigException(xml.getFullName(), "caid-profile-map", "Invalid map entry in '" + mapStr + "', bad hex integer: " + kv[0]);
                }
            }
            if (this.profile == null) {
                this.logger.warning("No profile configured for '" + this.name + "', will attempt to find a profile by ca-id on connect, using map: " + mapStr);
            }
            this.caidProfileMap = map;
        } else {
            this.caidProfileMap = null;
        }
        this.logger.fine("Configuration updated. Enabled: " + enabled + " Changed: " + changed + " AU-users: " + this.auUsers);
        this.lastXml = xml;
    }

    void doLogin(CamdNetMessage loginMsg) throws IOException {
        this.conn.init(this.logger);
        this.conn.setMaxSize(this.config.getNewcamdMaxMsgSize());
        this.conn.serverHandshake(this.configKey14);
        this.sendMessage(loginMsg);
        if (this.conn == null) {
            throw new SocketException("Connection aborted during newcamd handshake.");
        }
        CamdNetMessage msg = this.conn.readMessage();
        if (msg == null || msg.getCommandTag() != 225) {
            if (msg == null) {
                this.logger.warning("Connection was closed on login, bad credentials or des key?");
            } else {
                this.logger.warning("Login failed, received: " + msg.getCommandName());
            }
            this.connManager.cwsConnectionFailed(this, "Login failed (bad password or des key)");
            this.close();
            this.connecting = true;
        } else {
            if (this.conn == null) {
                throw new SocketException("Connection aborted during newcamd handshake.");
            }
            this.conn.setDesKey16(DESUtil.desKeySpread(DESUtil.xorUserPass(this.configKey14, DESUtil.cryptPassword(this.password))));
            this.logger.info("Login successful, key changed");
            this.sendMessage(new CamdNetMessage(227));
            msg = this.conn.readMessage();
            if (msg != null) {
                while (msg.getCommandTag() != 228 && this.conn != null) {
                    this.logger.warning("Expected card data, received: " + msg + " (ignored and discarded)");
                    msg = this.conn.readMessage();
                }
                if (msg != null) {
                    this.setRemoteCard(new CardData(msg.getCustomData(), this.getName()));
                }
            }
            if (this.conn != null) {
                this.connectTimeStamp = System.currentTimeMillis();
                this.connManager.cwsConnected(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.alive = true;
        try {
            this.doLogin(CamdNetMessage.getNewcamdLoginMessage(this.user, this.password, this.clientId));
            if (this.conn != null && this.conn.isConnected()) {
                this.conn.setSoTimeout(0);
                this.connecting = false;
                while (this.alive && this.conn != null) {
                    CamdNetMessage msg = this.conn.readMessage();
                    this.lastSent = null;
                    if (msg == null) {
                        this.alive = false;
                        this.logger.warning("Connection closed");
                        continue;
                    }
                    msg.setCaId(this.remoteCard.getCaId());
                    if (msg.isEcm()) {
                        if (this.reportReply(msg)) continue;
                        this.logger.fine("No listener found for ECM reply: " + msg);
                        continue;
                    }
                    if (msg.isEmm()) {
                        this.logger.fine("EMM reply ignored: " + msg);
                        continue;
                    }
                    if (msg.isKeepAlive()) {
                        this.logger.fine("Keep-alive reply received: [" + msg.getSequenceNr() + "]");
                        this.reportReply(msg);
                        continue;
                    }
                    if (msg.isOsdMsg()) {
                        this.logger.info("Mgcamd OSD message received: " + msg);
                        continue;
                    }
                    this.logger.warning("Unknown msg received from CWS: " + DESUtil.bytesToString(msg.getRawIn()));
                }
            }
        }
        catch (SocketException e) {
            this.logger.warning("Connection closed: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.throwing("Exception reading/decrypting message: " + e, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn = null;
        this.remoteCard = null;
        this.reset();
        if (!this.connecting) {
            this.lastDisconnectTimeStamp = System.currentTimeMillis();
            this.connManager.cwsDisconnected(this);
            CwsConnectorManager cwsConnectorManager = this.connManager;
            synchronized (cwsConnectorManager) {
                this.connManager.notifyAll();
            }
        }
        this.readerThread = null;
        this.connecting = false;
        if (this.noProfile) {
            this.profile = null;
        }
        this.logger.info("Connector dying");
    }

    protected void reportChannelStatus(QueueEntry qe) {
        int provider;
        super.reportChannelStatus(qe);
        CamdNetMessage reply = qe.getReply();
        if (!reply.isEmpty() && this.remoteCard != null && this.remoteCard.getProviders() != null && (provider = reply.getUpperBits() >> 4) >= 0 && provider < this.remoteCard.getProviders().length) {
            reply.setProviderContext(new String[]{this.remoteCard.getProviders()[provider]});
        }
    }

    protected void setRemoteCard(CardData card) {
        String profileName;
        this.remoteCard = card;
        boolean skipChecks = this.overrideChecks;
        if (this.remoteCard.getParseException() != null) {
            this.logger.warning("Failed to parse card data: " + DESUtil.bytesToString(this.remoteCard.getData(false)) + " (" + this.remoteCard.getParseException() + ") - Skipping card checks...");
            skipChecks = true;
        } else {
            this.logger.info("Received card data: " + this.remoteCard);
        }
        if (this.providerIdents == null || this.providerIdents.isEmpty()) {
            this.providerIdents = new HashSet();
            this.providerIdents.addAll(Arrays.asList(card.getProvidersAsInt()));
        }
        if (this.profile != null) {
            this.logger.fine("Preconfigured card profile: " + this.profile);
            if (!skipChecks) {
                this.checkCard(card);
            }
            this.dumpCard(card);
            return;
        }
        if (this.caidProfileMap != null && (profileName = (String)this.caidProfileMap.get(new Integer(this.remoteCard.getCaId()))) != null) {
            this.profile = ProxyConfig.getInstance().getProfile(profileName);
        }
        if (this.profile == null) {
            this.logger.warning("Unknown card! No profile map entry matching id '" + this.remoteCard.getCaIdStr() + "', disconnecting...");
            this.close();
        } else {
            this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName(), this.getLabel());
            if (this.conn != null) {
                this.conn.setLogger(this.logger);
            }
            this.logger.info("Identified card profile: " + this.profile);
            this.dumpCard(card);
            try {
                this.connManager.updateDecodeMaps(this.lastXml, this.name, this.profile.getName());
                this.connManager.updateAuUsers();
            }
            catch (ConfigException e) {
                ProxyConfig.logConfigException(this.logger, e);
            }
        }
        if (!skipChecks) {
            this.checkCard(card);
        }
    }

    private void dumpCard(CardData card) {
        File cardFile = new File("etc", "Cws[" + this.name + "].card");
        if (!card.dump(cardFile)) {
            this.logger.warning("Failed to save card-data to: " + cardFile);
        }
    }

    private void checkCard(CardData card) {
        if (card.getCaId() == 0) {
            this.failCheck("Ca-id of remote card is 0000, disconnecting and awaiting retry...", false);
            return;
        }
        if (this.profile.getCaId() != 0 && this.profile.getCaId() != card.getCaId()) {
            this.failCheck("Ca-id of remote card (" + card.getCaIdStr() + ") does not match preconfigured ca-id for profile: " + this.profile + " (disabling)");
            return;
        }
        Iterator iter = this.connManager.getConnectors(this.profile.getName()).values().iterator();
        while (iter.hasNext()) {
            CwsConnector cws = (CwsConnector)iter.next();
            if (cws == this || !(cws instanceof NewcamdCwsConnector) || !cws.isReady() || cws.getRemoteCard().getParseException() != null) continue;
            if (!cws.getRemoteCard().getProvidersStr().equals(card.getProvidersStr())) {
                this.profile.setMismatchedCards(true);
                this.logger.warning("Cards with different provider idents detected within one profile, merging may be less efficient ('" + this.name + "' doesn't match '" + cws.getName() + "').");
            }
            if (cws.getRemoteCard().getCaId() == card.getCaId()) continue;
            this.failCheck("Ca-id of remote card (" + card.getCaIdStr() + ") does not match already connected newcamd-connector (" + cws.getRemoteCard().getCaIdStr() + " (disabling)");
        }
    }

    private void failCheck(String message) {
        this.failCheck(message, true);
    }

    private void failCheck(String message, boolean disable) {
        if (disable) {
            this.logger.severe(message);
            this.enabled = false;
        } else {
            this.logger.warning(message);
        }
        this.close();
        this.connManager.cwsInvalidCard(this, message);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public boolean isReady() {
        return this.isConnected() && this.remoteCard != null;
    }

    public CardData getRemoteCard() {
        return this.remoteCard;
    }

    public long getLastTrafficTimeStamp() {
        if (this.conn == null) {
            return -1L;
        }
        return this.conn.getLastTrafficTimeStamp();
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public boolean sendEcmRequest(CamdNetMessage request, ProxySession listener) {
        if (request.getCaId() > 0) {
            request.setCaIdInHdr(request.getCaId());
        }
        if (request.getProviderIdent() > 0) {
            request.setProviderInHdr(request.getProviderIdent());
        }
        return super.sendEcmRequest(request, listener);
    }

    public synchronized int sendMessage(CamdNetMessage msg) {
        if (this.conn == null || !this.conn.isInitialized()) {
            return -1;
        }
        if (msg.isEmm()) {
            ++this.emmCount;
        } else if (msg.isKeepAlive()) {
            ++this.keepAliveCount;
        }
        if (!this.asynchronous && msg.isEcm() && !this.waitForPending()) {
            return -1;
        }
        return this.conn.sendMessage(msg);
    }

    public void sendKeepAlive() {
        long now;
        if (this.isConnected() && this.timeoutCount > 0 && (now = System.currentTimeMillis()) - this.lastEcmTimeStamp > 3000L) {
            this.lastEcmTimeStamp = now;
            if (this.keepAliveThread == null) {
                this.keepAliveThread = new Thread("CwsKeepAliveThread"){

                    public void run() {
                        NewcamdCwsConnector.this.logger.info("Connector unresponsive, forcing keep-alive...");
                        int result = NewcamdCwsConnector.this.sendMessage(new CamdNetMessage(253));
                        NewcamdCwsConnector.this.logger.fine("Result from keep-alive: " + result);
                        if (result == -1) {
                            NewcamdCwsConnector.this.close();
                        } else {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                NewcamdCwsConnector.this.logger.throwing(e);
                            }
                            if (NewcamdCwsConnector.this.timeoutCount > 0) {
                                ++NewcamdCwsConnector.this.timeoutCount;
                            }
                        }
                        NewcamdCwsConnector.this.keepAliveThread = null;
                    }
                };
                if (this.keepAliveThread != null) {
                    this.keepAliveThread.start();
                }
            }
        }
    }

    protected synchronized void connectNative() throws IOException {
        Socket s = new Socket();
        if (this.qosClass != -1) {
            s.setTrafficClass(this.qosClass);
        }
        s.connect(new InetSocketAddress(this.host, this.port), 10000);
        s.setSoTimeout(30000);
        this.conn = new NewcamdConnection(s, this.noEncrypt, true);
        this.conn.setTraceLabel(this.tracing ? this.name : null);
        this.logger.info("Connected, authorizing...");
        this.emmCount = 0;
    }

    public boolean isAuAllowed(String userName) {
        return this.auUsers.contains(userName);
    }

    public String[] getAuUsers() {
        return this.auUsers.toArray(new String[this.auUsers.size()]);
    }

    public String getProtocol() {
        return "Newcamd";
    }

    public String getProfileName() {
        String name = super.getProfileName();
        if (name == null) {
            return "?";
        }
        return name;
    }

    public String getRemoteAddress() {
        if (this.conn == null) {
            return "0.0.0.0";
        }
        return this.conn.getRemoteAddress();
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        super.close();
    }
}

