/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.CwsServiceMapper;
import com.bowman.cardserv.rmi.AbstractStatus;
import com.bowman.cardserv.rmi.PortStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProfileStatus
extends AbstractStatus
implements Serializable {
    private final String name;
    private final String caId;
    private final String networkId;
    private final String providerIdents;
    private final int services;
    private final int conflicts;
    private final int sessions;
    private final long maxCwWait;
    private final long congestionLimit;
    private final long maxCacheWait;
    private final List listenPorts = new ArrayList();
    private final boolean enabled;
    private final boolean cacheOnly;
    private final boolean debug;
    private final boolean mismatchedCards;
    private final boolean requiresProviderMatch;
    private final String resetStr;
    private final String blockedStr;
    private final String allowedStr;

    public ProfileStatus(CaProfile profile) {
        this.name = profile.getName();
        this.caId = profile.getCaIdStr();
        this.networkId = profile.getNetworkIdStr();
        this.services = profile.getServices().size();
        this.conflicts = profile.getServiceConflicts();
        this.sessions = profile.getSessionCount();
        this.enabled = profile.isEnabled();
        this.cacheOnly = profile.isCacheOnly();
        this.debug = profile.isDebug();
        this.mismatchedCards = profile.isMismatchedCards();
        this.providerIdents = profile.getProviderIdentsStr();
        this.requiresProviderMatch = profile.isRequireProviderMatch();
        Iterator iter = profile.getListenPorts().iterator();
        while (iter.hasNext()) {
            this.listenPorts.add(new PortStatus((ListenPort)iter.next()));
        }
        CwsConnectorManager cm = ProxyConfig.getInstance().getConnManager();
        this.maxCwWait = cm.getMaxCwWait(profile);
        this.congestionLimit = cm.getCongestionLimit(profile);
        this.maxCacheWait = ProxyConfig.getInstance().getCacheHandler().getMaxCacheWait(this.maxCwWait);
        CwsServiceMapper csm = cm.getServiceMapper(this.name);
        this.resetStr = csm.getResetServicesStr();
        this.blockedStr = csm.getBlockedServicesStr();
        this.allowedStr = csm.getAllowedServicesStr();
    }

    public String getName() {
        return this.name;
    }

    public String getCaId() {
        return this.caId;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public PortStatus[] getListenPorts() {
        if (this.listenPorts == null || this.listenPorts.isEmpty()) {
            return new PortStatus[0];
        }
        return this.listenPorts.toArray(new PortStatus[this.listenPorts.size()]);
    }

    public int getServices() {
        return this.services;
    }

    public int getConflicts() {
        return this.conflicts;
    }

    public int getSessions() {
        return this.sessions;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCacheOnly() {
        return this.cacheOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isMismatchedCards() {
        return this.mismatchedCards;
    }

    public String getProviderIdents() {
        return this.providerIdents;
    }

    public boolean isRequiresProviderMatch() {
        return this.requiresProviderMatch;
    }

    public long getMaxCwWait() {
        return this.maxCwWait;
    }

    public long getCongestionLimit() {
        return this.congestionLimit;
    }

    public long getMaxCacheWait() {
        return this.maxCacheWait;
    }

    public String getResetStr() {
        return this.resetStr;
    }

    public String getBlockedStr() {
        return this.blockedStr;
    }

    public String getAllowedStr() {
        return this.allowedStr;
    }
}

