/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.rmi.AbstractStatus;
import java.io.Serializable;

public class RemoteEvent
extends AbstractStatus
implements Serializable {
    private static final long serialVersionUID = -8437139570142317227L;
    public static final int USER_LOGINFAIL = -2;
    public static final int USER_LOGOUT = -1;
    public static final int USER_LOGIN = 0;
    public static final int USER_STATUS_CHANGED = 1;
    public static final int CWS_CONNECTED = 2;
    public static final int CWS_DISCONNECTED = 3;
    public static final int CWS_CONNECTION_FAILED = 4;
    public static final int CWS_WARNING = 5;
    public static final int CWS_LOST_SERVICE = 6;
    public static final int CWS_FOUND_SERVICE = 9;
    public static final int ECM_TRANSACTION = 7;
    public static final int CWS_INVALID_CARD = 8;
    public static final int PROXY_STARTUP = 10;
    public static final int LOG_EVENT = 11;
    private final long timeStamp;
    private final int type;
    private final String message;
    private final String label;
    private final String profile;

    public RemoteEvent(int type, String label, String message, String profile) {
        this.timeStamp = System.currentTimeMillis();
        this.type = type;
        this.message = message;
        this.label = label;
        this.profile = profile;
    }

    public RemoteEvent(RemoteEvent event) {
        this.timeStamp = event.timeStamp;
        this.type = event.type;
        this.message = event.message;
        this.label = event.label;
        this.profile = event.profile;
        this.data = event.data;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public String getProfile() {
        return this.profile;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteEvent event = (RemoteEvent)o;
        if (this.type != event.type) {
            return false;
        }
        if (this.label != null ? !this.label.equals(event.label) : event.label != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(event.profile) : event.profile != null) {
            return false;
        }
        return !"true".equalsIgnoreCase(this.data.getProperty("warning")) || this.getProperty("flags").equals(event.getProperty("flags"));
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        if ("true".equalsIgnoreCase(this.getProperty("warning"))) {
            result = 31 * result + this.getProperty("flags").hashCode();
        }
        return result;
    }
}

