/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.httpd;

import com.bowman.httpd.HttpConstants;
import com.bowman.httpd.PseudoHttpd;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpRequest
implements HttpConstants {
    private String request;
    private String method;
    private String queryString;
    private String remoteAddress;
    private Map headers;
    private Map params;
    private Map cookies;
    private byte[] content;
    private Socket conn;

    public HttpRequest(String request, Map headers, String remoteAddress) {
        this.request = request;
        this.remoteAddress = remoteAddress;
        StringTokenizer st = new StringTokenizer(request);
        this.method = st.nextToken().toUpperCase();
        try {
            this.queryString = st.nextToken();
            this.queryString = URLDecoder.decode(this.queryString, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.headers = headers;
        this.params = HttpRequest.parseParams(this.queryString);
        this.cookies = HttpRequest.parseCookies(this.getHeader("cookie"));
        if (this.isParamPost()) {
            this.params.putAll(HttpRequest.parseParams(this.getContentStr()));
        }
    }

    public boolean isParamPost() {
        String type = this.getHeader("content-type");
        if (type == null) {
            return false;
        }
        return "POST".equals(this.method) && type.toLowerCase().startsWith("application/x-www-form-urlencoded");
    }

    public String getRequest() {
        return this.request;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String name) {
        return (String)this.params.get(name);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name.toLowerCase());
    }

    public Date getDateHeader(String name) {
        String dateStr = this.getHeader(name);
        if (dateStr == null) {
            return null;
        }
        if (dateStr.indexOf(59) != -1) {
            dateStr = dateStr.substring(0, dateStr.indexOf(59));
        }
        try {
            return PseudoHttpd.parseDate(HttpConstants.httpDateFmt, dateStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCookie(String name) {
        return (String)this.cookies.get(name);
    }

    public String getEncoding() {
        String type = this.getHeader("content-type");
        int idx = type.indexOf(59);
        if (idx > -1 && type.substring(idx + 1).toLowerCase().startsWith("charset=")) {
            return type.substring(type.indexOf(61) + 1).trim();
        }
        return "UTF-8";
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Map getParams() {
        return this.params;
    }

    public String[] getParamNames() {
        return this.params.keySet().toArray(new String[this.params.size()]);
    }

    public String[] getCookieNames() {
        return this.cookies.keySet().toArray(new String[this.cookies.size()]);
    }

    public Map getCookies() {
        return this.cookies;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public DataInputStream getContentInputStream() throws IOException {
        return new DataInputStream(this.conn.getInputStream());
    }

    public void setConnection(Socket conn) {
        this.conn = conn;
    }

    public Socket getConnection() {
        return this.conn;
    }

    public String getContentStr() {
        String enc = this.getEncoding();
        try {
            return new String(this.content, enc);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new String(this.content, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.content);
            }
        }
    }

    public String toString() {
        return this.method + " " + this.queryString + "\n" + this.headers;
    }

    private static Map parseCookies(String cookieHdr) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (cookieHdr != null) {
            StringTokenizer st = new StringTokenizer(cookieHdr, ";");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken().trim();
                int idx = pair.indexOf(61);
                if (idx <= -1) continue;
                cookies.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return cookies;
    }

    private static Map parseParams(String queryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        int idx = queryString.indexOf(63);
        if (idx > -1 && idx < queryString.length()) {
            StringTokenizer st = new StringTokenizer(queryString.substring(idx + 1), "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                idx = pair.indexOf(61);
                if (idx <= -1) continue;
                try {
                    params.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Internal error: " + e);
                }
            }
        }
        return params;
    }
}

