/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc;

import com.bowman.irc.IrcWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IrcMessage
implements Serializable {
    private String source;
    private String nick;
    private String host;
    private boolean server;
    private boolean ctcp;
    private int code;
    private String line;
    private String command;
    private String ctcpCmd;
    private String trailing;
    private String ctcpArgs;
    private Vector params;

    public IrcMessage(String im) {
        this.line = im;
        this.params = new Vector();
        try {
            StringTokenizer st = new StringTokenizer(im, " ", false);
            this.source = im.startsWith(":") ? st.nextToken().substring(1) : "";
            String tmp = st.nextToken();
            try {
                this.code = Integer.parseInt(tmp);
                this.server = true;
            }
            catch (Exception e) {
                this.code = 0;
                this.command = tmp;
                this.server = false;
            }
            while (st.hasMoreTokens()) {
                tmp = st.nextToken();
                if (tmp.startsWith(":")) {
                    try {
                        tmp = tmp + st.nextToken("\n");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.params.addElement(tmp.substring(1).trim());
                } else {
                    this.params.addElement(tmp.trim());
                }
                this.trailing = tmp;
            }
            if (this.trailing.startsWith(":")) {
                this.trailing = this.trailing.substring(1);
            }
            if (this.trailing.startsWith("\u0001")) {
                this.trailing = this.trailing.substring(1, this.trailing.length() - 1);
                this.ctcp = true;
                int sep = this.trailing.indexOf(" ");
                if (sep > 0) {
                    this.ctcpCmd = this.trailing.substring(0, sep);
                    this.ctcpArgs = this.trailing.substring(sep + 1);
                } else {
                    this.ctcpCmd = this.trailing;
                    this.ctcpArgs = "";
                }
            } else {
                this.ctcpCmd = "";
                this.ctcpArgs = "";
                this.ctcp = false;
            }
        }
        catch (Exception e) {
            System.err.println("Error in msg parsing!");
            e.printStackTrace();
        }
        try {
            this.nick = this.source.substring(0, this.source.indexOf("!"));
        }
        catch (Exception e) {
            this.nick = this.source;
        }
        try {
            this.host = this.source.substring(this.source.indexOf("!") + 1);
        }
        catch (Exception e) {
            this.host = "";
        }
    }

    public String mircFormat(String myNick) {
        return this.mircFormat(myNick, false);
    }

    public String mircFormat(String myNick, boolean restrictive) {
        return this.mircFormat(myNick, restrictive, false);
    }

    public String mircFormat(String myNick, boolean restrictive, boolean color) {
        String ml = "";
        String[] prms = this.getParams();
        if (!this.isReply()) {
            if (this.isCtcp()) {
                if (this.getCtcpCmd().equals("ACTION")) {
                    ml = ml + "* " + this.getNick() + " " + this.getCtcpArgs();
                    ml = IrcWriter.colorText(ml, 6);
                } else {
                    if (myNick.equalsIgnoreCase(this.getNick())) {
                        ml = ml + "-> ";
                    }
                    ml = ml + "[" + this.getNick() + " " + this.getCtcpCmd() + (this.getCommand().equals("NOTICE") ? " reply]" : "]");
                    if (this.getCommand().equals("NOTICE")) {
                        if (this.getCtcpCmd().equals("PING")) {
                            long duration = System.currentTimeMillis() - Long.parseLong(this.getCtcpArgs());
                            System.out.println(duration);
                            ml = ml + " " + IrcMessage.makeDurationStr(Math.round((double)duration / 1000.0));
                        } else {
                            ml = ml + " " + this.getCtcpArgs();
                        }
                    }
                    ml = IrcWriter.colorText(ml, 4);
                }
            } else {
                if (this.getCommand().equals("PRIVMSG")) {
                    ml = ml + (restrictive ? "" : "<") + this.getNick() + "> " + this.getText();
                }
                if (this.getCommand().equals("NOTICE")) {
                    ml = this.getSource().equals("") ? ml + "-server- " + this.getText() : (myNick.equalsIgnoreCase(this.getNick()) ? ml + "-" + prms[0] + "- " + this.getText() : ml + "-" + this.getNick() + "- " + this.getText());
                    ml = IrcWriter.colorText(ml, 5);
                }
                if (this.getCommand().equals("QUIT")) {
                    ml = ml + (restrictive ? "**" : "***") + " " + this.getNick() + " has quit IRC (" + this.getText() + ")";
                    ml = IrcWriter.colorText(ml, 2);
                }
                if (this.getCommand().equals("NICK")) {
                    ml = ml + (restrictive ? "**" : "***") + " " + this.getNick() + " is now known as " + this.getText();
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("JOIN")) {
                    ml = this.getNick().equalsIgnoreCase(myNick) ? ml + (restrictive ? "**" : "***") + " Now talking in " + this.getChan() : ml + (restrictive ? "**" : "***") + " " + this.getNick() + " (" + this.getHost() + ") has joined " + this.getText();
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("PART")) {
                    ml = ml + (restrictive ? "**" : "***") + " " + this.getNick() + " (" + this.getHost() + ") has left " + this.getText();
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("MODE")) {
                    String txt = this.getText();
                    if (txt.equals(prms[1])) {
                        txt = "";
                    }
                    ml = ml + (restrictive ? "**" : "***") + " " + this.getNick() + " sets mode: " + prms[1] + " " + txt;
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("KICK")) {
                    ml = ml + (restrictive ? "**" : "***") + " " + prms[1] + " was kicked by " + this.getNick() + " (" + this.getText() + ")";
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("TOPIC")) {
                    ml = ml + (restrictive ? "**" : "***") + " " + this.getNick() + " changes topic to '" + this.getText() + "'";
                    ml = IrcWriter.colorText(ml, 3);
                }
                if (this.getCommand().equals("ERROR")) {
                    ml = ml + this.getText();
                }
            }
        } else {
            int code = this.getCode();
            switch (code) {
                case 5: {
                    ml = "";
                    break;
                }
                case 311: {
                    ml = prms[1] + " is " + prms[2] + "@" + prms[3] + " " + this.getText();
                    break;
                }
                case 319: {
                    ml = prms[1] + " on " + this.getText();
                    break;
                }
                case 312: {
                    ml = prms[1] + " using " + prms[2] + " " + this.getText();
                    break;
                }
                case 318: {
                    ml = prms[1] + " " + this.getText();
                    break;
                }
                case 332: {
                    ml = (restrictive ? "**" : "***") + " Topic is '" + this.getText() + "'";
                    ml = IrcWriter.colorText(ml, 3);
                    break;
                }
                case 333: {
                    ml = (restrictive ? "**" : "***") + " Set by " + prms[2] + " on " + IrcMessage.makeTimeStr(this.getText());
                    ml = IrcWriter.colorText(ml, 3);
                    break;
                }
                case 372: 
                case 375: 
                case 376: {
                    ml = restrictive ? "" : "(motd) " + this.getText();
                    break;
                }
                case 1: {
                    ml = this.getText();
                    break;
                }
                case 353: 
                case 366: {
                    ml = "";
                    break;
                }
                case 401: {
                    ml = prms[1] + " " + this.getText();
                    break;
                }
                case 471: {
                    ml = prms[1] + " unable to join channel (channel full)";
                    break;
                }
                case 475: {
                    ml = prms[1] + " unable to join channel (need correct key)";
                    break;
                }
                default: {
                    if (!ml.equals("")) break;
                    ml = (restrictive ? "(s) " : "(server) ") + this.getAllParams();
                }
            }
            if (code >= 255 && code <= 266) {
                ml = "";
            }
        }
        if (!ml.equals("")) {
            return color ? ml : IrcWriter.stripControlChars(ml);
        }
        return null;
    }

    public String getChan() {
        if (this.getCode() > 470 && this.getCode() < 480) {
            return null;
        }
        String[] params = this.getParams();
        for (int i = 0; i < params.length; ++i) {
            if (!this.getParams()[i].startsWith("#") || this.getParams()[i].indexOf(" ") != -1) continue;
            return this.getParams()[i].toLowerCase();
        }
        if (this.getText().startsWith("#") && this.getText().indexOf(" ") == -1) {
            return this.getText().toLowerCase();
        }
        if (this.isReply()) {
            return null;
        }
        return null;
    }

    public String getNick() {
        return this.nick;
    }

    public String getSource() {
        return this.source;
    }

    public String getHost() {
        return this.host;
    }

    public String getCommand() {
        return this.command;
    }

    public String getText() {
        return this.trailing;
    }

    public String[] getParams() {
        String[] tmp = new String[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            tmp[i] = (String)this.params.elementAt(i);
        }
        return tmp;
    }

    public String getAllParams() {
        String tmp = "";
        for (int i = 0; i < this.params.size(); ++i) {
            if (i <= 0) continue;
            tmp = tmp + " " + (String)this.params.elementAt(i);
        }
        return tmp.trim();
    }

    public int getCode() {
        return this.code;
    }

    public boolean isReply() {
        return this.server;
    }

    public String toString() {
        return this.line;
    }

    public boolean isCtcp() {
        return this.ctcp;
    }

    public String getCtcpCmd() {
        return this.ctcpCmd;
    }

    public String getCtcpArgs() {
        return this.ctcpArgs;
    }

    public String[] getParsedText() {
        StringTokenizer tok = new StringTokenizer(this.trailing);
        String[] tmp = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            tmp[i++] = tok.nextToken();
        }
        return tmp;
    }

    public StringTokenizer getTextTokens() {
        return new StringTokenizer(this.trailing);
    }

    public static String makeCtcp(String msg) {
        return '\u0001' + msg + '\u0001';
    }

    public static String makeTimeStr(String msStr) {
        return IrcMessage.makeDate(msStr).toString().substring(0, 20);
    }

    public static Date makeDate(String msStr) {
        return new Date((long)Integer.parseInt(msStr) * 1000L);
    }

    public static String makeDurationStr(long s) {
        if (s == 0L) {
            return "0secs";
        }
        int i = 0;
        String res = "";
        while (s > 0L) {
            switch (i++) {
                case 0: {
                    res = res + s % 60L + "secs";
                    s /= 60L;
                }
                case 1: {
                    if (s % 60L > 0L) {
                        res = s % 60L + "mins " + res;
                    }
                    s /= 60L;
                }
                case 2: {
                    if (s % 24L > 0L) {
                        res = s % 24L + "hours " + res;
                    }
                    s /= 24L;
                }
                case 3: {
                    if (s % 7L > 0L) {
                        res = s % 7L + "days " + res;
                    }
                    s /= 24L;
                }
                case 4: {
                    if (s > 0L) {
                        res = s + "weeks " + res;
                    }
                    s = 0L;
                }
            }
        }
        return res;
    }

    public static String makeDurationStr(String secs) {
        return IrcMessage.makeDurationStr(Integer.parseInt(secs));
    }

    public static String timeStamp() {
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm");
        return "[" + fmt.format(new Date()) + "]";
    }

    public static String getNickFromSource(String ircSource) {
        String nick = null;
        try {
            nick = ircSource.substring(0, ircSource.indexOf("!"));
        }
        catch (Exception e) {
            nick = ircSource;
        }
        return nick;
    }

    public static String getHostFromSource(String ircSource) {
        if (ircSource.indexOf("@") < 0) {
            return null;
        }
        String tmpStr = null;
        StringTokenizer st = new StringTokenizer(ircSource, "@");
        st.nextToken();
        Vector<String> hostParts = new Vector<String>();
        tmpStr = st.nextToken(".").substring(1);
        hostParts.addElement(tmpStr);
        boolean isIp = true;
        while (st.hasMoreElements()) {
            tmpStr = st.nextToken();
            hostParts.addElement(tmpStr);
            if (!isIp) continue;
            try {
                if (Integer.parseInt(tmpStr) <= 255) continue;
                isIp = false;
            }
            catch (NumberFormatException nfe) {
                isIp = false;
            }
        }
        boolean truncated = false;
        if (isIp) {
            hostParts.setSize(2);
        } else {
            while (hostParts.size() > 2) {
                hostParts.removeElementAt(0);
                truncated = true;
            }
        }
        Enumeration enumeration = hostParts.elements();
        String result = (String)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            result = result + "." + (String)enumeration.nextElement();
        }
        if (isIp) {
            result = result + ".*";
        } else if (truncated) {
            result = "*." + result;
        }
        return result;
    }

    public static String getIdentFromSource(String ircSource) {
        if (ircSource.indexOf("!") < 0) {
            return null;
        }
        String ident = ircSource.substring(ircSource.indexOf("!") + 1, ircSource.indexOf("@"));
        if (ident.startsWith("~")) {
            ident = ident.substring(1);
        }
        return ident;
    }

    public static String getMaskFromSource(String ircSource) {
        String mask = IrcMessage.getIdentFromSource(ircSource);
        if (mask == null) {
            return null;
        }
        mask = mask + "@" + IrcMessage.getHostFromSource(ircSource);
        return mask;
    }
}

