/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

public class FileUtils {
    private static final String escChars = "\\\"'$%&!/*\u00b4`\u00a8^~',\u00a4=\u00bd\u00a7";

    private static final int getLastSlashIndex(String name) {
        return Math.max(name.lastIndexOf(92), name.lastIndexOf(47));
    }

    public static final String stripProblemChars(String name) {
        char[] str = name.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (escChars.indexOf(str[i]) == -1) continue;
            str[i] = 95;
        }
        return new String(str);
    }

    public static final String getName(String name) {
        int index = FileUtils.getLastSlashIndex(name);
        return index == -1 ? name : name.substring(index + 1);
    }

    public static final String getNameNoExtension(String name) {
        String shortName = FileUtils.getName(name);
        int index = shortName.lastIndexOf(46);
        return index == -1 ? shortName : shortName.substring(0, index);
    }

    public static final String getExtension(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(index + 1);
    }

    public static final String getPath(String name) {
        int index = FileUtils.getLastSlashIndex(name);
        return index == -1 ? "" : name.substring(0, index);
    }

    public static final boolean isSimiliar(String name1, String name2) {
        String ext2;
        String ext1 = FileUtils.getExtension(name1).toLowerCase();
        return ext1.compareTo(ext2 = FileUtils.getExtension(name2).toLowerCase()) == 0 && FileUtils.getName(name1).charAt(0) == FileUtils.getName(name2).charAt(0);
    }
}

