/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.FtpSecureConnection;
import com.bowman.util.ServerSocketProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FtpControlConnection {
    public static final String CRLF = "\r\n";
    public static final String[] LIST_COMMANDS = new String[]{"NLST", "LIST"};
    public static final String PORT_COMMAND = "PORT";
    public static final String PASV_COMMAND = "PASV";
    public static final int LISTEN_SO_TIMEOUT = 30000;
    public static final int BUFSIZE = 32768;
    protected String ftpUser;
    protected String ftpPass;
    protected int ftpPort;
    protected InetAddress ftpHost;
    protected Socket ftpConn;
    protected Socket dataConn;
    protected BufferedReader ftpReader;
    protected BufferedWriter ftpWriter;
    protected PrintWriter dbgWriter;
    protected String ftpPath;
    protected boolean allowDataConnection;
    protected boolean usePassiveMode;
    protected boolean usePretransfer;
    protected Vector multiLineReply;
    protected Vector fileList;

    public static FtpControlConnection getInstance(String host, int port, String user, String pass, boolean secure) throws UnknownHostException {
        if (!secure) {
            return new FtpControlConnection(host, port, user, pass);
        }
        try {
            Object[] initArgs = new Object[]{host, new Integer(port), user, pass};
            Constructor<?> c = Class.forName("com.bowman.util.FtpSecureConnection").getConstructors()[0];
            return (FtpControlConnection)c.newInstance(initArgs);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create secure connection instance: " + e.toString());
        }
    }

    public static FtpControlConnection createFromURL(String url) throws MalformedURLException, UnknownHostException {
        return FtpControlConnection.createFromURL(url, false);
    }

    public static FtpControlConnection createFromURL(String url, boolean secure) throws MalformedURLException, UnknownHostException {
        if (!url.startsWith("ftp://")) {
            throw new MalformedURLException("Not an ftp url: " + url);
        }
        String user = "anonymous";
        String password = "ftp@ftp.com";
        String hostPortPath = null;
        if (url.indexOf("@") != -1) {
            String userPass = url.substring("ftp://".length(), url.indexOf("@"));
            if (userPass.indexOf(":") == -1) {
                throw new MalformedURLException("Expected '" + userPass + "' to contain ':'");
            }
            user = userPass.substring(0, userPass.indexOf(":"));
            password = userPass.substring(userPass.indexOf(":") + 1);
            hostPortPath = url.substring(url.indexOf("@") + 1);
        } else {
            hostPortPath = url.substring("ftp://".length());
        }
        String hostPort = hostPortPath;
        String path = null;
        if (hostPort.indexOf("/") != -1) {
            hostPort = hostPort.substring(0, hostPort.indexOf("/"));
            path = hostPortPath.substring(hostPortPath.indexOf("/"));
        }
        String host = hostPort;
        int port = 21;
        if (host.indexOf(":") != -1) {
            host = host.substring(0, host.indexOf(":"));
            try {
                port = Integer.parseInt(hostPort.substring(hostPort.indexOf(":") + 1));
                if (port >= 65535 || port <= 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new MalformedURLException("Invalid port: " + hostPort.substring(hostPort.indexOf(":") + 1));
            }
        }
        FtpControlConnection conn = FtpControlConnection.getInstance(host, port, user, password, secure);
        conn.setFtpPath(path);
        return conn;
    }

    public FtpControlConnection(String host, int port, String user, String pass) throws UnknownHostException {
        this.ftpHost = InetAddress.getByName(host);
        this.ftpUser = user;
        this.ftpPass = pass;
        this.ftpPort = port;
        this.allowDataConnection = true;
        this.usePassiveMode = true;
        this.multiLineReply = new Vector();
        this.fileList = new Vector();
    }

    public String getFtpURL(boolean includeUserPwd) {
        String url = "ftp://";
        if (includeUserPwd) {
            url = url + this.ftpUser + ":" + this.ftpPass + "@";
        }
        url = url + this.ftpHost.getHostName();
        if (this.ftpPort != 21) {
            url = url + ":" + this.ftpPort;
        }
        url = url + "/";
        if (this.ftpPath != null && !"".equals(this.ftpPath)) {
            url = url + this.ftpPath;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public void setFtpPath(String ftpPath) {
        if (ftpPath != null && ftpPath.startsWith("/")) {
            ftpPath = ftpPath.substring(1);
        }
        this.ftpPath = ftpPath;
    }

    public void setAllowDataConnection(boolean allow) {
        this.allowDataConnection = allow;
    }

    public void setUserPassiveMode(boolean usePassive) {
        this.usePassiveMode = usePassive;
    }

    public void connect() throws IOException {
        this.ftpConn = new Socket(this.ftpHost, this.ftpPort);
        this.ftpReader = new BufferedReader(new InputStreamReader(this.ftpConn.getInputStream()));
        this.ftpWriter = new BufferedWriter(new OutputStreamWriter(this.ftpConn.getOutputStream()));
        String initStr = this.readFtpReply();
        if (this.getCode(initStr) != 220) {
            this.fatalError("Ftpd not ready or non-ftp data received on connect.");
        }
        this.authenticate();
        String featReply = this.sendFtpCommand("FEAT");
        if (this.getCode(featReply) == 211) {
            Enumeration enumeration = this.getLastFullReply();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement().toString().indexOf("PRET") <= -1) continue;
                this.usePretransfer = true;
            }
            if (this.usePretransfer) {
                this.debug("using PRET (pretransfer)");
            }
        }
        if (this.ftpPath != null) {
            try {
                this.changeDir(this.ftpPath);
            }
            catch (IOException e) {
                this.debug(e.getMessage());
                this.changeDir("/" + this.ftpPath);
            }
        }
    }

    protected void authenticate() throws IOException {
        String loginReply = this.sendFtpCommand("USER " + this.ftpUser);
        switch (this.getCode(loginReply)) {
            case 230: {
                break;
            }
            case 331: {
                loginReply = this.sendFtpCommand("PASS " + this.ftpPass);
                break;
            }
            default: {
                this.fatalError("Login denied for user '" + this.ftpUser + "': " + this.getText(loginReply));
            }
        }
        if (this.getCode(loginReply) != 230) {
            this.fatalError("Login failed: " + this.getText(loginReply));
        }
    }

    protected void fatalError(String msg) throws IOException {
        if (this.ftpConn != null) {
            this.ftpConn.close();
        }
        this.ftpConn = null;
        throw new IOException(msg);
    }

    protected void setupPasvConnection() throws IOException {
        String reply = this.sendFtpCommand(PASV_COMMAND);
        if (this.getLastReplyCode() != 227) {
            throw new IOException("PASV Command failed: " + reply);
        }
        String dataHost = "";
        int dataPort = 0;
        try {
            reply = reply.substring(reply.indexOf(40) + 1);
            reply = reply.substring(0, reply.indexOf(41));
            dataHost = "";
            StringTokenizer st = new StringTokenizer(reply.replace(',', '.'), ".", true);
            for (int i = 0; i < 7 && st.hasMoreTokens(); ++i) {
                dataHost = dataHost + st.nextToken();
            }
            st.nextToken();
            int hi = Integer.parseInt(st.nextToken());
            st.nextToken();
            int lo = Integer.parseInt(st.nextToken());
            dataPort = hi * 256 + lo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("PASV Command failed, unexpected reply from server (" + reply + ")");
        }
        this.debug("connecting to: " + dataHost + " port " + dataPort);
        this.dataConn = this.getSocket(dataHost, dataPort);
    }

    protected void setupPortConnection() throws IOException {
        DataConnDaemon dcListener = new DataConnDaemon(this);
        byte[] rawHost = dcListener.getLocalAddr().getAddress();
        String localIp = (0xFF & rawHost[0]) + "," + (0xFF & rawHost[1]) + "," + (0xFF & rawHost[2]) + "," + (0xFF & rawHost[3]);
        int port = dcListener.getListenPort();
        int hi = port >> 8;
        int lo = port - hi * 256;
        String reply = this.sendFtpCommand("PORT " + localIp + "," + hi + "," + lo);
        if (this.getLastReplyCode() != 200) {
            throw new IOException("PORT Command failed: " + reply);
        }
    }

    protected void setupDataConnection(boolean list) throws IOException {
        if (this.usePassiveMode) {
            this.setupPasvConnection();
        } else {
            this.setupPortConnection();
        }
    }

    protected synchronized void dataConnectionAccepted(Socket conn) {
        this.dataConn = conn;
        this.notify();
    }

    protected void sendPretransfer(boolean list, String cmd) throws IOException {
        if (this.getCode(this.sendFtpCommand("PRET " + cmd)) != 200) {
            this.fatalError("PRET " + cmd + " failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendFtpCommand(String cmd) throws IOException {
        boolean performList = false;
        if (this.ftpWriter == null) {
            return null;
        }
        if (this.allowDataConnection) {
            for (int i = 0; i < LIST_COMMANDS.length; ++i) {
                if (!cmd.toUpperCase().startsWith(LIST_COMMANDS[i])) continue;
                performList = true;
                if (this.usePretransfer) {
                    this.sendPretransfer(true, cmd.toUpperCase());
                }
                this.setupDataConnection(true);
            }
        }
        this.ftpWriter.write(cmd + CRLF);
        this.ftpWriter.flush();
        if (!cmd.toUpperCase().startsWith("PASS ")) {
            this.debug("-> " + cmd);
        } else {
            this.debug("-> PASS *******");
        }
        this.fileList.clear();
        if (performList) {
            String reply = this.readFtpReply();
            if (this.getLastReplyCode() != 150) {
                throw new IOException("Unexpected response to " + cmd + " command: " + reply);
            }
            FtpControlConnection ftpControlConnection = this;
            synchronized (ftpControlConnection) {
                try {
                    if (this.dataConn == null) {
                        this.wait(30000L);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this.dataConn != null) {
                    BufferedReader listReader = new BufferedReader(new InputStreamReader(this.dataConn.getInputStream()));
                    String line = "";
                    while ((line = listReader.readLine()) != null) {
                        this.fileList.addElement(line);
                    }
                    try {
                        this.dataConn.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.dataConn = null;
                } else {
                    this.fileList = null;
                }
            }
        }
        return this.readFtpReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFile(String fileName) throws IOException {
        if (!this.allowDataConnection || this.ftpWriter == null) {
            throw new IOException("Not ready.");
        }
        String cmd = "RETR " + fileName;
        if (this.usePretransfer) {
            this.sendPretransfer(false, cmd);
        }
        this.setupDataConnection(false);
        this.ftpWriter.write(cmd + CRLF);
        this.ftpWriter.flush();
        this.debug("-> " + cmd);
        String reply = this.readFtpReply();
        if (this.getLastReplyCode() != 150) {
            throw new IOException("Unexpected response to " + cmd + " command: " + reply);
        }
        FtpControlConnection ftpControlConnection = this;
        synchronized (ftpControlConnection) {
            try {
                if (this.dataConn == null) {
                    this.wait(30000L);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this.dataConn != null) {
                return this.dataConn.getInputStream();
            }
            return null;
        }
    }

    public File getFile(String fileName, File downloadDir) throws IOException {
        int read;
        File targetFile = new File(downloadDir, fileName);
        BufferedInputStream bis = new BufferedInputStream(this.getFile(fileName));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buf = new byte[32768];
        while ((read = bis.read(buf)) > -1) {
            bos.write(buf, 0, read);
        }
        bos.close();
        bis.close();
        this.readFtpReply();
        return targetFile;
    }

    public Vector getFileList() throws IOException {
        if (!this.allowDataConnection || this.ftpWriter == null) {
            return null;
        }
        this.sendFtpCommand("LIST");
        Vector newList = new Vector(this.fileList);
        return newList;
    }

    public void changeDir(String path) throws IOException {
        this.sendFtpCommand("CWD " + path);
        if (this.getLastReplyCode() != 250) {
            throw new IOException("Unexpected response to 'CWD " + path + "' command: " + this.getLastReplyText());
        }
    }

    public void close() {
        try {
            if (this.ftpConn != null) {
                this.sendFtpCommand("QUIT");
                Thread.sleep(100L);
                this.ftpConn.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.dataConn != null) {
                this.dataConn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ftpConn = null;
        this.dataConn = null;
    }

    public Enumeration getLastFullReply() {
        if (this.multiLineReply == null) {
            return null;
        }
        return this.multiLineReply.elements();
    }

    public String getLastReplyText() {
        if (this.multiLineReply == null) {
            return null;
        }
        return this.getText((String)this.multiLineReply.lastElement());
    }

    public int getLastReplyCode() {
        if (this.multiLineReply == null) {
            return 0;
        }
        try {
            return this.getCode((String)this.multiLineReply.lastElement());
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    protected String readFtpReply() throws IOException {
        String line = null;
        this.multiLineReply.clear();
        if (!this.fileList.isEmpty()) {
            this.multiLineReply.addAll(this.fileList);
        }
        do {
            line = this.ftpReader.readLine();
            this.debug("<- " + line);
            if (line.length() == 3) break;
            this.multiLineReply.addElement(line);
        } while (line.charAt(3) != ' ');
        return line;
    }

    private String getClassName() {
        String c = this.getClass().getName();
        c = c.substring(c.lastIndexOf(".") + 1);
        return c;
    }

    protected int getCode(String line) throws IOException {
        try {
            return Integer.parseInt(line.substring(0, 3));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Non-ftp reply read, aborting.");
        }
    }

    protected String getText(String line) {
        if (line.length() < 4) {
            return "";
        }
        return line.substring(4).trim();
    }

    public void setDebugLogger(PrintWriter writer) {
        this.dbgWriter = writer;
    }

    protected void debug(String s) {
        if (this.dbgWriter != null) {
            this.dbgWriter.println(this.getClassName() + " " + s);
        }
    }

    protected void debug(Exception e) {
        this.debug(e.toString());
        if (this.dbgWriter != null) {
            e.printStackTrace(this.dbgWriter);
        }
    }

    protected Socket getSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    protected ServerSocket getServerSocket() throws IOException {
        return ServerSocketProvider.createServerSocket();
    }

    public static void main(String[] args) throws Exception {
        FtpControlConnection conn = FtpControlConnection.createFromURL("ftp://mp3crawler:xxxxxxxxx@bowser.homeftp.org:7687", true);
        System.out.println(conn.getFtpURL(true));
        System.out.println(conn.getFtpURL(false));
        conn.setDebugLogger(new PrintWriter(System.out, true));
        conn.setAllowDataConnection(true);
        conn.setUserPassiveMode(true);
        ((FtpSecureConnection)conn).setSecureAllTransfers(true);
        try {
            conn.connect();
        }
        catch (IOException e) {
            System.err.println("FTP connect failed: " + e.getMessage());
            return;
        }
        System.out.println(conn.getFileList());
        conn.changeDir("/MP3-TEAM/UB40-Who_You_Fighting_For-2005-ESC");
        System.out.println(conn.getFileList());
        conn.close();
    }

    private class DataConnDaemon
    extends Thread {
        private ServerSocket listener;
        private int listenPort;
        private InetAddress localAddr;
        private FtpControlConnection parent;

        DataConnDaemon(FtpControlConnection parent) throws IOException {
            this.parent = parent;
            this.listener = FtpControlConnection.this.getServerSocket();
            this.listener.setSoTimeout(30000);
            this.listenPort = this.listener.getLocalPort();
            this.localAddr = this.listener.getInetAddress();
            this.start();
        }

        int getListenPort() {
            return this.listenPort;
        }

        InetAddress getLocalAddr() {
            return this.localAddr;
        }

        public void run() {
            try {
                Socket dataConn = this.listener.accept();
                this.parent.dataConnectionAccepted(dataConn);
            }
            catch (IOException ie) {
                this.parent.debug(ie);
            }
        }
    }
}

