/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;

public class MailerWrapper {
    protected Session session;
    protected String from;
    protected String subject;
    protected ArrayList toList = new ArrayList();
    protected ArrayList ccList = new ArrayList();
    protected ArrayList bccList = new ArrayList();
    protected String body;
    protected String mailHost;
    protected int mailPort = 25;
    protected boolean verbose;
    protected MimeBodyPart attachment;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String fm) {
        this.from = fm;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public ArrayList getToList() {
        return this.toList;
    }

    public void setToList(ArrayList to) {
        this.toList = to;
    }

    public void setToList(String s) {
        this.toList = MailerWrapper.tokenize(s);
    }

    public void addTo(String to) {
        this.toList.add(to);
    }

    public ArrayList getCcList() {
        return this.ccList;
    }

    public void setCcList(ArrayList cc) {
        this.ccList = cc;
    }

    public void setCcList(String s) {
        this.ccList = MailerWrapper.tokenize(s);
    }

    public void addCc(String cc) {
        this.ccList.add(cc);
    }

    public ArrayList getBccList() {
        return this.bccList;
    }

    public void setBccList(ArrayList bcc) {
        this.bccList = bcc;
    }

    public void setBccList(String s) {
        this.bccList = MailerWrapper.tokenize(s);
    }

    public void addBcc(String bcc) {
        this.bccList.add(bcc);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String text) {
        this.body = text;
    }

    public void setMailPort(int mailPort) {
        this.mailPort = mailPort;
    }

    public void setAttachment(URL url) throws MessagingException {
        this.attachment = new MimeBodyPart();
        this.attachment.setDataHandler(new DataHandler(url));
        String fileName = url.getFile();
        if (fileName.indexOf("/") != -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        if (!"".equals(fileName)) {
            this.attachment.setFileName(fileName);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public boolean isComplete() {
        if (this.from == null || this.from.length() == 0) {
            System.err.println("doSend: no FROM");
            return false;
        }
        if (this.subject == null || this.subject.length() == 0) {
            System.err.println("doSend: no SUBJECT");
            return false;
        }
        if (this.toList.size() == 0) {
            System.err.println("doSend: no recipients");
            return false;
        }
        if (this.body == null || this.body.length() == 0) {
            System.err.println("doSend: no body");
            return false;
        }
        if (this.mailHost == null || this.mailHost.length() == 0) {
            System.err.println("doSend: no server host");
            return false;
        }
        return true;
    }

    public void setServer(String s) {
        this.mailHost = s;
    }

    public synchronized void doSend() throws MessagingException {
        int i;
        if (!this.isComplete()) {
            throw new IllegalArgumentException("doSend called before message was complete");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.mailHost);
        if (this.mailPort != 25 && this.mailPort > 0 && this.mailPort < 65535) {
            props.put("mail.smtp.port", String.valueOf(this.mailPort));
        }
        if (this.session == null) {
            this.session = Session.getInstance((Properties)props, null);
            if (this.verbose) {
                this.session.setDebug(true);
            }
        }
        MimeMessage mesg = new MimeMessage(this.session);
        mesg.setSentDate(new Date());
        InternetAddress[] addresses = new InternetAddress[this.toList.size()];
        for (i = 0; i < addresses.length; ++i) {
            addresses[i] = new InternetAddress((String)this.toList.get(i));
        }
        mesg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        mesg.setFrom((Address)new InternetAddress(this.from));
        addresses = new InternetAddress[this.ccList.size()];
        for (i = 0; i < addresses.length; ++i) {
            addresses[i] = new InternetAddress((String)this.ccList.get(i));
        }
        mesg.setRecipients(Message.RecipientType.CC, (Address[])addresses);
        addresses = new InternetAddress[this.bccList.size()];
        for (i = 0; i < addresses.length; ++i) {
            addresses[i] = new InternetAddress((String)this.bccList.get(i));
        }
        mesg.setRecipients(Message.RecipientType.BCC, (Address[])addresses);
        mesg.setSubject(this.subject);
        mesg.setText(this.body);
        MimeMultipart content = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        try {
            textPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.body, "text/plain", "ISO-8859-1")));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MessagingException(uee.getMessage());
        }
        content.addBodyPart((BodyPart)textPart);
        if (this.attachment != null) {
            content.addBodyPart((BodyPart)this.attachment);
        }
        mesg.setContent((Multipart)content);
        mesg.saveChanges();
        Transport.send((Message)mesg);
    }

    public static void send(String mailhost, String recipient, String sender, String subject, String message) throws MessagingException {
        MailerWrapper.send(mailhost, recipient, sender, subject, message, null);
    }

    public static void send(String mailhost, String recipient, String sender, String subject, String message, URL url) throws MessagingException {
        MailerWrapper.send(mailhost, 25, recipient, sender, subject, message, url);
    }

    public static void send(String mailhost, int mailport, String recipient, String sender, String subject, String message, URL url) throws MessagingException {
        MailerWrapper m = new MailerWrapper();
        m.setServer(mailhost);
        m.setMailPort(mailport);
        m.addTo(recipient);
        m.setFrom(sender);
        m.setSubject(subject);
        m.setBody(message);
        if (url != null) {
            m.setAttachment(url);
        }
        m.doSend();
    }

    protected static ArrayList tokenize(String s) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tf = new StringTokenizer(s, ",");
        while (tf.hasMoreTokens()) {
            al.add(tf.nextToken().trim());
        }
        return al;
    }

    class ByteArrayDataSource
    implements DataSource {
        private byte[] myData;
        protected ContentType myContentType;

        public ByteArrayDataSource(InputStream in, String contentType) throws IOException, ParseException {
            this(in, contentType, null);
        }

        public ByteArrayDataSource(InputStream in, String contentType, String name) throws IOException, ParseException {
            int ch;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((ch = in.read()) != -1) {
                bos.write(ch);
            }
            this.myData = bos.toByteArray();
            this.myContentType = new ContentType(contentType);
            if (name != null) {
                this.myContentType.setParameter("Name", name);
            }
        }

        public ByteArrayDataSource(String str, String contentType, String charset) throws UnsupportedEncodingException, ParseException {
            this(str, contentType, charset, null);
        }

        public ByteArrayDataSource(String str, String contentType, String charset, String name) throws UnsupportedEncodingException, ParseException {
            this.myContentType = new ContentType(contentType);
            this.myData = charset != null ? str.getBytes(charset) : str.getBytes();
            if (name != null) {
                this.myContentType.setParameter("Name", name);
            }
        }

        public String getContentType() {
            return this.myContentType.toString();
        }

        public InputStream getInputStream() throws IOException {
            if (this.myData == null) {
                throw new IOException("Not initialized");
            }
            return new ByteArrayInputStream(this.myData);
        }

        public String getName() {
            return "ByteArrayDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Not an allowed operation on ByteArrayDataSource");
        }
    }
}

