/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class SimpleRtfParser {
    private PushbackInputStream pbIn;
    private StringBuffer buf;
    private int depth;
    private long nbToken;

    public SimpleRtfParser(String rtfText) {
        this(new ByteArrayInputStream(rtfText.getBytes()));
    }

    public SimpleRtfParser(InputStream rtfIn) {
        this.pbIn = new PushbackInputStream(rtfIn);
        this.buf = new StringBuffer();
        this.depth = 0;
        this.nbToken = 0L;
    }

    public RtfToken getNextToken() throws IOException {
        this.buf = new StringBuffer();
        ++this.nbToken;
        int ch;
        while ((ch = this.pbIn.read()) != -1) {
            if (ch == 92) {
                if (this.buf.length() > 0) {
                    this.pbIn.unread(ch);
                    String data = this.buf.toString();
                    this.buf.setLength(0);
                    return new RtfToken(data);
                }
                ch = this.pbIn.read();
                if (ch == 42) {
                    return new RtfToken(7);
                }
                if (ch == 39) {
                    char ch1 = (char)this.pbIn.read();
                    char ch2 = (char)this.pbIn.read();
                    ch = Character.digit(ch1, 16) * 16 + Character.digit(ch2, 16);
                    this.buf.append((char)ch);
                    String data = this.buf.toString();
                    return new RtfToken(data);
                }
                if (ch == 92) {
                    return new RtfToken("\\");
                }
                if (ch == 126) {
                    return new RtfToken("\u00a0");
                }
                if (ch == 45) {
                    return new RtfToken("\u2010");
                }
                if (ch == 95) {
                    return new RtfToken("\u2011");
                }
                if (ch == 123) {
                    return new RtfToken("{");
                }
                if (ch == 125) {
                    return new RtfToken("}");
                }
                while (Character.isLetter((char)ch)) {
                    this.buf.append((char)ch);
                    ch = this.pbIn.read();
                }
                String name = this.buf.toString();
                this.buf.setLength(0);
                if (ch == 45) {
                    this.buf.append((char)ch);
                    ch = this.pbIn.read();
                }
                while (Character.isDigit((char)ch)) {
                    this.buf.append((char)ch);
                    ch = this.pbIn.read();
                }
                if (!Character.isSpaceChar((char)ch)) {
                    this.pbIn.unread(ch);
                }
                String data = this.buf.toString();
                this.buf.setLength(0);
                return new RtfToken(1, name, data);
            }
            if (ch == 123) {
                if (this.buf.length() > 0) {
                    this.pbIn.unread(ch);
                    String data = this.buf.toString();
                    return new RtfToken(data);
                }
                ++this.depth;
                return new RtfToken(4);
            }
            if (ch == 125) {
                if (this.buf.length() > 0) {
                    this.pbIn.unread(ch);
                    String data = this.buf.toString();
                    return new RtfToken(data);
                }
                --this.depth;
                return new RtfToken(5);
            }
            if (ch == 13 || ch == 10) continue;
            this.buf.append((char)ch);
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public long getTokenCount() {
        return this.nbToken;
    }

    public void close() throws IOException {
        if (this.pbIn != null) {
            this.pbIn.close();
            this.pbIn = null;
            this.buf = null;
        }
    }

    public String getPlainText() throws IOException {
        RtfToken tok;
        StringBuffer sb = new StringBuffer();
        boolean paragraph = false;
        while ((tok = this.getNextToken()) != null) {
            if (tok.getType() == 1) {
                if ("pard".equals(tok.getName())) {
                    paragraph = true;
                }
                if ("par".equals(tok.getName())) {
                    paragraph = false;
                    sb.append("\n");
                }
            }
            if (!paragraph || tok.getType() != 6 || tok.getName() != null) continue;
            sb.append(tok.getData());
        }
        return sb.toString();
    }

    class RtfToken {
        public static final int BACKSLASH = 0;
        public static final int CONTROLWORD = 1;
        public static final int SPECIAL = 2;
        public static final int CONTROLSYMBOL = 3;
        public static final int OPENGROUP = 4;
        public static final int CLOSEGROUP = 5;
        public static final int DATA = 6;
        public static final int ASTERISK = 7;
        private int type;
        private String name;
        private String data;

        public RtfToken(int type, String name, String data) {
            this.type = type;
            this.name = name;
            this.data = data;
        }

        public RtfToken(int type) {
            this.type = type;
        }

        public RtfToken(String data) {
            this.type = 6;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "\\";
                }
                case 1: {
                    return "\\" + this.name + this.data;
                }
                case 2: {
                    return "SPECIAL";
                }
                case 3: {
                    return "CONTROLSYMBOL";
                }
                case 4: {
                    return "{";
                }
                case 5: {
                    return "}";
                }
                case 6: {
                    return this.data;
                }
            }
            return null;
        }
    }
}

