/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.BoxMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BoxRegistry
implements Serializable {
    private Map boxes = new HashMap();

    public void registerBox(BoxMetaData box) {
        this.boxes.put(box.getBoxId(), box);
    }

    public BoxMetaData[] findBox(String macAddr, String user, boolean activeOnly) {
        if (macAddr == null && user == null && !activeOnly) {
            return this.boxes.values().toArray(new BoxMetaData[this.boxes.size()]);
        }
        ArrayList<BoxMetaData> foundBoxes = new ArrayList<BoxMetaData>();
        for (BoxMetaData box : this.boxes.values()) {
            if (macAddr != null && !box.getMacAddr().equals(macAddr) || user != null && !box.getUser().equals(user)) continue;
            if (activeOnly) {
                if (!box.isActive()) continue;
                foundBoxes.add(box);
                continue;
            }
            foundBoxes.add(box);
        }
        return foundBoxes.toArray(new BoxMetaData[foundBoxes.size()]);
    }

    public BoxMetaData[] findBox(String macAddr, String user) {
        return this.findBox(macAddr, user, false);
    }

    public BoxMetaData[] findBox(String user) {
        return this.findBox(null, user);
    }

    public BoxMetaData[] findBox(String user, boolean activeOnly) {
        return this.findBox(null, user, activeOnly);
    }

    public BoxMetaData getBox(String boxId) {
        return (BoxMetaData)this.boxes.get(boxId);
    }

    public int size() {
        return this.boxes.size();
    }

    public void removeBox(String boxId) {
        this.boxes.remove(boxId);
    }

    public int getActiveCount() {
        return this.findBox(null, null, true).length;
    }
}

