/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.interfaces.StaleEntryListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MessageCacheMap
extends LinkedHashMap {
    private long maxAge;
    private StaleEntryListener listener;

    public MessageCacheMap(long maxAge) {
        this.maxAge = maxAge;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        CamdNetMessage msg = null;
        if (eldest.getKey() instanceof CamdNetMessage) {
            msg = (CamdNetMessage)eldest.getKey();
        } else if (eldest.getValue() instanceof CamdNetMessage) {
            msg = (CamdNetMessage)eldest.getValue();
        } else {
            Set s = (Set)eldest.getValue();
            if (s != null && s.iterator() != null) {
                msg = (CamdNetMessage)s.iterator().next();
            }
        }
        if (msg == null) {
            return true;
        }
        if (System.currentTimeMillis() - msg.getTimeStamp() > this.maxAge) {
            if (this.listener != null) {
                this.listener.onRemoveStale(msg);
            }
            return true;
        }
        return false;
    }

    public void setStaleEntryListener(StaleEntryListener listener) {
        this.listener = listener;
    }

    public void setMaxAge(long maxAge) {
        if (maxAge < this.maxAge) {
            long now = System.currentTimeMillis();
            Iterator iter = this.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                CamdNetMessage msg = key instanceof CamdNetMessage ? (CamdNetMessage)key : (CamdNetMessage)this.get(key);
                if (now - msg.getTimeStamp() <= maxAge) continue;
                iter.remove();
            }
        }
        this.maxAge = maxAge;
    }
}

