/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RMITunnelSocketFactory
extends RMISocketFactory
implements Runnable {
    public static final int TUNNELMODE_LISTENER = 0;
    public static final int TUNNELMODE_CONNECTOR = 1;
    private static int socketCounter;
    private String remoteHost;
    private int remotePort;
    private int listenPort;
    private int tunnelMode;
    private boolean debug = false;
    private RMITunnel tunnel = null;
    private ServerSocket listenSocket;
    private InetAddress localAddr;
    private InetAddress remoteAddr;
    private Map dataTable = new HashMap();
    private Map pendingSockets = new HashMap();
    private Set connectedSockets = new HashSet();

    public RMITunnelSocketFactory(int port, boolean startListener) throws IOException {
        socketCounter = 1000;
        this.tunnelMode = 0;
        this.listenPort = port;
        if (startListener) {
            this.startListener();
        }
    }

    public RMITunnelSocketFactory(int port) throws IOException {
        this(port, true);
    }

    public RMITunnelSocketFactory(String remoteHost, int remotePort, boolean connect) throws IOException {
        socketCounter = 2000;
        this.tunnelMode = 1;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        if (connect) {
            this.connect();
        }
    }

    public void connect() throws IOException {
        Socket tmp = new Socket(this.remoteHost, this.remotePort);
        this.localAddr = tmp.getLocalAddress();
        this.remoteAddr = tmp.getInetAddress();
        this.tunnel = new RMITunnel(tmp);
    }

    public void startListener() throws IOException {
        if (this.listenSocket == null) {
            this.debugOut("starting tunnel listener (accepting single connection)");
            this.listenSocket = new ServerSocket(this.listenPort);
            new Thread((Runnable)this, "RMITunnelAcceptThread").start();
        }
    }

    public synchronized int getSocketId() {
        switch (this.tunnelMode) {
            case 1: {
                if (socketCounter != 3000) break;
                socketCounter = 2000;
                break;
            }
            case 0: {
                if (socketCounter != 2000) break;
                socketCounter = 1000;
            }
        }
        return socketCounter++;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    protected void debugOut(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    protected void debugOut(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void run() {
        try {
            Socket tmp = this.listenSocket.accept();
            this.localAddr = tmp.getLocalAddress();
            this.remoteAddr = tmp.getInetAddress();
            this.tunnel = new RMITunnel(tmp);
            this.listenSocket.close();
        }
        catch (IOException e) {
            this.debugOut(e);
        }
        this.listenSocket = null;
    }

    public Socket createSocket(String host, int port) throws IOException {
        this.debugOut("createSocket(" + host + ", " + port + ")");
        if (this.tunnel == null) {
            if (this.tunnelMode == 1) {
                this.connect();
            } else {
                throw new ConnectException("Connection refused: connect");
            }
        }
        FakeSocket sock = new FakeSocket(port, this.getSocketId());
        this.connectedSockets.add(new Integer(sock.socketId));
        return sock;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        FakeServerSocket srv = new FakeServerSocket(port);
        this.debugOut("createServersocket(" + port + ") -> " + srv.getLocalPort());
        return srv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeReceivedData(int socket, int port, byte[] data) {
        this.debugOut("storing " + data.length + " bytes for socket " + socket + " (port " + port + ")");
        Integer portKey = new Integer(port);
        Integer socketKey = new Integer(socket);
        Map map = this.pendingSockets;
        synchronized (map) {
            if (!this.connectedSockets.contains(socketKey)) {
                this.debugOut("new connection pending on port " + port + " (" + socket + ")");
                this.pendingSockets.put(portKey, socketKey);
                this.pendingSockets.notifyAll();
            }
        }
        map = this.dataTable;
        synchronized (map) {
            if (this.dataTable.containsKey(socketKey)) {
                byte[] oldData = (byte[])this.dataTable.get(socketKey);
                byte[] allData = new byte[oldData.length + data.length];
                System.arraycopy(oldData, 0, allData, 0, oldData.length);
                System.arraycopy(data, 0, allData, oldData.length, data.length);
                data = allData;
            }
            this.dataTable.put(socketKey, data);
            this.dataTable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForSocket(int port) {
        Map map = this.pendingSockets;
        synchronized (map) {
            Integer key = new Integer(port);
            while (!this.pendingSockets.containsKey(key)) {
                try {
                    this.debugOut("waiting for connection on port " + port);
                    this.pendingSockets.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            Integer socket = (Integer)this.pendingSockets.remove(key);
            this.debugOut("accepting socket connection on port " + port + " (" + socket + ")");
            this.connectedSockets.add(socket);
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveReceivedData(int socket) {
        Map map = this.dataTable;
        synchronized (map) {
            byte[] data;
            Integer key = new Integer(socket);
            while (!this.dataTable.containsKey(key)) {
                try {
                    this.debugOut("waiting for data on socket " + socket);
                    this.dataTable.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if ((data = (byte[])this.dataTable.remove(key)).length == 0) {
                return null;
            }
            if (!this.connectedSockets.contains(key)) {
                this.debugOut("socket appears closed " + socket);
                this.dataTable.put(key, new byte[0]);
            }
            this.debugOut("returning data on socket " + socket + " " + data.length);
            return data;
        }
    }

    protected void sendInterceptedData(FakeSocket s, byte[] data) {
        if (this.tunnel == null) {
            return;
        }
        this.debugOut("sending data for socket " + s.socketId + " (" + s.targetPort + ") " + data.length);
        try {
            this.tunnel.sendData(s, data);
        }
        catch (IOException e) {
            this.tunnel.closeTunnel();
        }
    }

    protected void sendSocketClose(FakeSocket s) {
        if (this.tunnel == null) {
            return;
        }
        this.debugOut("sending socket close for socket " + s.socketId + " (" + s.targetPort + ")");
        this.connectedSockets.remove(new Integer(s.socketId));
        try {
            this.tunnel.sendSocketClose(s);
        }
        catch (IOException e) {
            this.tunnel.closeTunnel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSocketClose(int socket) {
        this.debugOut("closing socket on socket " + socket);
        Integer key = new Integer(socket);
        if (this.connectedSockets.contains(key)) {
            Map map = this.dataTable;
            synchronized (map) {
                if (!this.dataTable.containsKey(key)) {
                    this.dataTable.put(key, new byte[0]);
                }
                this.connectedSockets.remove(key);
                this.dataTable.notifyAll();
            }
        } else {
            this.debugOut("ignored close socket for unconnected socket " + socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSockets() {
        Map map = this.dataTable;
        synchronized (map) {
            Iterator iter = this.connectedSockets.iterator();
            while (iter.hasNext()) {
                this.dataTable.put(iter.next(), new byte[0]);
            }
            this.connectedSockets.clear();
            this.pendingSockets.clear();
            this.dataTable.notifyAll();
        }
    }

    private class InterceptInputStream
    extends InputStream {
        private FakeSocket socket;
        private ByteArrayInputStream currentData;
        private boolean closed = false;

        InterceptInputStream(FakeSocket socket) {
            this.socket = socket;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.currentData == null || this.currentData.available() == 0) {
                byte[] data = RMITunnelSocketFactory.this.retrieveReceivedData(this.socket.socketId);
                if (data == null) {
                    this.close();
                } else {
                    this.currentData = new ByteArrayInputStream(data);
                }
            }
            if (this.closed) {
                return -1;
            }
            return this.currentData.read(b, off, len);
        }

        public void close() throws IOException {
            this.currentData = null;
            this.closed = true;
        }

        public long skip(long n) throws IOException {
            return n;
        }

        public int available() throws IOException {
            return this.currentData == null ? 0 : this.currentData.available();
        }

        public synchronized void mark(int readlimit) {
        }

        public synchronized void reset() throws IOException {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            RMITunnelSocketFactory.this.debugOut("InterceptInputStream(" + this.socket.socketId + ") read()");
            return -1;
        }

        public int read(byte[] b) throws IOException {
            RMITunnelSocketFactory.this.debugOut("InterceptInputStream(" + this.socket.socketId + ") read(byte[] " + b.length + ")");
            return -1;
        }
    }

    private class InterceptOutputStream
    extends OutputStream {
        private FakeSocket socket;
        private ByteArrayOutputStream currentData;
        private boolean closed = false;

        InterceptOutputStream(FakeSocket socket) {
            this.socket = socket;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            if (this.currentData == null) {
                this.currentData = new ByteArrayOutputStream();
            }
            this.currentData.write(b, off, len);
        }

        public void flush() throws IOException {
            if (this.currentData != null) {
                RMITunnelSocketFactory.this.sendInterceptedData(this.socket, this.currentData.toByteArray());
            }
            this.currentData = null;
        }

        public void close() throws IOException {
            this.currentData = null;
            this.closed = true;
        }

        public void write(int b) throws IOException {
            RMITunnelSocketFactory.this.debugOut("InterceptOutputStream(" + this.socket.socketId + ") write(" + b + ")");
        }

        public void write(byte[] b) throws IOException {
            RMITunnelSocketFactory.this.debugOut("InterceptOutputStream(" + this.socket.socketId + ") write(byte[] " + b.length + ")");
        }
    }

    private class FakeSocket
    extends Socket {
        protected int targetPort;
        protected int socketId;
        private OutputStream out;
        private InputStream in;
        private boolean closed = false;

        FakeSocket(int port, int id) {
            this.targetPort = port;
            this.socketId = id;
        }

        public int getPort() {
            return this.targetPort;
        }

        public int getLocalPort() {
            return this.targetPort + 1000;
        }

        public InetAddress getInetAddress() {
            return RMITunnelSocketFactory.this.remoteAddr;
        }

        public InetAddress getLocalAddress() {
            return RMITunnelSocketFactory.this.localAddr;
        }

        public InputStream getInputStream() throws IOException {
            this.in = new InterceptInputStream(this);
            return this.in;
        }

        public OutputStream getOutputStream() throws IOException {
            this.out = new InterceptOutputStream(this);
            return this.out;
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.in.close();
                this.out.close();
                RMITunnelSocketFactory.this.sendSocketClose(this);
                this.closed = true;
            }
        }

        public void setTcpNoDelay(boolean on) throws SocketException {
        }

        public void setKeepAlive(boolean on) throws SocketException {
        }

        public boolean getTcpNoDelay() throws SocketException {
            return true;
        }

        public synchronized void setSoTimeout(int timeout) throws SocketException {
        }

        public synchronized int getSoTimeout() throws SocketException {
            return 0;
        }

        public boolean getKeepAlive() throws SocketException {
            return true;
        }
    }

    private class FakeServerSocket
    extends ServerSocket {
        private int targetPort;

        FakeServerSocket(int port) throws IOException {
            super(0);
            int anyPort = super.getLocalPort();
            super.close();
            this.targetPort = port == 0 ? anyPort : port;
        }

        public InetAddress getInetAddress() {
            return RMITunnelSocketFactory.this.localAddr;
        }

        public int getLocalPort() {
            return this.targetPort;
        }

        public Socket accept() throws IOException {
            int socketId = RMITunnelSocketFactory.this.waitForSocket(this.targetPort);
            return new FakeSocket(this.targetPort, socketId);
        }

        public void close() throws IOException {
            RMITunnelSocketFactory.this.debugOut("FakeServerSocket(" + this.targetPort + ") close()");
        }
    }

    private class RMITunnel
    extends Thread {
        private Socket s;
        private DataInputStream in;
        private DataOutputStream out;

        RMITunnel(Socket s) throws IOException {
            this.s = s;
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.start();
        }

        public void run() {
            RMITunnelSocketFactory.this.debugOut("tunnel started, reading");
            try {
                while (true) {
                    StringTokenizer hdrTokens = new StringTokenizer(this.in.readUTF(), ":");
                    int port = Integer.parseInt(hdrTokens.nextToken());
                    int socket = Integer.parseInt(hdrTokens.nextToken());
                    int size = Integer.parseInt(hdrTokens.nextToken());
                    if (size == 0) {
                        RMITunnelSocketFactory.this.handleSocketClose(socket);
                        continue;
                    }
                    byte[] data = new byte[size];
                    this.in.readFully(data);
                    RMITunnelSocketFactory.this.storeReceivedData(socket, port, data);
                }
            }
            catch (Exception e) {
                RMITunnelSocketFactory.this.debugOut(e);
                RMITunnelSocketFactory.this.debugOut("tunnel exiting");
                this.closeTunnel();
                return;
            }
        }

        protected synchronized void closeTunnel() {
            try {
                this.s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            RMITunnelSocketFactory.this.closeAllSockets();
            RMITunnelSocketFactory.this.tunnel = null;
            try {
                if (RMITunnelSocketFactory.this.tunnelMode == 0) {
                    RMITunnelSocketFactory.this.startListener();
                }
            }
            catch (IOException e) {
                RMITunnelSocketFactory.this.debugOut(e);
            }
        }

        private String getWrapHeader(FakeSocket s, int length) {
            return s.targetPort + ":" + s.socketId + ":" + length;
        }

        public synchronized void sendSocketClose(FakeSocket s) throws IOException {
            this.out.writeUTF(this.getWrapHeader(s, 0));
            this.out.flush();
        }

        public synchronized void sendData(FakeSocket s, byte[] data) throws IOException {
            this.out.writeUTF(this.getWrapHeader(s, data.length));
            this.out.write(data);
            this.out.flush();
        }
    }
}

