/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;

public class IrcWriter {
    private static final int MAX_LENGTH = 510;
    private static final int FLOWDELAY = 400;
    public static final String CRLF = "\r\n";
    public static final char CCBOLD = '\u0002';
    public static final char CCULINE = '\u001f';
    public static final char CCREVERSE = '\u0016';
    public static final char CCRESERVED = '\u0004';
    public static final char CCCOLOR = '\u0003';
    public static final int CLWHITE = 0;
    public static final int CLBLACK = 1;
    public static final int CLBLUE = 2;
    public static final int CLGREEN = 3;
    public static final int CLLRED = 4;
    public static final int CLBROWN = 5;
    public static final int CLPURPLE = 6;
    public static final int CLORANGE = 7;
    public static final int CLYELLOW = 8;
    public static final int CLLGREEN = 9;
    public static final int CLCYAN = 10;
    public static final int CLLCYAN = 11;
    public static final int CLLBLUE = 12;
    public static final int CLPINK = 13;
    public static final int CLGREY = 14;
    public static final int CLLGREY = 15;
    private Socket ircConn;
    private BufferedWriter ircOut;
    private Writer debugOut;
    private boolean debug;
    private boolean floodProtect = true;

    public IrcWriter(Socket s) throws IOException {
        this(s, null);
    }

    public IrcWriter(Socket ircConn, Writer debugOut) throws IOException {
        this.ircConn = ircConn;
        this.debugOut = debugOut;
        this.debug = debugOut != null;
        this.ircOut = new BufferedWriter(new OutputStreamWriter(ircConn.getOutputStream()));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isFloodProtect() {
        return this.floodProtect;
    }

    public void setFloodProtect(boolean floodProtect) {
        this.floodProtect = floodProtect;
    }

    public synchronized void putLine(String l) throws IOException {
        if (l.length() > 510) {
            l = l.substring(0, 510);
        }
        this.ircOut.write(l + CRLF);
        this.ircOut.flush();
        if (this.debugOut != null && this.debug) {
            this.debugOut.write(l + CRLF);
            this.debugOut.flush();
        }
        if (this.floodProtect) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String boldText(String str) {
        return '\u0002' + str + '\u0002';
    }

    public static String ulineText(String str) {
        return '\u001f' + str + '\u001f';
    }

    public static String reverseText(String str) {
        return '\u0016' + str + '\u0016';
    }

    public static String markText(String str) {
        return '\u0004' + str + '\u0004';
    }

    public static String colorText(String str, int color) {
        if (color < 0 || color > 15) {
            throw new IllegalArgumentException("Invalid color: " + color);
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\u0003').append(String.valueOf(color)).append(str).append('\u0003');
        return buf.toString();
    }

    public static String stripControlChars(String str) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\u0002' || str.charAt(i) == '\u001f' || str.charAt(i) == '\u0016' || str.charAt(i) == '\u0004') continue;
            if (str.charAt(i) == '\u0003') {
                if (i == str.length() - 1) continue;
                if (IrcWriter.isDigit(str.charAt(i + 1))) {
                    ++i;
                }
                if (i == str.length() - 1 || !IrcWriter.isDigit(str.charAt(i + 1))) continue;
                ++i;
                continue;
            }
            buf.append(str.charAt(i));
        }
        return buf.toString();
    }

    public static int parseColorCode(String str, int offset) {
        int color = -1;
        if (str.charAt(offset++) != '\u0003') {
            return -1;
        }
        if (offset > str.length() - 1) {
            return -1;
        }
        if (IrcWriter.isDigit(str.charAt(offset))) {
            color = str.charAt(offset++) - 48;
        }
        if (offset > str.length() - 1) {
            return color;
        }
        if (IrcWriter.isDigit(str.charAt(offset))) {
            color = color * 10 + (str.charAt(offset) - 48);
        }
        if (color > 15) {
            return 1;
        }
        return color;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public void close() {
        try {
            this.ircConn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

