/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.appletgui;

import com.bowman.appletgui.BowButton;
import com.bowman.appletgui.CharsetHandler;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class BowTextField
extends Canvas {
    private CharsetHandler csh;
    private Dimension tfSize;
    private String cuText = "";
    private boolean drawCaret = false;
    private boolean editable;
    private int caretPos;
    private int xInset = 5;
    private int yInset = 2;
    private int maxLength;
    private Image cuImage;
    private BowButton receiverBtn;
    private Color fgCol;
    private Color bgCol;
    private boolean newLength = false;
    private Graphics bBuf;

    public BowTextField(Dimension sz) {
        this.tfSize = sz == null ? new Dimension(120, 20) : sz;
        this.maxLength = 255;
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.setEditable(true);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.fgCol = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.bgCol = c;
    }

    public void setEditable(boolean b) {
        this.editable = b;
        if (this.editable) {
            this.enableEvents(8L);
            this.enableEvents(4L);
        } else {
            this.disableEvents(8L);
            this.disableEvents(4L);
        }
    }

    public void repaint() {
        this.paint(this.getGraphics());
    }

    public void setDefaultButton(BowButton b) {
        this.receiverBtn = b;
    }

    public void setText(String txt) {
        this.cuText = txt;
        this.repaint();
    }

    public String getText() {
        return this.cuText;
    }

    public void setMaxLength(int m) {
        this.maxLength = m;
        this.newLength = true;
    }

    public void paint(Graphics g) {
        if (g == null || this.csh == null) {
            return;
        }
        if (this.bBuf == null || this.newLength) {
            this.newLength = false;
            int virtualW = (this.maxLength + 1) * this.csh.getMaxWidth() + this.xInset;
            if (virtualW < this.tfSize.width) {
                virtualW = this.tfSize.width;
            }
            this.cuImage = this.createImage(virtualW, this.tfSize.height);
            this.bBuf = this.cuImage.getGraphics();
        }
        this.bBuf.setColor(this.bgCol);
        this.bBuf.fillRect(0, 0, this.cuImage.getWidth(this), this.tfSize.height);
        this.bBuf.setColor(this.fgCol);
        String caret = this.drawCaret ? "_" : "";
        int w = this.csh.drawString(this.cuText + caret, this.bBuf, this.xInset, this.yInset);
        w = w > this.tfSize.width ? this.tfSize.width - (w + this.xInset) : 0;
        g.drawImage(this.cuImage, w, 0, this);
    }

    public void setCharset(CharsetHandler ch) {
        this.csh = ch;
    }

    public void processFocusEvent(FocusEvent fe) {
        switch (fe.getID()) {
            case 1004: {
                this.drawCaret = true;
                break;
            }
            case 1005: {
                this.drawCaret = false;
            }
        }
        this.repaint();
    }

    public void processKeyEvent(KeyEvent ke) {
        if (ke.getID() == 401) {
            char chr = ke.getKeyChar();
            switch (ke.getKeyCode()) {
                case 8: {
                    if (this.cuText.length() <= 0) break;
                    this.cuText = this.cuText.substring(0, this.cuText.length() - 1);
                    break;
                }
                case 10: {
                    if (this.receiverBtn == null) break;
                    this.receiverBtn.clickBtn();
                    break;
                }
                default: {
                    if (chr < ' ' || chr >= '\u00ff' || this.cuText.length() > this.maxLength) break;
                    this.cuText = this.cuText + chr;
                }
            }
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        return this.tfSize;
    }

    public Dimension getPreferredSize() {
        return this.tfSize;
    }
}

