/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

public class Base64Encoder {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    public static byte[] decode(char[] ac) {
        int i = ac.length;
        for (int j = 0; j < ac.length; ++j) {
            if (ac[j] <= '\u00ff' && codes[ac[j]] >= 0) continue;
            --i;
        }
        int k = i / 4 * 3;
        if (i % 4 == 3) {
            k += 2;
        }
        if (i % 4 == 2) {
            ++k;
        }
        byte[] bytes = new byte[k];
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        for (int k1 = 0; k1 < ac.length; ++k1) {
            int byte0;
            int n = byte0 = ac[k1] <= '\u00ff' ? codes[ac[k1]] : -1;
            if (byte0 < 0) continue;
            i1 <<= 6;
            i1 |= byte0;
            if ((l += 6) < 8) continue;
            bytes[j1++] = (byte)(i1 >> (l -= 8) & 0xFF);
        }
        if (j1 != bytes.length) {
            throw new Error("Miscalculated data length (wrote " + j1 + " instead of " + bytes.length + ")");
        }
        return bytes;
    }

    public static char[] encode(byte[] bytes) {
        char[] ac = new char[(bytes.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            boolean flag = false;
            boolean flag1 = false;
            int k = 0xFF & bytes[i];
            k <<= 8;
            if (i + 1 < bytes.length) {
                k |= 0xFF & bytes[i + 1];
                flag1 = true;
            }
            k <<= 8;
            if (i + 2 < bytes.length) {
                k |= 0xFF & bytes[i + 2];
                flag = true;
            }
            ac[j + 3] = alphabet[flag ? k & 0x3F : 64];
            ac[j + 2] = alphabet[flag1 ? (k >>= 6) & 0x3F : 64];
            ac[j + 1] = alphabet[(k >>= 6) & 0x3F];
            ac[j] = alphabet[(k >>= 6) & 0x3F];
            i += 3;
            j += 4;
        }
        return ac;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Base64Encoder.codes[i] = -1;
        }
        for (int j = 65; j <= 90; ++j) {
            Base64Encoder.codes[j] = (byte)(j - 65);
        }
        for (int k = 97; k <= 122; ++k) {
            Base64Encoder.codes[k] = (byte)(26 + k - 97);
        }
        for (int l = 48; l <= 57; ++l) {
            Base64Encoder.codes[l] = (byte)(52 + l - 48);
        }
        Base64Encoder.codes[43] = 62;
        Base64Encoder.codes[47] = 63;
    }
}

