/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.CamdConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CamdNetMessage
implements CamdConstants,
Serializable {
    private static final long serialVersionUID = -961908656343234789L;
    public static final int TYPE_NEW = 0;
    public static final int TYPE_SENT = -1;
    public static final int TYPE_RECEIVED = -2;
    public static String[] MSG_NAMES = new String[30];
    private long timeStamp;
    private int commandTag;
    private int dataLength;
    private byte[] fixedData;
    private byte[] customData;
    private byte[] rdgKeyNumber = "0000".getBytes();
    private int upperBits;
    private String[] stringData;
    private Set providerContext = new HashSet();
    private int caId;
    private int networkId;
    private int providerIdent = -1;
    private int tid;
    private int pid;
    private int customId;
    private int dataHash;
    private int type;
    private String remoteAddress;
    private String originAddress;
    private String connectorName;
    private String linkedService;
    private boolean instant;
    private boolean timeOut;
    private Double arbiterNumber;
    private transient byte[] rawIn;
    private transient byte[] rawOut;
    private transient String protocol;
    private transient String filteredBy;
    private transient String profileName;
    private transient long cacheTime;
    private transient long queueTime;
    private transient long cwsTime;
    private transient long clientTime;
    private transient int originId;

    public static CamdNetMessage getNewcamdLoginMessage(String user, String password, byte[] clientId) {
        CamdNetMessage loginMsg = new CamdNetMessage(224);
        password = DESUtil.cryptPassword(password);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(user.getBytes());
            baos.write(0);
            baos.write(password.getBytes());
            baos.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        loginMsg.customData = baos.toByteArray();
        if (clientId.length == 2) {
            loginMsg.fixedData[2] = clientId[0];
            loginMsg.fixedData[3] = clientId[1];
        }
        return loginMsg;
    }

    public static CamdNetMessage parseCspEcmReq(DataInputStream is, String remoteAddr, int seqNr) throws IOException {
        CamdNetMessage msg = new CamdNetMessage(is.readUnsignedByte());
        msg.protocol = "Csp";
        msg.type = -2;
        msg.rawIn = new byte[0];
        msg.remoteAddress = remoteAddr;
        msg.setSequenceNr(seqNr);
        msg.originId = is.readInt();
        msg.networkId = is.readUnsignedShort();
        msg.caId = is.readUnsignedShort();
        msg.providerIdent = is.readInt();
        msg.setServiceId(is.readUnsignedShort());
        msg.dataLength = is.readUnsignedShort();
        if (msg.dataLength == 0) {
            throw new IOException("0 byte ecm received");
        }
        msg.customData = new byte[msg.dataLength];
        is.readFully(msg.customData);
        msg.refreshDataHash();
        if (!msg.isEcm()) {
            throw new IOException("bad command byte: " + msg.getCommandName());
        }
        return msg;
    }

    public static CamdNetMessage parseCspDcwRpl(DataInputStream is, String remoteAddr, int seqNr) throws IOException {
        CamdNetMessage msg = new CamdNetMessage(is.readUnsignedByte());
        msg.protocol = "Csp";
        msg.type = -2;
        msg.rawIn = new byte[0];
        msg.remoteAddress = remoteAddr;
        msg.setSequenceNr(seqNr);
        msg.setServiceId(is.readUnsignedShort());
        msg.dataLength = is.readUnsignedByte();
        if (msg.dataLength > 16) {
            throw new IOException(msg.dataLength + " byte dcw received");
        }
        msg.customData = new byte[msg.dataLength];
        is.readFully(msg.customData);
        msg.refreshDataHash();
        if (!msg.isEcm()) {
            throw new IOException("bad command byte: " + msg.getCommandName());
        }
        return msg;
    }

    public static CamdNetMessage parseNewcamd(byte[] raw, String remoteAddr) {
        CamdNetMessage msg = new CamdNetMessage(raw, "Newcamd");
        msg.commandTag = raw[10] & 0xFF;
        msg.dataLength = (raw[11] & 0xF) * 256 + (raw[12] & 0xFF);
        msg.upperBits = raw[11] & 0xF0;
        msg.customData = new byte[msg.dataLength];
        msg.fixedData = new byte[10];
        System.arraycopy(raw, 13, msg.customData, 0, msg.dataLength);
        System.arraycopy(raw, 0, msg.fixedData, 0, 10);
        msg.parseStringData();
        msg.refreshDataHash();
        msg.type = -2;
        msg.remoteAddress = remoteAddr;
        return msg;
    }

    public static CamdNetMessage parseRadegast(int commandTag, byte[] data, byte[] raw, String remoteAddr) {
        CamdNetMessage msg = new CamdNetMessage(raw, "Radegast");
        msg.commandTag = commandTag;
        msg.fixedData = new byte[10];
        msg.dataLength = data.length;
        msg.customData = new byte[msg.dataLength];
        System.arraycopy(data, 0, msg.customData, 0, data.length);
        msg.stringData = new String[0];
        msg.refreshDataHash();
        msg.type = -2;
        msg.remoteAddress = remoteAddr;
        if (msg.isEcm()) {
            msg.upperBits = 112;
        }
        return msg;
    }

    public static CamdNetMessage parseCacheReq(DataInputStream dais, boolean extra) throws IOException {
        CamdNetMessage msg = new CamdNetMessage(dais.readUnsignedByte());
        msg.setServiceId(dais.readUnsignedShort());
        msg.setNetworkId(dais.readUnsignedShort());
        msg.setCaId(dais.readUnsignedShort());
        msg.protocol = "Dummy";
        msg.dataHash = dais.readInt();
        if (extra && dais.available() == 8) {
            msg.arbiterNumber = new Double(dais.readDouble());
        }
        return msg;
    }

    public static CamdNetMessage parseCacheRpl(DataInputStream dais, CamdNetMessage request, boolean extra) throws IOException {
        CamdNetMessage msg = new CamdNetMessage(dais.readUnsignedByte());
        msg.type = -2;
        msg.protocol = "Dummy";
        msg.setServiceId(request.getServiceId());
        msg.networkId = request.networkId;
        msg.caId = request.caId;
        if (dais.available() > 0) {
            msg.customData = new byte[16];
            dais.readFully(msg.customData);
            msg.refreshDataHash();
            msg.dataLength = 16;
            try {
                if (extra && dais.available() > 0) {
                    msg.connectorName = dais.readUTF();
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
        return msg;
    }

    public static CamdNetMessage parseGHttpReq(DataInputStream dais, String remoteAddr, boolean full) throws IOException {
        CamdNetMessage msg = new CamdNetMessage(dais.readUnsignedByte());
        msg.type = -2;
        msg.protocol = "GHttp";
        msg.remoteAddress = remoteAddr;
        if (full) {
            msg.networkId = dais.readUnsignedShort();
            msg.tid = dais.readUnsignedShort();
            msg.pid = dais.readUnsignedShort();
        }
        msg.caId = dais.readUnsignedShort();
        msg.providerIdent = dais.readInt();
        msg.setServiceId(dais.readUnsignedShort());
        msg.dataLength = dais.readUnsignedShort();
        msg.customData = new byte[msg.dataLength];
        dais.readFully(msg.customData);
        msg.refreshDataHash();
        msg.rawIn = msg.customData;
        if (!msg.isEcm()) {
            throw new IOException("bad command byte: " + msg.getCommandName());
        }
        return msg;
    }

    private CamdNetMessage() {
        this.timeStamp = System.currentTimeMillis();
    }

    private CamdNetMessage(byte[] raw, String protocol) {
        this();
        this.rawIn = raw;
        this.protocol = protocol;
    }

    public CamdNetMessage(CamdNetMessage msg) {
        this();
        this.protocol = msg.protocol;
        this.rawIn = msg.rawIn;
        this.rawOut = msg.rawOut;
        this.commandTag = msg.commandTag;
        this.upperBits = msg.upperBits;
        this.setCustomData(msg.customData);
        this.setFixedData(msg.fixedData);
        this.dataHash = msg.dataHash;
        this.remoteAddress = msg.remoteAddress;
        this.originAddress = msg.originAddress;
        this.rdgKeyNumber = msg.rdgKeyNumber;
        this.arbiterNumber = msg.arbiterNumber;
        this.connectorName = msg.connectorName;
        this.type = msg.type;
        this.caId = msg.caId;
        this.providerIdent = msg.providerIdent;
        this.filteredBy = msg.filteredBy;
        this.providerContext.addAll(msg.providerContext);
        this.originId = msg.originId;
        this.networkId = msg.networkId;
        this.customId = msg.customId;
        this.profileName = msg.profileName;
        this.linkedService = msg.linkedService;
    }

    public CamdNetMessage(int commandTag) {
        this();
        this.commandTag = commandTag;
        this.dataLength = 0;
        this.customData = new byte[0];
        this.stringData = new String[0];
        this.fixedData = new byte[10];
        this.type = 0;
    }

    public CamdNetMessage(int commandTag, int dataHash) {
        this();
        this.commandTag = commandTag;
        this.dataHash = dataHash;
        this.dataLength = 0;
        this.customData = new byte[0];
        this.stringData = new String[0];
        this.fixedData = new byte[10];
        this.type = -2;
    }

    public CamdNetMessage(int commandTag, byte[] customData) {
        this();
        this.commandTag = commandTag;
        this.dataLength = customData.length;
        this.customData = customData;
        this.stringData = new String[0];
        this.fixedData = new byte[10];
        this.type = -2;
        this.refreshDataHash();
    }

    public int getCommandTag() {
        return this.commandTag;
    }

    public void setCommandTag(int commandTag) {
        this.commandTag = commandTag;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public byte[] getCustomData() {
        return this.customData;
    }

    public byte[] getRdgKeyNumber() {
        return this.rdgKeyNumber;
    }

    public void setRdgProviderId(byte[] rdgProviderId) {
        this.providerIdent = Integer.parseInt(new String(rdgProviderId), 16);
        this.providerContext.add(DESUtil.intToByteString(this.providerIdent, 3));
    }

    public void setRdgKeyNumber(byte[] rdgKeyNumber) {
        this.rdgKeyNumber = rdgKeyNumber;
    }

    public int getUpperBits() {
        return this.upperBits;
    }

    public void setCustomData(byte[] customData) {
        this.customData = new byte[customData.length];
        System.arraycopy(customData, 0, this.customData, 0, customData.length);
        this.dataLength = customData.length;
        if (this.isOsdMsg()) {
            this.parseStringData();
        }
    }

    public void refreshDataHash() {
        try {
            this.dataHash = new String(this.customData, "ISO-8859-1").hashCode();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void clearData() {
        this.customData = new byte[0];
    }

    public void setFixedData(byte[] fixedData) {
        this.fixedData = new byte[fixedData.length];
        System.arraycopy(fixedData, 0, this.fixedData, 0, fixedData.length);
    }

    public void setCaId(int caId) {
        this.caId = caId;
    }

    public void setProviderContext(String[] providers) {
        if (providers != null) {
            this.providerContext = new HashSet();
            this.providerContext.addAll(Arrays.asList(providers));
            if (providers.length == 1) {
                this.setProviderIdent(DESUtil.byteStringToInt(providers[0]));
            }
        }
    }

    public Set getProviderContext() {
        return this.providerContext;
    }

    public int getCaId() {
        return this.caId;
    }

    public int getCaIdFromHdr() {
        int cId = (this.fixedData[4] & 0xFF) << 8;
        return cId |= this.fixedData[5] & 0xFF;
    }

    public int getProviderFromHdr() {
        byte[] pi = new byte[3];
        System.arraycopy(this.fixedData, 6, pi, 0, 3);
        return DESUtil.bytesToInt(pi);
    }

    public void setProviderInHdr(int provider) {
        byte[] buf = DESUtil.intToBytes(provider, 3);
        System.arraycopy(buf, 0, this.fixedData, 6, 3);
    }

    public void setCaIdInHdr(int id) {
        this.fixedData[4] = (byte)(id >> 8 & 0xFF);
        this.fixedData[5] = (byte)(id & 0xFF);
    }

    public byte[] getFixedData() {
        return this.fixedData;
    }

    public String[] getStringData() {
        return this.stringData;
    }

    public int getType() {
        return this.type;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getClientId() {
        int cId = (this.fixedData[2] & 0xFF) << 8;
        return cId |= this.fixedData[3] & 0xFF;
    }

    public String getClientIdStr() {
        int cId = this.getClientId();
        for (int i = 0; i < CL_IDS.length; ++i) {
            if (CL_IDS[i] != cId) continue;
            return CL_NAMES[i];
        }
        String unknown = Integer.toHexString(cId);
        while (unknown.length() < 4) {
            unknown = "0" + unknown;
        }
        return "? (0x" + unknown + ")";
    }

    public void setSent(String remoteAddr, byte[] rawOut, String protocol) {
        this.type = -1;
        this.remoteAddress = remoteAddr;
        this.rawOut = rawOut;
        this.protocol = protocol;
    }

    public void setSequenceNr(int sequenceNr) {
        this.fixedData[0] = (byte)(sequenceNr >> 8 & 0xFF);
        this.fixedData[1] = (byte)(sequenceNr & 0xFF);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public CamdNetMessage getEmptyReply() {
        if (!this.isEcm()) {
            throw new IllegalStateException("getEcmReply on a Non-ECM message: " + this);
        }
        CamdNetMessage reply = new CamdNetMessage(this.getCommandTag());
        reply.setSequenceNr(this.getSequenceNr());
        reply.setCaId(this.getCaId());
        return reply;
    }

    public CamdNetMessage getEmmReply() {
        if (!this.isEmm()) {
            throw new IllegalStateException("getEmmReply on a Non-EMM message: " + this);
        }
        CamdNetMessage reply = new CamdNetMessage(this.getCommandTag());
        reply.setSequenceNr(this.getSequenceNr());
        reply.setCaId(this.getCaId());
        reply.upperBits = 16;
        return reply;
    }

    public boolean isEmm() {
        return this.commandTag >= 130 && this.commandTag <= 143;
    }

    public boolean isEcm() {
        return this.commandTag == 128 || this.commandTag == 129;
    }

    public boolean isDcw() {
        return this.isEcm() && (this.dataLength == 16 || this.dataLength == 0);
    }

    public boolean isOsdMsg() {
        return this.commandTag == 209;
    }

    public boolean isKeepAlive() {
        return this.commandTag == 253;
    }

    public int getSequenceNr() {
        int nr = 0;
        nr |= (this.fixedData[0] & 0xFF) << 8;
        return nr |= this.fixedData[1] & 0xFF;
    }

    public int getServiceId() {
        int id = 0;
        id |= (this.fixedData[2] & 0xFF) << 8;
        return id |= this.fixedData[3] & 0xFF;
    }

    public void setServiceId(int id) {
        this.fixedData[2] = (byte)(id >> 8 & 0xFF);
        this.fixedData[3] = (byte)(id & 0xFF);
    }

    public String getCommandName() {
        switch (this.commandTag) {
            case 209: {
                return "EXT_OSD_MESSAGE (" + this.stringData[0] + ")";
            }
            case 211: {
                return "EXT_ADD_CARD";
            }
            case 212: {
                return "EXT_REMOVE_CARD";
            }
            case 214: {
                return "EXT_GET_VERSION" + (this.stringData.length > 0 ? " (" + this.stringData[0] + ")" : "");
            }
            case 215: {
                return "EXT_SID_LIST";
            }
        }
        int index = this.commandTag - 224;
        if (index >= 0 && index < MSG_NAMES.length) {
            return MSG_NAMES[index];
        }
        if (this.isEcm()) {
            if (this.dataLength == 16 || this.dataLength == 0) {
                return "DCW (0x" + Integer.toHexString(this.commandTag) + ")";
            }
            return "ECM (0x" + Integer.toHexString(this.commandTag) + ")";
        }
        if (this.isEmm()) {
            return "EMM (0x" + Integer.toHexString(this.commandTag) + ")";
        }
        return "*UNKNOWN* (0x" + Integer.toHexString(this.commandTag) + ")";
    }

    private void parseStringData() {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < this.dataLength; ++i) {
            if (this.customData[i] == 0) {
                strings.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append((char)this.customData[i]);
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
        }
        this.stringData = strings.toArray(new String[strings.size()]);
    }

    public String toString() {
        String data = this.isEcm() ? " >> " + this.hashCodeStr() : (this.getDataLength() == 0 ? "" : " >> Custom data: " + this.getDataLength() + " bytes >> " + DESUtil.bytesToString(this.customData, 16) + (this.getDataLength() > 16 ? " ..." : ""));
        return "[" + this.getSequenceNr() + " " + Integer.toHexString(this.getServiceId()) + "] " + this.getCommandName() + " >> " + DESUtil.bytesToString(this.fixedData) + " >> " + this.getUpperBitsStr() + data;
    }

    public String toDebugString() {
        return this.hashCodeStr() + " " + this.getCommandName() + " [" + DESUtil.bytesToString(this.customData) + "] (" + (this.connectorName == null ? "unknown" : this.connectorName) + ") - profile: " + this.profileName + " " + DESUtil.intToHexString(this.networkId, 4) + "-" + DESUtil.intToHexString(this.caId, 4) + (this.originAddress == null ? "" : " from " + this.originAddress);
    }

    private String getUpperBitsStr() {
        String s = Integer.toBinaryString(this.upperBits >> 4);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return s + " (" + DESUtil.byteToString((byte)this.upperBits) + ")";
    }

    public int getDataHash() {
        return this.dataHash;
    }

    public String getOriginAddress() {
        return this.originAddress;
    }

    public void setOriginAddress(String originAddress) {
        this.originAddress = originAddress;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public boolean isEmpty() {
        return this.dataLength == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamdNetMessage that = (CamdNetMessage)o;
        return this.hashCode() == that.hashCode();
    }

    public int hashCode() {
        return this.dataHash;
    }

    public String hashCodeStr() {
        StringBuffer sb = new StringBuffer(Integer.toHexString(this.hashCode()));
        while (sb.length() < 8) {
            sb.insert(0, '0');
        }
        return sb.toString().toUpperCase();
    }

    public void setInstant(boolean instant) {
        this.instant = instant;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public void setTimeOut(boolean timeOut) {
        this.timeOut = timeOut;
    }

    public boolean isTimeOut() {
        return this.timeOut;
    }

    public void setArbiterNumber(Double arbiterNumber) {
        this.arbiterNumber = arbiterNumber;
    }

    public Double getArbiterNumber() {
        return this.arbiterNumber;
    }

    public byte[] getRawIn() {
        return this.rawIn;
    }

    public byte[] getRawOut() {
        return this.rawOut;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getLabel() {
        return this.protocol + " SEQ:" + this.getSequenceNr() + " SID:" + Integer.toHexString(this.getServiceId()) + " " + this.getCommandName() + " " + this.dataLength + " bytes";
    }

    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public void setQueueTime(long queueTime) {
        this.queueTime = queueTime;
    }

    public void setCWSTime(long cwsTime) {
        this.cwsTime = cwsTime;
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public long getCWSTime() {
        return this.cwsTime;
    }

    public long getClientTime() {
        return this.clientTime;
    }

    public void setFilteredBy(String filteredBy) {
        this.filteredBy = filteredBy;
    }

    public String getFilteredBy() {
        return this.filteredBy;
    }

    public boolean isFiltered() {
        return this.filteredBy != null;
    }

    public int getOriginId() {
        return this.originId;
    }

    public void setOriginId(int originId) {
        this.originId = originId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getProviderIdent() {
        return this.providerIdent;
    }

    public void setProviderIdent(int providerIdent) {
        this.providerIdent = providerIdent;
    }

    public int getCustomId() {
        return this.customId;
    }

    public void setCustomId(int customId) {
        this.customId = customId;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setLinkedService(String linkedService) {
        this.linkedService = linkedService;
    }

    public String getLinkedService() {
        return this.linkedService;
    }

    static {
        Field[] fields = CamdNetMessage.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getType() != Integer.TYPE || !fields[i].getName().startsWith("MSG_")) continue;
            try {
                CamdNetMessage.MSG_NAMES[fields[i].getInt(null) - 224] = fields[i].getName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

