/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class GamespyQueryConnection {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final String CMDSTATUS = "\\status\\";
    private DatagramSocket dgSock;
    private int port;
    private int timeout;
    private InetAddress host;

    public GamespyQueryConnection(String host, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port specified");
        }
        try {
            this.host = InetAddress.getByName(host);
            this.port = port;
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Unknown host specified");
        }
        this.timeout = 10000;
    }

    public GamespyQueryConnection(InetAddress host, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port specified");
        }
        if (host == null) {
            throw new IllegalArgumentException("Invalid host specified");
        }
        this.port = port;
        this.host = host;
        this.timeout = 10000;
    }

    public void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("Illegal timeout specified");
        }
        this.timeout = timeout;
    }

    public Map performCustom(String query) throws IOException {
        return this.performQuery("\\" + query + "\\");
    }

    public Map performStatus() throws IOException {
        return this.performQuery(CMDSTATUS);
    }

    private Map performQuery(String query) throws IOException {
        byte[] recvBuf = new byte[4096];
        DatagramPacket statusPacket = new DatagramPacket(query.getBytes(), query.length(), this.host, this.port);
        DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
        String reply = "";
        HashMap cVars = new HashMap();
        boolean finalReceived = false;
        try {
            this.dgSock = new DatagramSocket();
            this.dgSock.setSoTimeout(this.timeout);
            this.dgSock.send(statusPacket);
            while (!finalReceived) {
                this.dgSock.receive(recvPacket);
                reply = new String(recvPacket.getData(), 0, recvPacket.getLength());
                finalReceived = this.parseReply(reply, cVars);
            }
        }
        catch (InterruptedIOException ioe) {
            throw new IOException("Status query timed out");
        }
        catch (SocketException se) {
            se.printStackTrace();
            throw new IOException("Status query failed: " + se);
        }
        return cVars;
    }

    private boolean parseReply(String reply, Map target) {
        reply = reply + "\\";
        StringTokenizer st = new StringTokenizer(reply, "\\", true);
        String key = null;
        String value = null;
        st.nextToken();
        while (st.hasMoreTokens()) {
            key = st.nextToken();
            if ("\\".equals(key)) continue;
            st.nextToken();
            if (!st.hasMoreTokens() || "\\".equals(value = st.nextToken())) continue;
            target.put(key, value);
            st.nextToken();
        }
        return reply.indexOf("final") != -1;
    }

    public static void main(String[] args) throws Exception {
        GamespyQueryConnection gamespyQry = new GamespyQueryConnection("yoda.voodoo-people.com", 2303);
        Map reply = gamespyQry.performCustom("status");
        Iterator iter = reply.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            System.out.println(key);
        }
    }
}

