/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.AcceptThread;
import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.util.Globber;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ListenPort
implements XmlConfigurable {
    private static Map portNumbers = new HashMap();
    private String protocol;
    private int port;
    private InetAddress bindAddr;
    private boolean alive;
    private ServerSocket srv;
    private Thread acceptThread;
    private Map properties = new HashMap();
    private Set allowList = new HashSet();
    private Set denyList = new HashSet();
    private CaProfile profile;

    public ListenPort(String protocol) {
        this.protocol = protocol;
        if ("Csp".equals(protocol)) {
            this.alive = true;
        }
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        ListenPort lp;
        int port = xml.getPortValue("listen-port");
        if (portNumbers.containsKey(new Integer(port)) && (lp = (ListenPort)portNumbers.get(new Integer(port))) != this) {
            throw new ConfigException(xml.getFullName(), "listen-port", "Listen-port '" + port + "' already in use by [" + lp + "]");
        }
        this.setPort(port);
        String bindIp = null;
        this.bindAddr = null;
        try {
            bindIp = xml.getStringValue("bind-ip");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (bindIp != null) {
            try {
                this.bindAddr = InetAddress.getByName(bindIp);
            }
            catch (UnknownHostException e) {
                throw new ConfigException(xml.getFullName(), "bind-ip", "Invalid listen-port bind-ip: " + bindIp);
            }
        }
        this.properties.clear();
        Iterator iter = xml.getMultipleSubConfigs(null);
        if (iter != null) {
            ProxyXmlConfig e;
            while (iter.hasNext()) {
                e = (ProxyXmlConfig)iter.next();
                if (e.getName() == null || e.getName().length() <= 0) continue;
                this.properties.put(e.getName(), xml);
            }
            try {
                e = (ProxyXmlConfig)this.properties.remove("allow-list");
                if (e == null) {
                    throw new ConfigException("");
                }
                String allow = e.getStringValue("allow-list");
                this.allowList = new HashSet<String>(Arrays.asList(allow.split(" ")));
            }
            catch (ConfigException ce) {
                this.allowList = new HashSet();
            }
            try {
                e = (ProxyXmlConfig)this.properties.remove("deny-list");
                if (e == null) {
                    throw new ConfigException("");
                }
                String deny = e.getStringValue("deny-list");
                this.denyList = new HashSet<String>(Arrays.asList(deny.split(" ")));
            }
            catch (ConfigException ce) {
                this.denyList = new HashSet();
            }
        }
    }

    public String getProperties() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ProxyXmlConfig xml = (ProxyXmlConfig)this.properties.get(key);
            try {
                sb.append(xml.getSubConfig(key));
            }
            catch (ConfigException e) {}
        }
        return sb.toString();
    }

    public String getStringProperty(String name) {
        ProxyXmlConfig xml = (ProxyXmlConfig)this.properties.get(name);
        if (xml == null) {
            return null;
        }
        try {
            return xml.getStringValue(name);
        }
        catch (ConfigException e) {
            return null;
        }
    }

    public String getStringProperty(String element, String attribute) {
        ProxyXmlConfig xml = (ProxyXmlConfig)this.properties.get(element);
        if (xml == null) {
            return null;
        }
        try {
            xml = xml.getSubConfig(element);
            return xml.getStringValue(attribute);
        }
        catch (ConfigException e) {
            return null;
        }
    }

    public byte[] getBytesProperty(String name) {
        ProxyXmlConfig xml = (ProxyXmlConfig)this.properties.get(name);
        if (xml == null) {
            return null;
        }
        try {
            return xml.getBytesValue(name);
        }
        catch (ConfigException e) {
            return null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        portNumbers.put(new Integer(port), this);
    }

    public ServerSocket getServerSocket() {
        return this.srv;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        if (this.srv != null) {
            this.destroy();
        }
        portNumbers.put(new Integer(serverSocket.getLocalPort()), this);
        this.srv = serverSocket;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public CaProfile getProfile() {
        return this.profile;
    }

    public void setProfile(CaProfile profile) {
        this.profile = profile;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isDenied(String ip) {
        HashSet set = new HashSet(ProxyConfig.getInstance().getDefaultDenyList());
        set.addAll(this.denyList);
        return ListenPort.matchesMasks(ip, set);
    }

    public boolean isAllowed(String ip) {
        return this.allowList.isEmpty() || ListenPort.matchesMasks(ip, this.allowList);
    }

    private static boolean matchesMasks(String s, Set masks) {
        Iterator iter = masks.iterator();
        while (iter.hasNext()) {
            if (!Globber.match((String)((String)iter.next()), (String)s, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void start(CamdMessageListener listener, CaProfile profile) {
        this.profile = profile;
        if (this.srv == null) {
            try {
                this.createServerSocket();
            }
            catch (IOException e) {
                CardServProxy.logger.throwing(e);
                CardServProxy.logger.warning("Failed to open listen port [" + this + "] for '" + profile.getName() + "' (" + e.getMessage() + ")");
            }
        }
        this.acceptThread = new AcceptThread(listener, this);
        this.alive = true;
        portNumbers.put(new Integer(this.port), this);
        this.acceptThread.start();
        CardServProxy.logger.info("Listen port ready for profile '" + this.getProfile().getName() + "' - " + this);
    }

    public void destroy() {
        if (!this.alive || "Csp".equals(this.protocol)) {
            return;
        }
        this.alive = false;
        try {
            if (this.srv != null) {
                this.srv.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.acceptThread != null) {
            this.acceptThread.interrupt();
        }
        this.srv = null;
        portNumbers.remove(new Integer(this.port));
        CardServProxy.logger.info("Listen port closed: " + this);
    }

    public String toString() {
        String p = ("" + this.protocol.charAt(0)).toUpperCase();
        return p + this.port + (this.bindAddr == null ? "" : "@" + this.bindAddr.getHostAddress());
    }

    public void createServerSocket() throws IOException {
        this.srv = new ServerSocket();
        if (this.bindAddr == null) {
            this.srv.bind(new InetSocketAddress(this.port));
        } else {
            this.srv.bind(new InetSocketAddress(this.bindAddr, this.port));
        }
    }
}

