/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.CamdConstants;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.util.Globber;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingPlugin
implements ProxyPlugin {
    private static Map newcamdCmds;
    private ProxyLogger proxyLogger;
    private CardServProxy proxy;
    private Map loggers = new HashMap();
    private String logDir;
    private String ipFilter;
    private Level logLevel;
    private CtrlCommand filterCmd;
    private CtrlCommand delayCmd;
    private CtrlCommand sendCmd;
    private long delay = 0L;

    public LoggingPlugin() {
        this.proxyLogger = ProxyLogger.getLabeledLogger(this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.logLevel = ProxyLogger.getLogLevel(xml.getStringValue("log-level"));
        this.logDir = xml.getFileValue("log-dir", true, true);
        this.ipFilter = xml.getStringValue("ip-filter", "*");
        this.proxyLogger.fine("Configuration updated");
    }

    public void start(CardServProxy proxy) {
        this.filterCmd = new CtrlCommand("set-ip-filter", "Set IP filter", "Set the IP filter for the plugin, wildcards supported (only traffic for matching addresses will be logged).");
        this.filterCmd.addParam("filter", "").setValue(this.ipFilter);
        this.delayCmd = new CtrlCommand("set-test-delay", "Set test-delay", "Set a fixed delay time (in ms) applied to each logged request before processing, for testing purposes.");
        this.delayCmd.addParam("delay", "").setValue(String.valueOf(this.delay));
        this.sendCmd = new CtrlCommand("send-to-session", "Send to session", "Send an arbitrary newcamd msg to a connected client session, for testing purposes.");
        this.sendCmd.addParam("session-id", "");
        this.sendCmd.addParam("cmd", "cmd").setOptions(newcamdCmds.keySet(), false);
        this.sendCmd.addParam("bytes", "bytes").setValue(" ");
        try {
            this.filterCmd.register(this);
            this.delayCmd.register(this);
            this.sendCmd.register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.proxy = proxy;
    }

    public void stop() {
        if (this.filterCmd != null) {
            this.filterCmd.unregister();
        }
        if (this.delayCmd != null) {
            this.delayCmd.unregister();
        }
        if (this.sendCmd != null) {
            this.sendCmd.unregister();
        }
        Iterator iter = this.loggers.values().iterator();
        while (iter.hasNext()) {
            ((ProxyLogger)iter.next()).close();
        }
        this.loggers.clear();
    }

    public String getName() {
        return "LoggingPlugin";
    }

    public String getDescription() {
        return "Logs all ecm traffic between client sessions and proxy to file.";
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty("ip-filter", this.ipFilter);
        p.setProperty("delay", String.valueOf(this.delay));
        p.setProperty("loggers", String.valueOf(this.loggers.size()));
        return p;
    }

    public CtrlCommandResult runCtrlCmdSetIpFilter(Map params) {
        String newFilter = (String)params.get("filter");
        if (newFilter == null || "".equals(newFilter)) {
            this.ipFilter = "*";
            return new CtrlCommandResult(true, "IP filter cleared (set to '*').");
        }
        this.ipFilter = newFilter;
        return new CtrlCommandResult(true, "IP filter set to: " + this.ipFilter);
    }

    public CtrlCommandResult runCtrlCmdSetTestDelay(Map params) {
        String newDelay = (String)params.get("delay");
        if (newDelay == null || "".equals(newDelay)) {
            this.setDelay(0L);
            return new CtrlCommandResult(true, "Test-delay removed.");
        }
        this.setDelay(Long.parseLong(newDelay));
        return new CtrlCommandResult(true, "Test-delay set to " + this.delay + " ms");
    }

    public void setDelay(long delay) {
        if (delay < 0L) {
            delay = 0L;
        }
        this.delay = delay;
        if (this.delayCmd != null) {
            this.delayCmd.getParam("delay").setValue(String.valueOf(delay));
        }
    }

    public CtrlCommandResult runCtrlCmdSendToSession(Map params) {
        byte[] bytes;
        String sessionId = (String)params.get("session-id");
        String cmdStr = (String)params.get("cmd");
        String byteStr = (String)params.get("bytes");
        ProxySession session = this.proxy.getSessionManager().getSession(sessionId);
        if (session == null || !"Newcamd".equals(session.getProtocol())) {
            return new CtrlCommandResult(false, "No such newcamd sesssion: " + sessionId);
        }
        Integer cmd = (Integer)newcamdCmds.get(cmdStr);
        if (cmd == null) {
            return new CtrlCommandResult(false, "No such newcamd cmd: " + cmdStr);
        }
        try {
            bytes = DESUtil.stringToBytes(byteStr);
        }
        catch (Exception e) {
            return new CtrlCommandResult(false, "Invalid byte string '" + byteStr + "': " + e);
        }
        CamdNetMessage msg = new CamdNetMessage(cmd);
        msg.setCustomData(bytes);
        int status = session.sendMessage(msg);
        if (status != -1) {
            this.sendCmd.getParam("session-id").setValue(sessionId);
            this.sendCmd.getParam("tag").setValue(cmdStr);
            if (bytes.length == 0) {
                this.sendCmd.getParam("bytes").setValue(" ");
            } else {
                this.sendCmd.getParam("bytes").setValue(DESUtil.bytesToString(bytes));
            }
        }
        return new CtrlCommandResult(status != -1, "Status: " + status + " Message sent: " + msg);
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        if (msg.getType() == 0) {
            this.proxyLogger.warning("Bad message (not sent/received): " + msg);
        } else {
            this.logMessage(session, msg);
        }
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] data, boolean admin) {
        return null;
    }

    private void logMessage(ProxySession session, CamdNetMessage msg) {
        if (!Globber.match((String)this.ipFilter, (String)msg.getRemoteAddress(), (boolean)false)) {
            return;
        }
        ProxyLogger logger = this.getLogger(session.getLabel().replace(':', '_').replace('*', 'A').replace('?', 'Q'));
        if (logger == null) {
            return;
        }
        switch (msg.getType()) {
            case -2: {
                logger.info(session.getLabel() + " Recv [" + msg.getLabel() + "]: " + DESUtil.bytesToString(msg.getRawIn()));
                if (msg.isFiltered() || !msg.isEcm() || this.delay <= 0L) break;
                try {
                    logger.info(session.getLabel() + " Delaying [" + msg.getLabel() + "]: " + this.delay + " ms ...");
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            case -1: {
                logger.info(session.getLabel() + " Sent [" + msg.getLabel() + "]: " + DESUtil.bytesToString(msg.getRawOut()));
            }
        }
        if (msg.isFiltered()) {
            logger.info(session.getLabel() + " Filtered [" + msg.getLabel() + "] Reason: " + msg.getFilteredBy());
        }
    }

    private ProxyLogger getLogger(String session) {
        if (this.loggers.containsKey(session)) {
            return (ProxyLogger)this.loggers.get(session);
        }
        try {
            ProxyLogger logger = this.createFileLogger(session, new File(this.logDir, session + ".log"));
            this.loggers.put(session, logger);
            return logger;
        }
        catch (Exception e) {
            this.proxyLogger.warning("Unable to initialize logger FileHandler: " + e);
            this.proxyLogger.throwing(e);
            return null;
        }
    }

    private ProxyLogger createFileLogger(String name, File logFile) throws IOException {
        ProxyLogger logger = ProxyLogger.getProxyLogger("com.bowman.cardserv." + name);
        FileHandler handler = new FileHandler(logFile.getAbsolutePath(), true);
        handler.setFormatter(new CamdTrafficFormatter());
        logger.getWrappedLogger().addHandler(handler);
        logger.getWrappedLogger().setUseParentHandlers(false);
        logger.getWrappedLogger().setLevel(this.logLevel);
        return logger;
    }

    public String toString() {
        return this.getClass().getName();
    }

    static {
        try {
            Field[] fields = CamdConstants.class.getFields();
            newcamdCmds = new TreeMap();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith("MSG_")) continue;
                newcamdCmds.put(fields[i].getName(), fields[i].get(null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class CamdTrafficFormatter
    extends Formatter {
        private static SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");

        CamdTrafficFormatter() {
        }

        public String format(LogRecord lr) {
            return "[" + fmt.format(new Date(lr.getMillis())) + "] " + lr.getMessage() + "\n";
        }
    }
}

