/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CwsServiceMapper;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CacheListener;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.StatusCommand;
import com.bowman.cardserv.web.XmlHelper;
import com.bowman.util.CronTimer;
import com.bowman.util.CronTimerListener;
import com.bowman.util.FileChangeListener;
import com.bowman.util.FileWatchdog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SidCacheLinker
implements CacheListener,
FileChangeListener,
CronTimerListener {
    private static final int MAX_DELTA = 5000;
    private ProxyConfig config;
    private CacheHandler cache;
    private Map sidLinksMap = Collections.synchronizedMap(new HashMap());
    private Map sidLockMap = new MessageCacheMap(5000L);
    private Map requestMap = new MessageCacheMap(20000L);
    private Map sidRequestMap = new MessageCacheMap(5000L);
    private Map replyMap = new MessageCacheMap(20000L);
    private ProxyLogger logger;
    private SidEntry testService;
    private FileWatchdog fw;
    private File linksFile;
    private long linksFileTimeStamp;
    private boolean linksChanged;
    private String defaultProfile;
    private Map addedServices = Collections.synchronizedMap(new HashMap());
    private Map requiredServices = Collections.synchronizedMap(new HashMap());

    public SidCacheLinker() {
        this.registerStatusCommands();
    }

    public void init() {
        if (this.logger == null) {
            this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
            this.config = ProxyConfig.getInstance();
            this.cache = this.config.getCacheHandler();
            this.linksFile = new File("etc", "links.cfg");
            this.loadSidLinkMap();
            this.registerCtrlCommands();
            this.fw = new FileWatchdog(this.linksFile.getPath(), 3000L);
            this.fw.addFileChangeListener((FileChangeListener)this);
            this.fw.start();
            CronTimer saveTimer = new CronTimer("* * * * *");
            saveTimer.addTimerListener((CronTimerListener)this);
            saveTimer.start();
        }
    }

    public void fileChanged(String s) {
        this.logger.info("File changes detected: " + s);
        this.loadSidLinkMap();
    }

    public void timeout(CronTimer cronTimer) {
        this.saveSidLinkMap();
    }

    protected synchronized void loadSidLinkMap() {
        if (!this.linksFile.exists()) {
            try {
                this.linksFile.createNewFile();
            }
            catch (IOException e) {
                this.logger.throwing(e);
                this.logger.warning("Unable to create sid links file: " + e);
            }
        } else {
            try {
                String line;
                this.sidLinksMap.clear();
                ProxyConfig config = ProxyConfig.getInstance();
                BufferedReader br = new BufferedReader(new FileReader(this.linksFile));
                while ((line = br.readLine()) != null) {
                    String[] links = line.split(",");
                    HashSet<String> tmp = new HashSet<String>();
                    for (int i = 0; i < links.length; ++i) {
                        String[] tokens = links[i].trim().split(":");
                        String[] profileStr = tokens[1].split("-");
                        CaProfile profile = config.getProfileById(Integer.parseInt(profileStr[0], 16), Integer.parseInt(profileStr[1], 16));
                        if (profile == null) {
                            this.logger.warning("Ignoring links for unknown profile '" + tokens[1] + "' in line: " + line);
                            continue;
                        }
                        tmp.add(tokens[0] + ":" + profile.getName());
                        if (this.defaultProfile != null) continue;
                        this.defaultProfile = profile.getName();
                    }
                    this.addMultipleLinks(tmp.toArray(new String[tmp.size()]));
                }
                br.close();
                TreeSet<String> linkStrs = new TreeSet<String>();
                Iterator iter = this.sidLinksMap.values().iterator();
                while (iter.hasNext()) {
                    linkStrs.add(iter.next().toString());
                }
                this.logger.info("Loaded sid links file, " + linkStrs.size() + " collections: " + linkStrs);
                this.refreshAddedSet();
                this.linksChanged = false;
            }
            catch (NullPointerException e) {
                this.logger.throwing(e);
                this.logger.fine("Unable to read sid links file, retrying...");
            }
            catch (Exception e) {
                this.logger.throwing(e);
                this.logger.warning("Unable to read sid links file: " + e);
            }
        }
    }

    protected synchronized void saveSidLinkMap() {
        if (System.currentTimeMillis() - this.linksFileTimeStamp < 30000L || !this.linksChanged) {
            return;
        }
        this.fw.removeFile(this.linksFile.getPath());
        TreeSet<String> linkStrs = new TreeSet<String>();
        Iterator iter = this.sidLinksMap.values().iterator();
        while (iter.hasNext()) {
            linkStrs.add(iter.next().toString());
        }
        try {
            ProxyConfig config = ProxyConfig.getInstance();
            Map profiles = config.getProfiles();
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.linksFile, false), false);
            Iterator iter2 = linkStrs.iterator();
            while (iter2.hasNext()) {
                String line = (String)iter2.next();
                line = line.substring(1, line.length() - 1);
                Iterator i = profiles.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    CaProfile profile = (CaProfile)profiles.get(name);
                    if (profile == CaProfile.MULTIPLE) continue;
                    line = line.replaceAll(name, profile.getNetworkIdStr() + "-" + DESUtil.intToHexString(profile.getCaId(), 4));
                }
                pw.println(line);
            }
            pw.flush();
            pw.close();
            this.linksFileTimeStamp = System.currentTimeMillis();
            this.linksChanged = false;
            this.logger.fine("Saved sid links, " + linkStrs.size() + " collections.");
        }
        catch (IOException e) {
            this.logger.throwing(e);
            this.logger.warning("Unable to write sid links file: " + e);
        }
        this.fw.addFile(this.linksFile.getPath());
    }

    protected void registerCtrlCommands() {
        try {
            new CtrlCommand("toggle-linker", "Toggle sid linker", "Activate/deactivate sid linking.").register(this);
            CtrlCommand cmd = new CtrlCommand("add-link", "Add link", "Add a link between two service ids, indicating they use the same dcw sequence.");
            cmd.addParam("sid1", "Service-id 1");
            cmd.addParam("profile1", "Profile 1").setOptions("@profiles", false);
            cmd.addParam("sid2", "Service-id 2");
            cmd.addParam("profile2", "Profile 2").setOptions("@profiles", false);
            cmd.register(this);
            cmd = new CtrlCommand("remove-link", "Del link", "Remove a link between two service ids.");
            cmd.addParam("sid1", "Service-id 1");
            cmd.addParam("profile1", "Profile 1").setOptions("@profiles", false);
            cmd.addParam("sid2", "Service-id 2");
            cmd.addParam("profile2", "Profile 2").setOptions("@profiles", false);
            cmd.register(this);
            cmd = new CtrlCommand("test-link", "Test link", "Test mode, links the selected service with any other currently being watched (set same sid again to disable).");
            cmd.addParam("sid", "Service-id");
            cmd.addParam("profile", "Profile").setOptions("@profiles", false);
            cmd.register(this);
            new CtrlCommand("clear-links", "Clear links", "Remove all sid links.").register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    protected void registerStatusCommands() {
        try {
            StatusCommand sCmd = new StatusCommand("required-services", "List required services", "List services that need to be permanently in cache for the sid linker to work", false);
            sCmd.register(this);
            sCmd = new StatusCommand("linked-services", "List linked services", "List all services that have been configured for sid-cache-linking", false);
            sCmd.register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public CtrlCommandResult runCtrlCmdToggleLinker() {
        boolean active;
        boolean bl = active = this.cache.getListener() == this;
        if (active) {
            this.cache.setListener(null);
        } else {
            this.cache.setListener(this);
        }
        active = !active;
        return new CtrlCommandResult(true, "Sid linker is now " + (active ? "on." : "off."));
    }

    public CtrlCommandResult runCtrlCmdAddLink(Map params) {
        String resultMsg;
        boolean result = false;
        String sid1 = params.get("sid1") + ":" + params.get("profile1");
        String sid2 = params.get("sid2") + ":" + params.get("profile2");
        if (sid1.indexOf("null") != -1 || sid2.indexOf("null") != -1) {
            resultMsg = "Missing/invalid sid1 or sid2 param";
        } else {
            result = this.addSidLink(sid1, sid2);
            resultMsg = "Sid link added: " + sid1 + " <> " + sid2;
        }
        return new CtrlCommandResult(result, resultMsg);
    }

    public CtrlCommandResult runCtrlCmdRemoveLink(Map params) {
        String resultMsg;
        boolean result = false;
        String sid1 = params.get("sid1") + ":" + params.get("profile1");
        String sid2 = params.get("sid2") + ":" + params.get("profile2");
        if (sid1.indexOf("null") != -1 || sid2.indexOf("null") != -1) {
            resultMsg = "Missing/invalid sid1 or sid2 param";
        } else {
            result = true;
            this.removeSidLink(sid1, sid2);
            resultMsg = "Sid link removed: " + sid1 + " <> " + sid2;
        }
        return new CtrlCommandResult(result, resultMsg);
    }

    public CtrlCommandResult runCtrlCmdTestLink(Map params) {
        String resultMsg;
        boolean result = false;
        String profile = (String)params.get("profile");
        String sid = params.get("sid") + ":" + profile;
        SidEntry oldTestService = this.testService;
        if (sid.indexOf("null") != -1) {
            resultMsg = "Missing/invalid sid";
        } else {
            SidEntry se;
            result = true;
            CwsServiceMapper mapper = null;
            if (oldTestService != null) {
                mapper = this.config.getConnManager().getServiceMapper(oldTestService.profileName);
            }
            if ((se = new SidEntry(sid)).equals(this.testService)) {
                this.testService = null;
                resultMsg = "Test mode disabled";
                if (mapper != null) {
                    mapper.unblockService(oldTestService.serviceId);
                }
            } else {
                this.testService = se;
                resultMsg = "Test link set: " + sid + " <> *";
                if (mapper != null) {
                    mapper.unblockService(oldTestService.serviceId);
                }
                if ((mapper = this.config.getConnManager().getServiceMapper(this.testService.profileName)) != null) {
                    mapper.blockService(this.testService.serviceId);
                }
            }
        }
        return new CtrlCommandResult(result, resultMsg);
    }

    public CtrlCommandResult runCtrlCmdClearLinks() {
        this.sidLinksMap.clear();
        this.testService = null;
        return new CtrlCommandResult(true, "Sid links cleared.");
    }

    public void runStatusCmdRequiredServices(XmlStringBuffer xb, Map params, String user) {
        String[] profiles = (String[])params.get("profiles");
        TvService[] services = this.requiredServices.keySet().toArray(new TvService[this.requiredServices.size()]);
        xb.appendElement("required-services", "count", services.length);
        for (int i = 0; i < services.length; ++i) {
            Set opens = (Set)this.requiredServices.get(services[i]);
            if (opens == null || opens.isEmpty()) continue;
            xb.appendElement("link").appendAttr("id", i + 1).endElement(false);
            xb.appendElement("required");
            XmlHelper.xmlFormatServices(new TvService[]{services[i]}, xb, false, true, true, null, profiles);
            xb.closeElement("required");
            xb.appendElement("opens");
            XmlHelper.xmlFormatServices(opens.toArray(new TvService[opens.size()]), xb, false, true, true, null, profiles);
            xb.closeElement("opens");
            xb.closeElement("link");
        }
        xb.closeElement("required-services");
    }

    public void runStatusCmdLinkedServices(XmlStringBuffer xb, Map params, String user) {
        String[] profiles = (String[])params.get("profiles");
        TreeSet<String> linkStrs = new TreeSet<String>();
        int i = 0;
        xb.appendElement("linked-services", "count", this.sidLinksMap.values().size());
        Iterator iter = this.sidLinksMap.values().iterator();
        while (iter.hasNext()) {
            Set set = (Set)iter.next();
            if (linkStrs.contains(set.toString())) continue;
            xb.appendElement("link").appendAttr("id", i++ + 1).endElement(false);
            XmlHelper.xmlFormatServices(this.toTvServiceArray(set), xb, false, true, true, null, profiles);
            xb.closeElement("link");
            linkStrs.add(set.toString());
        }
        xb.closeElement("linked-services");
    }

    private TvService[] toTvServiceArray(Set set) {
        TvService[] ts = new TvService[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            SidEntry se = (SidEntry)iter.next();
            ts[i] = this.config.getService(se.profileName, se.serviceId);
            ServiceMapping sm = new ServiceMapping(se.serviceId, 0L);
            sm.setProviderIdent(0xFFFFFF);
            ts[i].setCustomData(sm.getCustomData());
            ++i;
        }
        return ts;
    }

    public boolean lockRequest(int successFactor, CamdNetMessage req) {
        if (req.getProfileName() == null) {
            req.setProfileName(this.config.getProfileNameById(req.getNetworkId(), req.getCaId()));
        }
        if (req.getProfileName() == null) {
            return false;
        }
        SidEntry se = new SidEntry(req);
        if (this.sidLockMap.containsKey(se)) {
            CamdNetMessage origReq = (CamdNetMessage)this.sidLockMap.get(se);
            if (System.currentTimeMillis() - origReq.getTimeStamp() < 5000L) {
                if (this.replyMap.containsKey(origReq)) {
                    this.logger.fine("Reply already available for: " + req);
                    this.processReply(origReq, req, (CamdNetMessage)this.replyMap.get(origReq), new SidEntry(origReq).toString(), successFactor == -1);
                    return false;
                }
                HashSet<CamdNetMessage> reqs = (HashSet<CamdNetMessage>)this.requestMap.get(origReq);
                if (reqs == null) {
                    reqs = new HashSet<CamdNetMessage>();
                }
                reqs.add(req);
                this.requestMap.put(origReq, reqs);
                this.logger.fine("Link lock detected for: " + req + " - locked by: " + origReq);
                return true;
            }
        }
        if (successFactor == -1 && this.sidLinksMap.containsKey(se)) {
            this.requiredServices.remove(this.config.getService(req));
            Set links = (Set)this.sidLinksMap.get(se);
            Iterator iter = links.iterator();
            while (iter.hasNext()) {
                SidEntry s = (SidEntry)iter.next();
                if (s.equals(se)) continue;
                this.sidRequestMap.put(s, req);
                this.logger.fine("Locking locally undecodable req: " + req + " - for: " + s);
            }
            return true;
        }
        return false;
    }

    public void onRequest(int successFactor, CamdNetMessage req) {
        if (successFactor == -1) {
            return;
        }
        if (req.getProfileName() == null) {
            req.setProfileName(this.config.getProfileNameById(req.getNetworkId(), req.getCaId()));
        }
        if (req.getProfileName() == null) {
            return;
        }
        SidEntry se = new SidEntry(req);
        if (this.sidLockMap.containsKey(se)) {
            return;
        }
        if (this.testService != null) {
            this.sidLockMap.put(this.testService, req);
            this.logger.fine("Test link lock '" + this.testService + "' created by req: " + req);
        } else if (this.sidLinksMap.containsKey(se)) {
            Set links = (Set)this.sidLinksMap.get(se);
            Iterator iter = links.iterator();
            while (iter.hasNext()) {
                SidEntry s = (SidEntry)iter.next();
                if (s.equals(se)) continue;
                this.sidLockMap.put(s, req);
                this.logger.fine("Sid link lock '" + s + "' created by req: " + req);
            }
        }
    }

    public void onReply(CamdNetMessage req, CamdNetMessage reply) {
        this.replyMap.put(req, reply);
        HashSet<CamdNetMessage> reqs = null;
        SidEntry se = null;
        boolean undecodable = false;
        if (this.requestMap.containsKey(req)) {
            reqs = (HashSet<CamdNetMessage>)this.requestMap.get(req);
        } else {
            Set links;
            if (req.getProfileName() == null) {
                req.setProfileName(this.config.getProfileNameById(req.getNetworkId(), req.getCaId()));
            }
            if ((links = (Set)this.sidLinksMap.get(se = new SidEntry(req))) != null) {
                reqs = new HashSet<CamdNetMessage>();
                Iterator iter = links.iterator();
                while (iter.hasNext()) {
                    SidEntry s = (SidEntry)iter.next();
                    if (!this.sidRequestMap.containsKey(s)) continue;
                    CamdNetMessage heldReq = (CamdNetMessage)this.sidRequestMap.remove(s);
                    if (System.currentTimeMillis() - heldReq.getTimeStamp() >= 5000L) continue;
                    reqs.add(heldReq);
                }
                if (reqs.isEmpty()) {
                    reqs = null;
                } else {
                    undecodable = true;
                }
            }
        }
        if (reqs != null) {
            if (se == null) {
                se = new SidEntry(req);
            }
            Iterator iter = reqs.iterator();
            while (iter.hasNext()) {
                CamdNetMessage linkedReq = (CamdNetMessage)iter.next();
                this.logger.fine("Copying reply to linked request: " + reply + " -> " + linkedReq);
                this.processReply(req, linkedReq, reply, se.toString(), undecodable);
            }
        }
    }

    private void processReply(CamdNetMessage origReq, CamdNetMessage linkedReq, CamdNetMessage reply, String linkStr, boolean undecodable) {
        if (undecodable && this.testService == null) {
            this.reportAddedService(linkedReq, origReq);
        }
        linkedReq.setLinkedService(linkStr);
        reply.setConnectorName("SidCacheLinker");
        this.cache.processReply(linkedReq, reply);
    }

    public void addMultipleLinks(String[] links) {
        for (int i = 0; i < links.length; ++i) {
            if (i + 1 >= links.length) continue;
            this.addSidLink(links[i], links[i + 1]);
        }
    }

    public boolean addSidLink(String sid1, String sid2) {
        SidEntry se1 = new SidEntry(sid1);
        SidEntry se2 = new SidEntry(sid2);
        HashSet<SidEntry> links = (HashSet<SidEntry>)this.sidLinksMap.get(se1);
        if (links == null) {
            links = (Set)this.sidLinksMap.get(se2);
        }
        if (links == null) {
            links = new HashSet<SidEntry>();
        }
        links.add(se1);
        links.add(se2);
        boolean added = this.sidLinksMap.put(se1, links) == null;
        boolean bl = added = this.sidLinksMap.put(se2, links) == null || added;
        if (added) {
            this.linksChanged = true;
            return true;
        }
        return false;
    }

    public void removeSidLink(String sid1, String sid2) {
        boolean removed;
        SidEntry se1 = new SidEntry(sid1);
        SidEntry se2 = new SidEntry(sid2);
        Set links = (Set)this.sidLinksMap.get(se1);
        links.remove(se2);
        boolean bl = removed = this.sidLinksMap.remove(se2) != null;
        if (links.size() <= 1) {
            links.remove(se1);
            boolean bl2 = removed = removed || this.sidLinksMap.remove(se1) != null;
        }
        if (removed) {
            this.linksChanged = true;
            this.refreshAddedSet();
        }
    }

    private void reportAddedService(CamdNetMessage req, CamdNetMessage origReq) {
        TvService ts2;
        String profileName = req.getProfileName();
        TvService ts1 = this.config.getService(profileName, origReq.getServiceId());
        Set<ServiceMapping> services = (TreeSet<TvService>)this.requiredServices.get(ts1);
        if (services == null) {
            services = new TreeSet<TvService>();
        }
        if (ts1.equals(ts2 = this.config.getService(profileName, req.getServiceId()))) {
            return;
        }
        services.add((ServiceMapping)((Object)ts2));
        ServiceMapping sm = new ServiceMapping(req);
        ts2.setCustomData(sm.getCustomData());
        ts1.setCustomData(new ServiceMapping(origReq).getCustomData());
        this.requiredServices.put(ts1, services);
        services = (Set)this.addedServices.get(profileName);
        if (services == null) {
            services = new TreeSet();
        }
        if (services.add(sm)) {
            this.logger.info("Linked previously undecodable service: " + ts2 + " (unlocked by: " + ts1 + ")");
            this.config.getConnManager().cwsFoundService(null, ts2, true);
        }
        this.addedServices.put(profileName, services);
    }

    private void refreshAddedSet() {
        SidEntry se;
        TvService ts;
        HashSet retained = new HashSet();
        Iterator<Object> iter = this.requiredServices.keySet().iterator();
        while (iter.hasNext()) {
            ts = (TvService)iter.next();
            se = new SidEntry(ts.getId(), ts.getProfileName());
            if (!this.sidLinksMap.containsKey(se)) {
                iter.remove();
                continue;
            }
            retained.addAll((Set)this.requiredServices.get(ts));
        }
        iter = retained.iterator();
        while (iter.hasNext()) {
            ts = (TvService)iter.next();
            se = new SidEntry(ts.getId(), ts.getProfileName());
            if (this.sidLinksMap.containsKey(se)) continue;
            iter.remove();
        }
        Iterator iter2 = this.addedServices.keySet().iterator();
        while (iter2.hasNext()) {
            String profileName = (String)iter2.next();
            Set added = (Set)this.addedServices.get(profileName);
            Iterator i = added.iterator();
            while (i.hasNext()) {
                ServiceMapping sm = (ServiceMapping)i.next();
                ts = this.config.getService(profileName, sm);
                if (retained.contains(ts)) continue;
                i.remove();
                this.logger.info("Linked service no longer available: " + ts);
                this.config.getConnManager().cwsLostService(null, ts, true);
            }
            if (!added.isEmpty()) continue;
            iter2.remove();
        }
    }

    public Set getServicesForProfile(String profileName) {
        if (this.cache.getListener() != this) {
            return Collections.EMPTY_SET;
        }
        if (!this.addedServices.containsKey(profileName)) {
            return Collections.EMPTY_SET;
        }
        return (Set)this.addedServices.get(profileName);
    }

    static class SidEntry {
        int serviceId;
        String profileName;

        SidEntry(CamdNetMessage msg) {
            this.serviceId = msg.getServiceId();
            this.profileName = msg.getProfileName();
        }

        SidEntry(String s) {
            String[] tokens = s.split(":");
            this.serviceId = Integer.parseInt(tokens[0], 16);
            this.profileName = tokens[1];
        }

        SidEntry(int serviceId, String profileName) {
            this.serviceId = serviceId;
            this.profileName = profileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SidEntry sidEntry = (SidEntry)o;
            if (this.serviceId != sidEntry.serviceId) {
                return false;
            }
            return !(this.profileName != null ? !this.profileName.equals(sidEntry.profileName) : sidEntry.profileName != null);
        }

        public int hashCode() {
            int result = this.serviceId;
            result = 31 * result + (this.profileName != null ? this.profileName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Integer.toHexString(this.serviceId) + ":" + this.profileName;
        }
    }
}

