/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ClusteredCache;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.CspConnection;
import com.bowman.cardserv.CspNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.AbstractCwsConnector;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.MultiCwsConnector;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.util.Base64Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CspCwsConnector
extends AbstractCwsConnector
implements MultiCwsConnector {
    private String user;
    private String password;
    private String urlStr;
    private boolean ssl;
    private boolean wantCache;
    private int remoteProxyId;
    private Set unmappedIds = new HashSet();
    private Set excludeProfiles = new HashSet();
    private ProxyXmlConfig backupConfig;
    private CardData fakeCard;
    private Thread keepAliveThread = null;
    private int keepAliveInterval;
    private int keepAliveCount;
    private CspConnection conn;
    private Map receivedState = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String backupUrl;
        super.configUpdated(xml);
        String urlStr = xml.getStringValue("url");
        String user = xml.getStringValue("user");
        String password = xml.getStringValue("password");
        boolean enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        boolean wantCache = "true".equalsIgnoreCase(xml.getStringValue("request-cache-updates", "false"));
        this.excludeProfiles.clear();
        String excludeProfiles = xml.getStringValue("exclude-profiles", "");
        if (excludeProfiles.length() > 0) {
            this.excludeProfiles.addAll(Arrays.asList(excludeProfiles.split(" ")));
        }
        this.keepAliveInterval = xml.getIntValue("keepalive-interval", this.config.getDefaultConnectorKeepAlive());
        this.asynchronous = true;
        this.minDelay = 0;
        boolean changed = !urlStr.equals(this.urlStr) || !user.equals(this.user) || !password.equals(this.password) || wantCache != this.wantCache || enabled != this.enabled;
        this.user = user;
        this.password = password;
        this.enabled = enabled;
        this.wantCache = wantCache;
        if (!enabled) {
            this.close();
        } else {
            try {
                URL url = new URL(urlStr);
                if ("http".equalsIgnoreCase(url.getProtocol())) {
                    this.ssl = false;
                } else if ("https".equalsIgnoreCase(url.getProtocol())) {
                    this.ssl = true;
                } else {
                    throw new ConfigException(xml.getFullName(), "url", "Protocol must be http or https: " + url.getProtocol());
                }
                this.urlStr = urlStr;
                this.host = url.getHost();
                this.port = url.getPort();
                if (this.port == -1) {
                    this.port = this.ssl ? 443 : 80;
                }
            }
            catch (MalformedURLException e) {
                throw new ConfigException(xml.getFullName(), "url", "Malformed URL: " + urlStr);
            }
        }
        if (changed) {
            this.clearRemoteState(false);
        }
        if (changed && enabled) {
            this.close();
            if (this.connManager != null) {
                CwsConnectorManager e = this.connManager;
                synchronized (e) {
                    this.connManager.notifyAll();
                }
            }
        }
        this.profile = CaProfile.MULTIPLE;
        this.fakeCard = CardData.createEmptyData(0);
        if (!this.receivedState.isEmpty()) {
            this.refreshServiceMapper(true);
        }
        if ((backupUrl = xml.getStringValue("url-backup", "")).length() > 0) {
            xml.setStringOverride("url", backupUrl);
            xml.setStringOverride("url-backup", "");
            xml.setStringOverride("name", this.name + "-backup");
            this.backupConfig = xml;
        } else {
            this.backupConfig = null;
        }
        this.logger.fine("Configuration updated. Enabled: " + enabled + " Changed: " + changed);
    }

    private void reportRemoteState(CspNetMessage.ProfileKey key, List updates, boolean overWrite) {
        CaProfile profile = this.config.getProfileById(key.onid, key.caid);
        if (CspNetMessage.isDeletion(updates)) {
            this.logger.fine("Received delete for id " + key);
            this.receivedState.remove(key);
            if (profile != null) {
                this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], true, false);
                this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], false, false);
            }
            return;
        }
        if (profile != null && this.excludeProfiles.contains(profile.getName())) {
            profile = null;
        }
        if (profile == null) {
            this.unmappedIds.add(key);
        }
        ServiceMapping[] added = CspCwsConnector.extractServiceMap(updates, true);
        ServiceMapping[] removed = CspCwsConnector.extractServiceMap(updates, false);
        if (overWrite) {
            this.receivedState.put(key, updates);
            if (profile != null) {
                if (added.length == 0) {
                    this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], true, false);
                }
                if (removed.length == 0) {
                    this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], false, false);
                }
            }
        } else {
            this.logger.fine("Incremental state updates not yet fully implemented.");
        }
        if (added.length > 0) {
            this.logger.fine("Received " + (overWrite ? "full" : "incremental") + " can-decode status update for id [" + key + "]: " + Arrays.asList(added));
            if (profile != null) {
                this.connManager.reportMultiStatus(this, profile, added, true, !overWrite);
            }
        }
        if (removed.length > 0) {
            this.logger.fine("Received " + (overWrite ? "full" : "incremental") + " cannot-decode status update for id [" + key + "]: " + Arrays.asList(removed));
            if (profile != null) {
                this.connManager.reportMultiStatus(this, profile, removed, false, !overWrite);
            }
        }
    }

    private void handleStatusUpdate(CspNetMessage msg, boolean full) throws IOException {
        if (!msg.isEmpty()) {
            Set keys = msg.getProfileKeys();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                CspNetMessage.ProfileKey key = (CspNetMessage.ProfileKey)iter.next();
                List updates = msg.getStatusUpdatesForKey(key);
                if (updates == null) continue;
                this.reportRemoteState(key, updates, full);
            }
            this.saveRemoteState();
        }
        this.conn.sendCspMessage(new CspNetMessage(4), msg.getSeqNr());
    }

    private String getCacheName() {
        return this.getName() + "_" + this.user + "@" + this.host + ".state";
    }

    private void saveRemoteState() {
        try {
            File mapFile = new File("cache", this.getCacheName());
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(mapFile)));
            oos.writeObject(this.receivedState);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            this.logger.severe("Failed to save remote state cache: " + e);
            this.logger.throwing(e);
        }
    }

    private void loadRemoteState() {
        try {
            File mapFile = new File("cache", this.getCacheName());
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(mapFile)));
            this.receivedState = (Map)ois.readObject();
            ois.close();
            this.refreshServiceMapper(true);
        }
        catch (ClassCastException e) {
            this.clearRemoteState(true);
            this.logger.fine("Incompatible remote state cache, deleting...");
        }
        catch (FileNotFoundException e) {
            this.logger.fine("No remote state cache found");
        }
        catch (Exception e) {
            this.logger.severe("Failed to load remote state cache: " + e, e);
        }
    }

    public void clearRemoteState(boolean all) {
        this.receivedState.clear();
        if (all) {
            File cacheDir = new File("cache");
            String[] caches = cacheDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(CspCwsConnector.this.getName() + "_");
                }
            });
            for (int i = 0; i < caches.length; ++i) {
                if (new File("cache", caches[i]).delete()) continue;
                this.logger.warning("Failed to delete: " + caches[i]);
            }
        }
        this.refreshServiceMapper(true);
    }

    private static ServiceMapping[] extractServiceMap(List state, boolean canDecode) {
        List sids = CspNetMessage.getStatusItems(1, canDecode, state);
        List customs = CspNetMessage.getStatusItems(3, canDecode, state);
        ServiceMapping[] sm = new ServiceMapping[sids.size()];
        Iterator ia = sids.iterator();
        Iterator ic = sids.size() == customs.size() ? customs.iterator() : null;
        for (int i = 0; i < sm.length; ++i) {
            sm[i] = new ServiceMapping((Integer)ia.next(), ic == null ? 0L : (Long)ic.next());
            if (ic != null) continue;
            sm[i].setProviderIdent(0xFFFFFF);
        }
        return sm;
    }

    private void refreshServiceMapper(boolean overWrite) {
        CaProfile profile;
        this.unmappedIds.clear();
        Set profiles = this.config.getRealProfiles();
        Iterator<Object> iter = this.receivedState.keySet().iterator();
        while (iter.hasNext()) {
            CspNetMessage.ProfileKey key = (CspNetMessage.ProfileKey)iter.next();
            profile = this.config.getProfileById(key.onid, key.caid);
            if (profile != null) {
                profiles.remove(profile);
            }
            if (profile != null && this.excludeProfiles.contains(profile.getName())) {
                profiles.add(profile);
                profile = null;
            }
            List state = (List)this.receivedState.get(key);
            if (profile != null) {
                this.connManager.reportMultiStatus(this, profile, CspCwsConnector.extractServiceMap(state, true), true, !overWrite);
                this.connManager.reportMultiStatus(this, profile, CspCwsConnector.extractServiceMap(state, false), false, !overWrite);
                continue;
            }
            this.unmappedIds.add(key);
        }
        if (this.connManager != null) {
            iter = profiles.iterator();
            while (iter.hasNext()) {
                profile = (CaProfile)iter.next();
                this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], true, false);
                this.connManager.reportMultiStatus(this, profile, new ServiceMapping[0], false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.alive = true;
        try {
            this.conn.init();
            CspNetMessage msg = this.conn.readMessage();
            if (msg.getType() != 3) {
                this.logger.warning("Unexpected message on connect, aborting: " + DESUtil.byteToString((byte)msg.getType()));
                this.connManager.cwsConnectionFailed(this, "Connect failed");
                this.close();
                this.connecting = true;
            } else {
                this.remoteProxyId = msg.getOriginId();
                this.handleStatusUpdate(msg, true);
                if (this.remoteProxyId == this.config.getProxyOriginId()) {
                    this.logger.warning("Remote proxy has same id as local (" + DESUtil.intToHexString(this.remoteProxyId, 4) + "), aborting...");
                    this.close();
                    this.connecting = true;
                }
            }
            this.logger.info("Remote state: " + this.receivedState);
            if (this.conn == null) {
                throw new SocketException("Connection aborted during service map sync");
            }
            this.connectTimeStamp = System.currentTimeMillis();
            this.connManager.cwsConnected(this);
            if (this.conn != null && this.conn.isConnected()) {
                this.conn.setSoTimeout(0);
                this.connecting = false;
                block13: while (this.alive && this.conn != null) {
                    msg = this.conn.readMessage();
                    this.lastSent = null;
                    if (msg == null) {
                        this.alive = false;
                        this.logger.warning("Connection closed");
                        continue;
                    }
                    switch (msg.getType()) {
                        case 2: {
                            if (this.reportReply(msg.getCamdMessage())) continue block13;
                            this.logger.fine("No listener found for ECM reply: " + msg);
                            continue block13;
                        }
                        case 3: {
                            this.handleStatusUpdate(msg, true);
                            continue block13;
                        }
                        case 5: {
                            this.handleStatusUpdate(msg, false);
                            continue block13;
                        }
                        case 4: {
                            this.logger.fine("Keep-alive reply received: [" + msg.getSeqNr() + "]");
                            this.reportReply(new CamdNetMessage(253));
                            continue block13;
                        }
                    }
                    this.logger.warning("Unexpected message type from server: " + DESUtil.byteToString((byte)msg.getType()));
                }
            }
        }
        catch (SocketException e) {
            this.logger.warning("Connection closed: " + e.getMessage());
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                if (e.getMessage().indexOf(" 401 ") != -1) {
                    this.logger.warning("Login failed, received: " + e.getMessage());
                    this.connManager.cwsConnectionFailed(this, "Login failed (bad username/password)");
                } else {
                    this.logger.warning("Unexpected Csp reply: " + e);
                }
            }
            this.logger.throwing("Exception reading/parsing message: " + e, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn = null;
        this.reset();
        if (!this.connecting) {
            this.lastDisconnectTimeStamp = System.currentTimeMillis();
            this.connManager.cwsDisconnected(this);
            CwsConnectorManager cwsConnectorManager = this.connManager;
            synchronized (cwsConnectorManager) {
                this.connManager.notifyAll();
            }
        }
        this.readerThread = null;
        this.connecting = false;
        this.logger.info("Connector dying");
    }

    protected void connectNative() throws IOException {
        Socket s;
        this.unmappedIds.clear();
        this.loadRemoteState();
        Socket socket = s = this.ssl ? FileFetcher.socketFactory.createSocket() : new Socket();
        if (this.qosClass != -1) {
            s.setTrafficClass(this.qosClass);
        }
        s.connect(new InetSocketAddress(this.host, this.port), 10000);
        s.setSoTimeout(30000);
        this.logger.info("Connected, authorizing...");
        String auth = this.user + ":" + this.password;
        auth = new String(Base64Encoder.encode((byte[])auth.getBytes("ISO-8859-1")));
        String CRLF = "\r\n";
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), "ISO-8859-1"));
        pw.print("CONNECT /cspHandler" + CRLF);
        pw.print("Authorization: Basic " + auth + CRLF);
        pw.print("User-Agent: Csp 0.9.0" + CRLF);
        pw.print("Proxy-Origin-Id: " + this.config.getProxyOriginId() + CRLF);
        pw.print("Send-Extra: true" + CRLF);
        if (this.wantCache) {
            if (this.config.getCacheHandler() instanceof ClusteredCache) {
                pw.print("Cache-port: " + ((ClusteredCache)this.config.getCacheHandler()).getLocalPort() + CRLF);
            } else {
                this.logger.warning("Configured to request cache updates, but ClusteredCache isn't in use, ignoring...");
            }
        }
        Iterator iter = this.receivedState.keySet().iterator();
        while (iter.hasNext()) {
            CspNetMessage.ProfileKey key = (CspNetMessage.ProfileKey)iter.next();
            pw.print("state-hash-" + key + ": " + CspNetMessage.statusHashCode((List)this.receivedState.get(key)) + CRLF);
        }
        pw.print(CRLF);
        pw.flush();
        this.conn = new CspConnection(s);
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public long getLastTrafficTimeStamp() {
        if (this.conn == null) {
            return -1L;
        }
        return this.conn.getLastTrafficTimeStamp();
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public boolean isReady() {
        return this.isConnected();
    }

    public CardData getRemoteCard() {
        return this.fakeCard;
    }

    public int getRemoteProxyId() {
        return this.remoteProxyId;
    }

    public synchronized int sendMessage(CamdNetMessage camdMsg) {
        if (this.conn == null || !this.conn.isConnected()) {
            return -1;
        }
        CspNetMessage msg = null;
        if (camdMsg.isEcm()) {
            msg = new CspNetMessage(1);
            msg.setCamdMessage(camdMsg);
        } else if (camdMsg.isKeepAlive()) {
            ++this.keepAliveCount;
            msg = new CspNetMessage(5);
        }
        if (msg == null) {
            return -1;
        }
        try {
            return this.conn.sendCspMessage(msg);
        }
        catch (IOException e) {
            this.logger.warning("Connection closed");
            this.logger.throwing(e);
            return -1;
        }
    }

    public void sendKeepAlive() {
        long now;
        if (this.isConnected() && this.timeoutCount > 0 && (now = System.currentTimeMillis()) - this.lastEcmTimeStamp > 3000L) {
            this.lastEcmTimeStamp = now;
            if (this.keepAliveThread == null) {
                this.keepAliveThread = new Thread("CwsKeepAliveThread"){

                    public void run() {
                        CspCwsConnector.this.logger.info("Connector unresponsive, forcing keep-alive...");
                        int result = CspCwsConnector.this.sendMessage(new CamdNetMessage(253));
                        CspCwsConnector.this.logger.fine("Result from keep-alive: " + result);
                        if (result == -1) {
                            CspCwsConnector.this.close();
                        } else {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                CspCwsConnector.this.logger.throwing(e);
                            }
                            if (CspCwsConnector.this.timeoutCount > 0) {
                                ++CspCwsConnector.this.timeoutCount;
                            }
                        }
                        CspCwsConnector.this.keepAliveThread = null;
                    }
                };
                if (this.keepAliveThread != null) {
                    this.keepAliveThread.start();
                }
            }
        }
    }

    public String getProtocol() {
        return "Csp";
    }

    public String getProfileName() {
        return CaProfile.MULTIPLE.getName();
    }

    public Properties getRemoteInfo() {
        Properties p = new Properties();
        Iterator iter = this.receivedState.keySet().iterator();
        while (iter.hasNext()) {
            CspNetMessage.ProfileKey key = (CspNetMessage.ProfileKey)iter.next();
            CaProfile profile = this.config.getProfileById(key.onid, key.caid);
            if (profile == null || this.excludeProfiles.contains(profile.getName())) continue;
            List state = (List)this.receivedState.get(key);
            p.setProperty(key + "-sids", String.valueOf(CspNetMessage.getStatusItems(1, true, state).size()));
            p.setProperty(key + "-sids-cd", String.valueOf(CspNetMessage.getStatusItems(1, false, state).size()));
            p.setProperty(key + "-providers", ProxyConfig.providerIdentsToString(new HashSet(CspNetMessage.getStatusItems(2, true, state))));
            p.setProperty(key + "-extra", CspNetMessage.getStatusItems(4, true, state).toString());
        }
        p.setProperty("unmapped-networks", this.unmappedIds.toString());
        p.setProperty("ssl", String.valueOf(this.ssl));
        p.setProperty("request-cache-updates", String.valueOf(this.wantCache && this.config.getCacheHandler() instanceof ClusteredCache));
        p.setProperty("remote-origin-id", DESUtil.intToHexString(this.remoteProxyId, 4));
        if (this.urlStr != null) {
            p.setProperty("url", this.urlStr);
        }
        return p;
    }

    public boolean canDecode(CamdNetMessage request) {
        CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(request.getNetworkId(), request.getCaId());
        List state = (List)this.receivedState.get(key);
        if (state == null) {
            return false;
        }
        CaProfile profile = this.config.getProfileById(request.getNetworkId(), request.getCaId());
        if (profile == null || this.excludeProfiles.contains(profile.getName())) {
            return false;
        }
        if (request.getOriginId() == this.remoteProxyId) {
            this.logger.finer("Blocked attempt to forward " + request.hashCodeStr() + " back to origin: " + DESUtil.intToHexString(this.remoteProxyId, 4));
            return false;
        }
        if (request.getProviderIdent() != -1 && profile.isRequireProviderMatch()) {
            return CspNetMessage.getStatusItems(2, true, state).contains(new Integer(request.getProviderIdent()));
        }
        return true;
    }

    public String getRemoteAddress() {
        if (this.conn == null) {
            return "0.0.0.0";
        }
        return this.conn.getRemoteAddress();
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
        if (this.keepAliveThread != null) {
            this.keepAliveThread.interrupt();
            this.keepAliveThread = null;
        }
        super.close();
    }

    public boolean hasMatchingProfile(int networkId, int caId) {
        if (networkId == 0 || caId == 0) {
            return false;
        }
        if (this.unmappedIds.contains(new CspNetMessage.ProfileKey(networkId, caId))) {
            return false;
        }
        return this.receivedState.containsKey(new CspNetMessage.ProfileKey(networkId, caId));
    }

    public ProxyXmlConfig getBackupConfig() {
        return this.backupConfig;
    }
}

