/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.ChameleonCwsConnector;
import com.bowman.cardserv.cws.ConnectorSelection;
import com.bowman.cardserv.cws.CspCwsConnector;
import com.bowman.cardserv.cws.CwsServiceMapper;
import com.bowman.cardserv.cws.NewcamdCwsConnector;
import com.bowman.cardserv.cws.RadegastCwsConnector;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsListener;
import com.bowman.cardserv.interfaces.MultiCwsConnector;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.session.NewcamdSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.util.CronTimer;
import com.bowman.util.CronTimerListener;
import com.bowman.xml.XMLConfig;
import com.bowman.xml.XMLConfigException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CwsConnectorManager
implements XmlConfigurable,
Runnable,
CronTimerListener,
CwsListener {
    private static final long DEFAULT_RECONNECT_INTERVAL = 60000L;
    private Map connectors = new HashMap();
    private Map externalConnectors = new HashMap();
    private Map multiConnectors = new HashMap();
    private Map serviceMappers = new HashMap();
    private Map auUsers = new HashMap();
    private ProxyLogger logger;
    private ProxyConfig config;
    private List listeners = new ArrayList();
    private CronTimer excludeCron;
    private CronTimer rediscoverCron;
    private Thread keepAliveThread;
    private Thread connectorThread;
    private long reconnectInterval;
    private long maxCwWait;
    private long cannotDecodeWait;
    private long congestionLimit;
    private long timeoutThreshold;
    private long delayNoSid;
    private boolean ready;
    private boolean hardLimit;
    private boolean logSidMismatch;
    private URL connectorFileUri;
    private String connectorFile;
    private String connectorFileKey;
    private int connectorFileInterval;
    private long connectorFileLastModified;
    private long connectorFileLastCheck;
    private CtrlCommand updateCommand;

    public CwsConnectorManager() {
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        this.config = ProxyConfig.getInstance();
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.reconnectInterval = xml.getTimeValue("reconnect-interval", 60, "s");
        this.maxCwWait = xml.getTimeValue("max-cw-wait", 9, "s");
        if (this.maxCwWait <= 100L) {
            throw new ConfigException(xml.getFullName(), "max-cw-wait must be > 100 ms");
        }
        this.timeoutThreshold = xml.getIntValue("timeout-disconnect-threshold", 2);
        if (this.timeoutThreshold < 1L) {
            throw new ConfigException(xml.getFullName(), "timeout-disconnect-threshold must be >= 1");
        }
        if (this.timeoutThreshold != 2L) {
            this.logger.warning("timeout-disconnect-threshold has been changed: " + this.timeoutThreshold + " (default 2)");
        }
        this.cannotDecodeWait = xml.getTimeValue("cannot-decode-wait", 0, "s");
        if (this.cannotDecodeWait >= this.maxCwWait) {
            throw new ConfigException(xml.getFullName(), "cannot-decode-wait must be smaller than max-cw-wait");
        }
        if (this.cannotDecodeWait > 0L) {
            this.logger.warning("cannot-decode-wait period is enabled: " + this.cannotDecodeWait + " ms");
        }
        this.congestionLimit = xml.getTimeValue("congestion-limit", (int)this.maxCwWait / 1000, "s");
        if (this.maxCwWait < 1000L && this.congestionLimit == 0L) {
            this.congestionLimit = this.maxCwWait;
        }
        if (this.congestionLimit > this.maxCwWait || this.congestionLimit < this.maxCwWait / 2L) {
            throw new ConfigException(xml.getFullName(), "congestion-limit must be between max-cw-wait/2 and max-cw-wait");
        }
        this.hardLimit = "true".equalsIgnoreCase(xml.getStringValue("hard-congestion-limit", "true"));
        this.logSidMismatch = "true".equalsIgnoreCase(xml.getStringValue("log-sid-mismatch", "true"));
        this.delayNoSid = xml.getTimeValue("delay-missing-sid", 100, "ms");
        if (this.delayNoSid >= this.congestionLimit) {
            throw new ConfigException(xml.getFullName(), "delay-missing-sid must be < congestion-limit (max-cw-wait)");
        }
        if (this.reconnectInterval < 3000L) {
            this.reconnectInterval = 60000L;
            this.logger.warning("reconnect-interval must be at least 3 seconds, using default (60 s)");
        }
        this.updateServiceMappers(xml.getSubConfig("service-map"));
        ProxyXmlConfig connCfg = null;
        try {
            connCfg = xml.getSubConfig("cws-connectors");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.updateConnectors(connCfg, this.connectors);
        ProxyXmlConfig extCfg = null;
        try {
            extCfg = xml.getSubConfig("external-connector-config");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (extCfg == null && connCfg == null) {
            xml.getSubConfig("cws-connectors");
        }
        if (extCfg != null) {
            this.updateExternalConfig(extCfg);
        } else {
            this.connectorFileUri = null;
            this.connectorFileInterval = 0;
            if (this.updateCommand != null) {
                this.updateCommand.unregister();
            }
            this.updateAuUsers();
        }
        if (this.excludeCron == null) {
            this.excludeCron = new CronTimer("0 * * * *");
            this.excludeCron.addTimerListener((CronTimerListener)this);
            this.excludeCron.start();
        }
        if (this.rediscoverCron == null) {
            this.rediscoverCron = new CronTimer("* * * * *");
            this.rediscoverCron.addTimerListener((CronTimerListener)this);
            this.rediscoverCron.start();
        }
        this.logger.fine("Configuration updated");
    }

    public boolean setTempAuUser(String name, String user) {
        if (!this.config.getUserManager().exists(user)) {
            return false;
        }
        CwsConnector cws = this.getCwsConnectorByName(name);
        if (cws != null) {
            CardData card = cws.getRemoteCard();
            if (card == null && card.isAnonymous()) {
                return false;
            }
            String cardStr = card.toString();
            CaProfile profile = cws.getProfile();
            if (profile != CaProfile.MULTIPLE && profile != null && cws.isEnabled()) {
                String key = user + ":" + profile.getName();
                if (cws.getName().equals(this.auUsers.get(key))) {
                    this.auUsers.remove(key);
                    cardStr = "";
                } else {
                    this.auUsers.put(key, cws.getName());
                }
                SessionManager sm = SessionManager.getInstance();
                List sessions = sm.getSessionsForUser(user);
                if (sessions != null && !sessions.isEmpty()) {
                    Iterator iter = sessions.iterator();
                    while (iter.hasNext()) {
                        ProxySession session = (ProxySession)iter.next();
                        if (!profile.getName().equals(session.getProfileName()) && session.getProfile() != CaProfile.MULTIPLE || !(session instanceof NewcamdSession) || session.getLastContext().equals(cardStr)) continue;
                        this.logger.info("AU changed for '" + key + "', kicking existing session to force reconnect and card-data update: " + session);
                        session.close();
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void updateAuUsers() throws ConfigException {
        CwsConnector cws;
        this.auUsers.clear();
        Iterator iter = this.getConnectors().values().iterator();
        while (iter.hasNext()) {
            String[] names;
            cws = (CwsConnector)iter.next();
            if (cws.getProfile() == CaProfile.MULTIPLE || cws.getProfile() == null || !cws.isEnabled() || (names = cws.getAuUsers()) == null) continue;
            for (int i = 0; i < names.length; ++i) {
                String name = this.auUsers.put(names[i] + ":" + cws.getProfileName(), cws.getName());
                if (name == null) continue;
                throw new ConfigException("AU-user '" + names[i] + "' assigned for multiple connectors in " + "the same profile: " + cws.getName() + ", " + name);
            }
        }
        if (!this.auUsers.isEmpty()) {
            SessionManager sm = SessionManager.getInstance();
            Iterator iter2 = this.auUsers.keySet().iterator();
            while (iter2.hasNext()) {
                String key = (String)iter2.next();
                String[] userProfile = key.split(":");
                List sessions = sm.getSessionsForUser(userProfile[0]);
                if (sessions == null || sessions.isEmpty()) continue;
                Iterator i = sessions.iterator();
                while (i.hasNext()) {
                    ProxySession session = (ProxySession)i.next();
                    if (!userProfile[1].equals(session.getProfileName()) || (cws = this.getCwsConnectorByName((String)this.auUsers.get(key))) == null) continue;
                    String card = "" + cws.getRemoteCard();
                    if (!(session instanceof NewcamdSession) || session.getLastContext().equals(card)) continue;
                    this.logger.info("AU changed for '" + key + "', kicking existing session to force reconnect and card-data update: " + session);
                    session.close();
                }
            }
        }
    }

    private void updateServiceMappers(ProxyXmlConfig xml) throws ConfigException {
        ProxyXmlConfig conf;
        Iterator iter = xml.getMultipleSubConfigs("mapper");
        HashMap<String, ProxyXmlConfig> mapperConfs = new HashMap<String, ProxyXmlConfig>();
        ProxyXmlConfig defaults = null;
        while (iter.hasNext()) {
            conf = (ProxyXmlConfig)iter.next();
            try {
                String profileName = conf.getStringValue("profile");
                mapperConfs.put(profileName, conf);
            }
            catch (ConfigException e) {
                if (defaults != null) {
                    throw e;
                }
                defaults = conf;
            }
        }
        if (defaults == null) {
            throw new ConfigException(xml.getFullName(), "No default mapper element found (omit profile attribute).");
        }
        iter = this.config.getProfiles().values().iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            CwsServiceMapper mapper = this.getServiceMapper(profile.getName());
            if (mapper == null) {
                mapper = new CwsServiceMapper(profile, this);
            }
            conf = (ProxyXmlConfig)mapperConfs.remove(profile.getName());
            defaults.setOverrides(conf);
            mapper.configUpdated(defaults);
            this.serviceMappers.put(profile.getName(), mapper);
        }
        if (!mapperConfs.isEmpty()) {
            this.logger.warning("Mapper configs for unknown profile(s) ignored: " + mapperConfs.keySet());
        }
    }

    private void updateConnectors(ProxyXmlConfig xml, Map connectors) throws ConfigException {
        Iterator iter = xml == null ? Collections.EMPTY_LIST.iterator() : xml.getMultipleSubConfigs(null);
        HashSet names = new HashSet();
        while (iter.hasNext()) {
            ProxyXmlConfig conf = (ProxyXmlConfig)iter.next();
            this.addConnector(conf, names, connectors);
        }
        iter = new ArrayList(connectors.keySet()).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (names.contains(name)) continue;
            CwsConnector conn = (CwsConnector)connectors.get(name);
            this.removeConnector(conn);
            connectors.remove(name);
        }
    }

    private void addConnector(ProxyXmlConfig conf, Set names, Map connectors) throws ConfigException {
        ProxyXmlConfig backupConf;
        CwsConnector conn;
        String name = conf.getStringValue("name");
        if (names.contains(name)) {
            throw new ConfigException(conf.getFullName(), "Duplicate connector definition: " + name);
        }
        names.add(name);
        if (connectors.containsKey(name)) {
            conn = (CwsConnector)connectors.get(name);
        } else {
            if (conf.getName().startsWith("newcamd")) {
                conn = new NewcamdCwsConnector();
            } else if (conf.getName().startsWith("radegast")) {
                conn = new RadegastCwsConnector();
            } else if (conf.getName().startsWith("chameleon")) {
                conn = new ChameleonCwsConnector();
            } else if (conf.getName().startsWith("csp")) {
                conn = new CspCwsConnector();
            } else {
                String className = conf.getStringValue("class", "");
                if (!"".equals(className)) {
                    conn = (CwsConnector)ProxyConfig.loadInstance(conf, null, CwsConnector.class);
                } else {
                    throw new ConfigException(conf.getFullName(), "Unknown connector type (and no class/jar-file specified): " + conf.getFullName());
                }
            }
            connectors.put(name, conn);
            this.logger.fine("Added connector: " + name);
        }
        conn.configUpdated(conf);
        if ("true".equalsIgnoreCase(conf.getStringValue("enabled", "true"))) {
            this.updateDecodeMaps(conf, name, conn.getProfileName());
        }
        if (conn.getProfile() != null) {
            this.getServiceMapper(conn.getProfileName()).addConnector(conn);
        }
        if (conn instanceof CspCwsConnector && (backupConf = ((CspCwsConnector)conn).getBackupConfig()) != null) {
            this.addConnector(backupConf, names, connectors);
        }
    }

    void updateDecodeMaps(ProxyXmlConfig xml, String name, String profileName) throws ConfigException {
        String profile;
        ProxyXmlConfig cds;
        CwsServiceMapper mapper;
        CwsServiceMapper m = null;
        if (CaProfile.MULTIPLE.getName().equals(profileName)) {
            mapper = null;
            Iterator i = new ArrayList(this.serviceMappers.values()).iterator();
            while (i.hasNext()) {
                ((CwsServiceMapper)i.next()).exclusiveConnectors.remove(name);
            }
        } else {
            mapper = this.getServiceMapper(profileName);
            if (mapper == null) {
                return;
            }
            mapper.exclusiveConnectors.remove(name);
        }
        Iterator iter = xml.getMultipleSubConfigs("can-decode-services");
        if (iter != null) {
            while (iter.hasNext()) {
                cds = (ProxyXmlConfig)iter.next();
                String canDecodeList = cds.getContents();
                if (canDecodeList == null) continue;
                boolean exclusive = "true".equalsIgnoreCase(cds.getStringValue("exclusive", "false"));
                if (mapper == null) {
                    profile = cds.getStringValue("profile");
                    m = this.getServiceMapper(profile);
                    if (m == null) {
                        throw new ConfigException(cds.getFullName(), "Unknown/disabled profile for can-decode-services: " + profile);
                    }
                } else if (cds.getStringValue("profile", "").length() > 0) {
                    throw new ConfigException(cds.getFullName(), "Profile not allowed for can-decode-services for this connector type.");
                }
                if (m == null) {
                    m = mapper;
                }
                this.storeDecodeState(name, ProxyConfig.getServiceTokens("can-decode-services", canDecodeList, false), m.overrideCanDecodeMap);
                if (exclusive) {
                    m.exclusiveConnectors.add(name);
                    continue;
                }
                m.exclusiveConnectors.remove(name);
            }
        }
        if ((iter = xml.getMultipleSubConfigs("cannot-decode-services")) != null) {
            while (iter.hasNext()) {
                cds = (ProxyXmlConfig)iter.next();
                String cannotDecodeList = cds.getContents();
                if (cannotDecodeList == null) continue;
                if (mapper == null) {
                    profile = cds.getStringValue("profile");
                    mapper = this.getServiceMapper(profile);
                    if (mapper == null) {
                        throw new ConfigException(cds.getFullName(), "Unknown/disabled profile for cannot-decode-services: " + profile);
                    }
                } else if (cds.getStringValue("profile", "").length() > 0) {
                    throw new ConfigException(cds.getFullName(), "Profile not allowed for cannot-decode-services for this connector type.");
                }
                this.storeDecodeState(name, ProxyConfig.getServiceTokens("cannot-decode-services", cannotDecodeList, false), mapper.overrideCannotDecodeMap);
            }
        }
    }

    private void storeDecodeState(String name, Set sids, Map map) {
        List<String> names;
        ServiceMapping sm;
        Iterator<Object> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            sm = (ServiceMapping)iter.next();
            names = (ArrayList<String>)map.get(sm);
            if (names == null) continue;
            names.remove(name);
        }
        iter = sids.iterator();
        while (iter.hasNext()) {
            sm = (ServiceMapping)iter.next();
            names = (List)map.get(sm);
            if (names == null) {
                names = new ArrayList<String>();
                map.put(sm, names);
            }
            if (names.contains(name)) continue;
            names.add(name);
        }
    }

    private void removeConnector(CwsConnector conn) {
        CwsServiceMapper mapper = this.getServiceMapper(conn.getProfileName());
        conn.setEnabled(false);
        conn.close();
        if (mapper != null) {
            mapper.removeConnector(conn);
        }
        this.logger.fine("Removed connector: " + conn.getName());
    }

    private void updateExternalConfig(ProxyXmlConfig xml) throws ConfigException {
        boolean enabled = true;
        try {
            enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled"));
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (enabled) {
            String url = xml.getStringValue("connector-file-url");
            try {
                this.connectorFileUri = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ConfigException(xml.getFullName(), "connector-file-url", "Malformed URL: " + e.getMessage());
            }
            try {
                this.connectorFileKey = xml.getStringValue("connector-file-key");
            }
            catch (ConfigException e) {
                this.connectorFileKey = null;
            }
            this.connectorFileInterval = xml.getTimeValue("update-interval", "m");
            try {
                this.updateCommand = new CtrlCommand("update-connectors", "Run update", "Fetch/install external connector file now (" + url + ").");
                this.updateCommand.register(this);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (!this.fetchConnectorFile() && this.connectorFile != null) {
                this.processConnectorFile(this.connectorFile);
                this.updateAuUsers();
            }
        } else {
            if (!this.externalConnectors.isEmpty()) {
                this.logger.info("Closing external connectors...");
                Iterator iter = this.externalConnectors.keySet().iterator();
                while (iter.hasNext()) {
                    CwsConnector conn = (CwsConnector)this.externalConnectors.get(iter.next());
                    this.removeConnector(conn);
                }
            }
            this.externalConnectors.clear();
            this.connectorFileUri = null;
            this.connectorFileInterval = 0;
            if (this.updateCommand != null) {
                this.updateCommand.unregister();
                this.updateCommand = null;
            }
            this.updateAuUsers();
        }
    }

    public CtrlCommandResult runCtrlCmdUpdateConnectors() {
        try {
            this.fetchConnectorFile();
        }
        catch (ConfigException e) {
            return new CtrlCommandResult(false, e.getMessage());
        }
        return new CtrlCommandResult(true, "Updated executed.");
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new ExitCacheSaveThread());
        this.connectorThread = new Thread((Runnable)this, "CwsConnectionManagerThread");
        this.connectorThread.start();
        this.keepAliveThread = new Thread((Runnable)this, "CwsKeepAliveThread");
        this.keepAliveThread.start();
    }

    public void run() {
        if (Thread.currentThread() == this.connectorThread) {
            this.doConnectLoop();
        } else if (Thread.currentThread() == this.keepAliveThread) {
            this.doKeepAliveLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectLoop() {
        this.logger.info("Starting...");
        Iterator iter = this.serviceMappers.values().iterator();
        while (iter.hasNext()) {
            ((CwsServiceMapper)iter.next()).loadServiceMaps();
        }
        CwsConnector cws = null;
        boolean alive = true;
        while (alive) {
            int count = 0;
            Iterator iter2 = this.getConnectors().values().iterator();
            while (iter2.hasNext()) {
                try {
                    cws = (CwsConnector)iter2.next();
                    if (cws.isConnected() || System.currentTimeMillis() - cws.getLastAttemptTimeStamp() <= this.reconnectInterval || !cws.connect(this)) continue;
                    ++count;
                }
                catch (IOException e) {
                    this.logger.warning("Failed to connect to: " + cws + " (" + e + ")");
                    if ("Unrecognized option".equals(e.getMessage())) {
                        this.logger.warning("Try adding this attribute to all newcamd connectors: qos-class=\"None\"");
                    }
                    this.logger.throwing(e);
                }
            }
            if (count != 0) {
                this.logger.info("Connected to [" + count + "] CWS/Cards");
            }
            this.ready = true;
            CwsConnectorManager cwsConnectorManager = this;
            synchronized (cwsConnectorManager) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    alive = false;
                }
            }
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isLogSidMismatch() {
        return this.logSidMismatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKeepAliveLoop() {
        boolean alive = true;
        while (alive) {
            Iterator iter = this.getConnectors().values().iterator();
            while (iter.hasNext()) {
                CwsConnector cws = (CwsConnector)iter.next();
                if (!cws.isConnected() || cws.getKeepAliveInterval() <= 0 || System.currentTimeMillis() - cws.getLastTrafficTimeStamp() <= (long)cws.getKeepAliveInterval()) continue;
                cws.reset();
                cws.sendMessage(new CamdNetMessage(253));
                this.logger.fine("Keep-alive sent to " + cws);
            }
            CwsConnectorManager cwsConnectorManager = this;
            synchronized (cwsConnectorManager) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    alive = false;
                }
            }
        }
    }

    public long getNextConnectAttempt(String name) {
        long lastAttemptTimeStamp = this.getCwsConnectorByName(name).getLastAttemptTimeStamp();
        if (lastAttemptTimeStamp == 0L) {
            return -1L;
        }
        return lastAttemptTimeStamp + this.reconnectInterval;
    }

    public CwsServiceMapper getServiceMapper(String profile) {
        return (CwsServiceMapper)this.serviceMappers.get(profile);
    }

    public CwsConnector getCwsConnectorByName(String name) {
        if (name == null) {
            return null;
        }
        CwsConnector conn = (CwsConnector)this.connectors.get(name);
        if (conn == null) {
            conn = (CwsConnector)this.externalConnectors.get(name);
        }
        return conn;
    }

    public CwsConnector getCwsConnector(String profile) {
        return this.getServiceMapper(profile).getCwsConnector();
    }

    public Map getConnectors() {
        HashMap allConnectors = new HashMap();
        allConnectors.putAll(this.connectors);
        allConnectors.putAll(this.externalConnectors);
        return allConnectors;
    }

    public Map getMultiConnectors(int networkId, int caId) {
        HashMap<String, CwsConnector> map = new HashMap<String, CwsConnector>();
        Iterator iter = this.multiConnectors.values().iterator();
        while (iter.hasNext()) {
            CwsConnector cws = (CwsConnector)iter.next();
            if (!cws.isReady() || !((MultiCwsConnector)((Object)cws)).hasMatchingProfile(networkId, caId)) continue;
            map.put(cws.getName(), cws);
        }
        return map;
    }

    public Map getConnectors(String profile) {
        return this.getServiceMapper(profile).getConnectors();
    }

    public Map getReadyConnectors(String profile) {
        HashMap<String, CwsConnector> map = new HashMap<String, CwsConnector>();
        Iterator iter = this.getReadyConnectorList(profile).iterator();
        while (iter.hasNext()) {
            CwsConnector cws = (CwsConnector)iter.next();
            map.put(cws.getName(), cws);
        }
        return map;
    }

    public List getReadyConnectorList(String profile) {
        CwsServiceMapper mapper = this.getServiceMapper(profile);
        if (mapper != null) {
            return mapper.getReadyConnectors();
        }
        this.logger.fine("Request for non-existing mapper: " + profile);
        this.logger.throwing(new Throwable());
        return new ArrayList();
    }

    public Set getMergedProviders(String profile) {
        List connectors = this.getReadyConnectorList(profile);
        if (connectors == null) {
            return null;
        }
        TreeSet providers = new TreeSet();
        Iterator iter = connectors.iterator();
        while (iter.hasNext()) {
            providers.addAll(((CwsConnector)iter.next()).getProviderIdents());
        }
        return providers;
    }

    public CwsConnector getConnectorForAU(String profile, String user) {
        String conn = (String)this.auUsers.get(user + ":" + profile);
        if (conn == null) {
            return null;
        }
        CwsConnector cws = this.getCwsConnectorByName(conn);
        if (cws != null && cws.isReady()) {
            return cws;
        }
        return null;
    }

    public CwsConnector getAUCardDataConnector(String profile, String user) {
        CwsConnector cws = this.getConnectorForAU(profile, user);
        if (cws != null && cws.getRemoteCard() != null) {
            return cws;
        }
        return null;
    }

    public long getMaxCwWait(CaProfile profile) {
        if (profile == null || CaProfile.MULTIPLE == profile) {
            return this.maxCwWait;
        }
        long mcw = profile.getMaxCwWait();
        return mcw == -1L ? this.maxCwWait : mcw;
    }

    public long getTimeoutThreshold() {
        return this.timeoutThreshold;
    }

    public long getCannotDecodeWait() {
        return this.cannotDecodeWait;
    }

    public long getCongestionLimit(CaProfile profile) {
        if (profile == null || CaProfile.MULTIPLE == profile) {
            return this.congestionLimit;
        }
        long cl = profile.getCongestionLimit();
        return cl == -1L ? this.congestionLimit : cl;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }

    public int getFailureCount(String profile, ServiceMapping id) {
        return this.getServiceMapper(profile).getFailures(id);
    }

    public int getUnknownSid(String profile) {
        return this.getServiceMapper(profile).getUnknownSid();
    }

    public boolean isServiceUnknown(String profile, int sid) {
        return this.getServiceMapper(profile).isServiceUnknown(sid);
    }

    public long getDelayNoSid() {
        return this.delayNoSid;
    }

    public void reportChannelStatus(CwsConnector cws, CamdNetMessage msg, boolean decodeSuccess, ProxySession session) {
        int serviceId = msg.getServiceId();
        if ((serviceId == 0 || this.isServiceUnknown(cws.getProfileName(), serviceId)) && msg.getCustomId() <= 0) {
            return;
        }
        CaProfile profile = this.config.getProfileById(msg.getNetworkId(), msg.getCaId());
        if (profile == null) {
            profile = cws.getProfile() == CaProfile.MULTIPLE ? session.getProfile() : cws.getProfile();
        }
        CwsServiceMapper mapper = this.getServiceMapper(profile.getName());
        if (decodeSuccess) {
            mapper.setCanDecode(msg, cws, session);
        } else {
            mapper.setCannotDecode(msg, cws, session);
        }
        mapper.saveServiceMaps();
    }

    public void reportMultiStatus(CwsConnector cws, CaProfile profile, ServiceMapping[] sids, boolean success, boolean merge) {
        CwsServiceMapper mapper = this.getServiceMapper(profile.getName());
        mapper.setMultiStatus(sids, cws, success, merge);
    }

    public List getServicesForConnector(String cwsName, boolean canDecode, boolean raw) {
        CwsConnector cws = this.getCwsConnectorByName(cwsName);
        if (cws == null || "?".equals(cws.getProfileName())) {
            return new ArrayList();
        }
        if (cws.getProfile() == CaProfile.MULTIPLE) {
            if (raw) {
                return new ArrayList();
            }
            TreeSet allServices = new TreeSet();
            Iterator iter = this.config.getRealProfiles().iterator();
            while (iter.hasNext()) {
                CaProfile profile = (CaProfile)iter.next();
                allServices.addAll(this.getServiceMapper(profile.getName()).getServicesForConnector(cws.getName(), canDecode, false));
            }
            return new ArrayList(allServices);
        }
        return this.getServiceMapper(cws.getProfileName()).getServicesForConnector(cwsName, canDecode, raw);
    }

    public ServiceMapping[] getServicesForProfile(String profileName, boolean canDecode) {
        TreeSet sids = new TreeSet();
        List readyConnectors = this.getReadyConnectorList(profileName);
        Iterator iter = readyConnectors.iterator();
        while (iter.hasNext()) {
            CwsConnector conn = (CwsConnector)iter.next();
            sids.addAll(this.getServicesForConnector(conn.getName(), canDecode, true));
        }
        if (!canDecode) {
            sids.removeAll(Arrays.asList(this.getServicesForProfile(profileName, true)));
        }
        if (this.config.getSidCacheLinker() != null) {
            if (canDecode) {
                sids.addAll(this.config.getSidCacheLinker().getServicesForProfile(profileName));
            } else {
                sids.removeAll(this.config.getSidCacheLinker().getServicesForProfile(profileName));
            }
        }
        return sids.toArray(new ServiceMapping[sids.size()]);
    }

    public Boolean canDecode(CwsConnector cws, ServiceMapping id) {
        return this.getServiceMapper(cws.getProfileName()).canDecode(cws, id);
    }

    public ConnectorSelection getConnectorsForService(String profile, ServiceMapping id, Set allowedConnectorNames) {
        if (this.config.getSidCacheLinker() != null && this.config.getSidCacheLinker().getServicesForProfile(profile).contains(id)) {
            return ConnectorSelection.EMPTY;
        }
        return this.getServiceMapper(profile).getConnectorsForService(id, allowedConnectorNames);
    }

    public List getConnectorsForProvider(String profile, String provider) {
        return this.getServiceMapper(profile).getConnectorsForProvider(provider);
    }

    public void timeout(CronTimer cronTimer) {
        if (cronTimer == this.excludeCron) {
            this.resetExcludedStatus();
        } else if (cronTimer == this.rediscoverCron) {
            this.resetLostStatus();
            if (this.connectorFileInterval > 0 && System.currentTimeMillis() - this.connectorFileLastCheck > (long)this.connectorFileInterval) {
                new Thread("ConnectorFileFetchThread"){

                    public void run() {
                        try {
                            CwsConnectorManager.this.fetchConnectorFile();
                        }
                        catch (ConfigException e) {
                            ProxyConfig.logConfigException(CwsConnectorManager.this.logger, e);
                        }
                    }
                }.start();
            }
        }
    }

    private void resetLostStatus() {
        Iterator iter = this.serviceMappers.values().iterator();
        while (iter.hasNext()) {
            ((CwsServiceMapper)iter.next()).resetLostStatus();
        }
    }

    private void resetExcludedStatus() {
        Iterator iter = this.serviceMappers.values().iterator();
        while (iter.hasNext()) {
            ((CwsServiceMapper)iter.next()).resetListedServices();
        }
    }

    public void cwsConnected(CwsConnector cws) {
        this.getServiceMapper(cws.getProfileName()).addConnector(cws);
        if (cws instanceof MultiCwsConnector) {
            this.multiConnectors.put(cws.getName(), cws);
        }
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsConnected(cws);
        }
    }

    public void cwsDisconnected(CwsConnector cws) {
        if (cws instanceof MultiCwsConnector) {
            this.multiConnectors.remove(cws.getName());
        }
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsDisconnected(cws);
        }
    }

    public void cwsConnectionFailed(CwsConnector cws, String message) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsConnectionFailed(cws, message);
        }
    }

    public void cwsEcmTimeout(CwsConnector cws, String message, int failureCount) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsEcmTimeout(cws, message, failureCount);
        }
    }

    public void cwsLostService(CwsConnector cws, TvService service, boolean show) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsLostService(cws, service, show);
        }
    }

    public void cwsFoundService(CwsConnector cws, TvService service, boolean show) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsFoundService(cws, service, show);
        }
    }

    public void cwsInvalidCard(CwsConnector cws, String message) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsInvalidCard(cws, message);
        }
    }

    public void cwsProfileChanged(CaProfile profile, boolean added) {
        Iterator iter = new ArrayList(this.listeners).iterator();
        while (iter.hasNext()) {
            ((CwsListener)iter.next()).cwsProfileChanged(profile, added);
        }
    }

    public void addCwsListener(CwsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeCwsListener(CwsListener listener) {
        this.listeners.remove(listener);
    }

    public int resetStatus(String cwsName, boolean full) {
        CwsConnector cws = this.getCwsConnectorByName(cwsName);
        if (cws == null) {
            return -1;
        }
        if (cws.getProfile() == CaProfile.MULTIPLE) {
            ((MultiCwsConnector)((Object)cws)).clearRemoteState(full);
            return 1;
        }
        return this.getServiceMapper(cws.getProfileName()).resetStatus(cwsName, full);
    }

    public boolean resetStatus(String profileName, ServiceMapping id) {
        CaProfile profile = this.config.getProfile(profileName);
        return profile != null && this.getServiceMapper(profileName).resetStatus(id);
    }

    public void saveServiceMaps() {
        Iterator iter = this.serviceMappers.values().iterator();
        while (iter.hasNext()) {
            ((CwsServiceMapper)iter.next()).saveServiceMaps(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean fetchConnectorFile() throws ConfigException {
        try {
            this.connectorFileLastCheck = System.currentTimeMillis();
            this.logger.fine("Fetching '" + this.connectorFileUri + (this.connectorFileLastModified != -1L ? ", lm: " + new Date(this.connectorFileLastModified) : ""));
            String newFile = FileFetcher.fetchFile(this.connectorFileUri, this.connectorFileKey, this.connectorFileLastModified);
            if (newFile == null) {
                this.logger.fine("Connector file unchanged...");
                return false;
            }
            if (this.connectorFile != null && this.connectorFile.hashCode() == newFile.hashCode()) {
                this.logger.fine("No changes found after fetch...");
                return false;
            }
            this.processConnectorFile(newFile);
            this.updateAuUsers();
            return true;
        }
        catch (IOException e) {
            this.logger.throwing(e);
            this.logger.warning("Failed to fetch connector file '" + this.connectorFileUri + "': " + e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConnectorFile(String newFile) {
        try {
            ProxyXmlConfig xml = new ProxyXmlConfig(new XMLConfig(newFile, false));
            this.updateConnectors(xml, this.externalConnectors);
            this.logger.info(this.externalConnectors.size() + " connector definitions parsed/updated from '" + this.connectorFileUri + "', total: " + this.getConnectors().size());
            if (!this.externalConnectors.isEmpty()) {
                CwsConnectorManager cwsConnectorManager = this;
                synchronized (cwsConnectorManager) {
                    this.notifyAll();
                }
            }
            if (!newFile.equals(this.connectorFile)) {
                this.connectorFile = newFile;
                this.connectorFileLastModified = System.currentTimeMillis();
            }
        }
        catch (XMLConfigException e) {
            this.logger.throwing(e);
            this.logger.warning("Unable to parse '" + this.connectorFileUri + "': " + e.getMessage());
        }
        catch (ConfigException e) {
            this.logger.throwing(e);
            this.logger.warning("Error in connector file '" + this.connectorFileUri + "': " + e.getMessage());
        }
    }

    private class ExitCacheSaveThread
    extends Thread {
        private ExitCacheSaveThread() {
        }

        public void run() {
            CwsConnectorManager.this.logger.info("Saving channel maps and seen data on exit...");
            CwsConnectorManager.this.saveServiceMaps();
            SessionManager.getInstance().saveSeenData();
            CwsConnectorManager.this.config.stopPlugins();
        }
    }
}

