/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.NewcamdConnection;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.session.AbstractSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.util.Globber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class NewcamdSession
extends AbstractSession {
    private static final int LOGIN_SO_TIMEOUT = 30000;
    private int emmCount;
    private int keepAliveCount;
    private long lastKeepAliveTimeStamp;
    private byte[] cfgKey;
    protected NewcamdConnection conn;
    private CardData card;
    private boolean noValidation;

    public NewcamdSession(Socket conn, ListenPort listenPort, CamdMessageListener listener) {
        super(listenPort, listener);
        boolean noEncrypt = "true".equalsIgnoreCase(listenPort.getStringProperty("no-encryption"));
        this.noValidation = "true".equalsIgnoreCase(listenPort.getStringProperty("no-validation"));
        this.cfgKey = listenPort.getBytesProperty("des-key");
        if (this.cfgKey == null) {
            this.cfgKey = ProxyConfig.getInstance().getDefaultProfileDesKey();
            if (this.cfgKey == null) {
                this.logger.severe("No des-key set for listen-port '" + listenPort + "' and no default-des-key set in ca-profiles.");
                try {
                    conn.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            this.logger.fine("Using default des-key: " + DESUtil.bytesToString(this.cfgKey));
        } else {
            this.logger.fine("Using des-key configured for port '" + listenPort + "': " + DESUtil.bytesToString(this.cfgKey));
        }
        this.conn = new NewcamdConnection(conn, noEncrypt, ProxyConfig.getInstance().isDebug());
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        this.sessionThread = new Thread((Runnable)this, className + "Thread-" + this.sessionId);
        this.sessionThread.start();
    }

    protected CamdNetMessage getLoginOkMsg() {
        return new CamdNetMessage(225);
    }

    public void run() {
        this.logger.fine("Starting...");
        this.alive = true;
        ProxyConfig config = ProxyConfig.getInstance();
        SessionManager sm = SessionManager.getInstance();
        UserManager um = config.getUserManager();
        boolean skipAuth = false;
        int originId = config.getProxyOriginId();
        try {
            this.conn.init(this.logger);
            this.remoteAddress = this.conn.getRemoteAddress();
            this.conn.setMaxSize(config.getNewcamdMaxMsgSize());
            this.conn.clientHandshake(30000, this.cfgKey);
            CamdNetMessage msg = this.readMessage();
            if (msg == null) {
                this.close();
            } else {
                this.fireCamdMessage(msg, false);
                if (msg.getCommandTag() != 224) {
                    this.close();
                } else {
                    boolean checkProfile;
                    String storedPw;
                    String cryptPw;
                    String user;
                    block33: {
                        user = msg.getStringData()[0];
                        cryptPw = msg.getStringData()[1];
                        storedPw = null;
                        try {
                            storedPw = um.getPassword(user);
                            this.loginName = user.length() > 32 ? user.substring(0, 32) : user;
                            String userName = um.getUserName(user);
                            if (userName != null) {
                                user = userName;
                            }
                        }
                        catch (RuntimeException re) {
                            if (!config.isUserAllowOnFailure()) break block33;
                            skipAuth = true;
                        }
                    }
                    this.clientId = msg.getClientIdStr();
                    String ipMask = um.getIpMask(user);
                    Set profiles = um.getAllowedProfiles(user);
                    boolean bl = checkProfile = profiles != null && !profiles.isEmpty() && this.getProfile() != CaProfile.MULTIPLE;
                    if (!(skipAuth || storedPw != null && DESUtil.checkPassword(storedPw, cryptPw))) {
                        this.loginFailure(user, "unauthorized/invalid/missing password", msg);
                    } else if (!um.isEnabled(user)) {
                        this.loginFailure(user, "account disabled", msg);
                    } else if (!Globber.match((String)ipMask, (String)this.getRemoteAddress(), (boolean)false)) {
                        this.loginFailure(user, "ip check failed: " + ipMask, msg);
                    } else if (!config.isUserAllowDifferentIp() && sm.checkSessionIP(user, this.getRemoteAddress())) {
                        this.loginFailure(user, "session from different source ip exists, denying multiple", msg);
                    } else if (!this.checkClientId(this.clientId)) {
                        this.loginFailure(user, "client-id not allowed/supported: " + this.clientId, msg);
                    } else if (checkProfile && !profiles.contains(this.getProfileName())) {
                        this.loginFailure(user, "no access for profile: " + this.getProfileName(), msg);
                    } else {
                        long idleMins;
                        this.maxSessions = config.getUserManager().getMaxConnections(user);
                        if (this.maxSessions == -1) {
                            this.maxSessions = this.getProfile().getNewcamdPortCount();
                        }
                        int sessionCount = sm.syncCountSessions(user, this.getProfileName());
                        this.logger.info("User '" + user + "' (" + CustomFormatter.formatAddress(this.getRemoteAddress()) + ") login successful. Client: " + this.clientId + " - [" + (sessionCount + 1) + "/" + this.maxSessions + "]");
                        if (sessionCount >= this.maxSessions) {
                            idleMins = sm.closeOldestSession(user, false, this.getProfileName()) / 60000L;
                            this.logger.info("User '" + user + "' already has [" + this.maxSessions + "] connection(s), closing oldest (idle " + idleMins + " mins)");
                        }
                        if (config.getMaxConnectionsIP() > 0 && sessionCount >= config.getMaxConnectionsIP()) {
                            idleMins = sm.closeOldestSession(this.getRemoteAddress(), true, this.getProfileName()) / 60000L;
                            this.logger.info("IP '" + CustomFormatter.formatAddress(this.getRemoteAddress()) + "' already has [" + sessionCount + "] connection(s), closing oldest (idle " + idleMins + " mins)");
                        }
                        this.user = user;
                        this.setupLimits(um);
                        byte[] desKey = this.cfgKey;
                        desKey = DESUtil.xorUserPass(desKey, cryptPw);
                        desKey = DESUtil.desKeySpread(desKey);
                        CamdNetMessage loginOkMsg = this.getLoginOkMsg();
                        this.conn.sendMessage(loginOkMsg, msg.getSequenceNr(), desKey);
                        this.fireCamdMessage(loginOkMsg, true);
                        if ("0.0.0.0".equals(this.getRemoteAddress())) {
                            this.close();
                            return;
                        }
                        sm.addSession(this);
                        this.conn.setSoTimeout(config.getSessionTimeout());
                        Thread.currentThread().setName(Thread.currentThread().getName() + "[" + user + "]");
                    }
                }
            }
            String reason = "";
            while (this.alive) {
                try {
                    msg = this.readMessage();
                }
                catch (SocketTimeoutException e) {
                    msg = null;
                    String idleTime = this.conn == null ? "" : (System.currentTimeMillis() - this.conn.getLastTrafficTimeStamp()) / 60000L + " mins since last activity";
                    this.logger.fine("Idle timeout" + (this.getUser() == null ? "" : " for user '" + this.getUser() + "'") + " (" + CustomFormatter.formatAddress(this.getRemoteAddress()) + ") " + idleTime);
                    if (config.getSessionKeepAlive() != 0) {
                        Set clients = config.getKeepAliveExcludedClients();
                        if (!clients.contains(this.getClientId().toLowerCase())) {
                            this.sendMessage(new CamdNetMessage(253));
                            continue;
                        }
                    }
                    reason = "(" + idleTime + ")";
                    this.close();
                }
                if (msg == null) {
                    this.alive = false;
                    this.logger.info("Connection closed" + (this.getUser() == null ? "" : " for user '" + this.getUser() + "' ") + reason);
                    continue;
                }
                msg.setOriginId(originId);
                if (um.isEnabled(this.user)) {
                    boolean checksOk = this.checkLimits(msg);
                    checksOk = checksOk && this.handleMessage(msg);
                    this.fireCamdMessage(msg, false);
                    if (checksOk) continue;
                    this.setFlag(msg, 'B');
                    if (!this.isConnected()) continue;
                    this.sendEcmReply(msg, msg.getEmptyReply());
                    continue;
                }
                this.logger.warning("'User '" + this.user + "' kicked, account disabled");
                this.close();
            }
        }
        catch (SocketException e) {
            this.logger.info(e.getMessage() + (this.getUser() == null ? "" : " for user '" + this.getUser() + "' (" + e + ")"));
        }
        catch (Exception e) {
            this.logger.throwing("Unexpected exception reading/decrypting message: " + e, e);
        }
        this.alive = false;
        this.endSession();
    }

    protected boolean checkClientId(String id) {
        return true;
    }

    protected boolean handleMessage(CamdNetMessage msg) {
        if (msg.isEcm() && !this.noValidation) {
            int id = msg.getCaIdFromHdr();
            if (id != 0 && id != msg.getCaId()) {
                String s = "Wrong ca-id in newcamd header: " + DESUtil.intToHexString(id, 4) + " (expected: " + DESUtil.intToHexString(msg.getCaId(), 4) + ") - ClientId: " + this.clientId;
                msg.setFilteredBy(s);
                this.logger.warning(s);
                this.logger.fine("Offending msg: " + msg.getCommandName() + " - " + DESUtil.bytesToString(msg.getRawIn()));
                return false;
            }
            id = msg.getProviderFromHdr();
            if (id != 0) {
                String ps = DESUtil.intToByteString(id, 3);
                if (!msg.getProviderContext().contains(ps)) {
                    String s = "Provider ident in newcamd header doesn't match card-data: " + ps + " (expected one of: " + msg.getProviderContext() + ")";
                    msg.setFilteredBy(s);
                    this.logger.warning(s);
                    return false;
                }
                if (!this.getProfile().getProviderSet().contains(new Integer(id))) {
                    String s = "Provider ident '" + ps + "' doesn't exist for profile '" + this.getProfile().getName() + "', kicking session to force an update...";
                    msg.setFilteredBy(s);
                    this.logger.warning(s);
                    this.close();
                    return false;
                }
            }
        }
        return this.handleNewcamd(msg);
    }

    protected boolean handleNewcamd(CamdNetMessage msg) {
        switch (msg.getCommandTag()) {
            case 253: {
                this.logger.fine("Keep-alive received from '" + this.user + "' (" + this.getClientId() + "), responding...");
                CamdNetMessage keepAliveMsg = new CamdNetMessage(253);
                this.sendMessageNative(keepAliveMsg, msg.getSequenceNr(), true);
                this.fireCamdMessage(keepAliveMsg, true);
                break;
            }
            case 227: {
                CardData card;
                Map map;
                CwsConnectorManager cm = ProxyConfig.getInstance().getConnManager();
                CwsConnector anyCws = cm.getCwsConnector(this.getProfileName());
                String cardDataType = this.listenPort.getStringProperty("card-data", "type");
                if (this.getProfile().isCacheOnly() && cardDataType == null) {
                    cardDataType = "empty";
                }
                if (cardDataType == null && anyCws == null && (map = cm.getMultiConnectors(this.getProfile().getNetworkId(), this.getProfile().getCaId())).isEmpty() && this.getProfile().getProviderSet().isEmpty()) {
                    this.close();
                    this.logger.warning("Connection with no '" + this.getProfileName() + "' CWS connectors available, aborted...");
                    return true;
                }
                boolean au = false;
                if (cardDataType != null) {
                    String arg = this.listenPort.getStringProperty("card-data", "ca-id");
                    if (arg == null) {
                        arg = this.listenPort.getStringProperty("card-data", "name");
                    }
                    if ("true".equalsIgnoreCase(this.listenPort.getStringProperty("card-data", "override-au"))) {
                        card = this.getCardData(cardDataType, arg);
                    } else {
                        card = this.getAuCardData(cm.getAUCardDataConnector(this.getProfileName(), this.getUser()));
                        if (card == null) {
                            card = this.getCardData(cardDataType, arg);
                        } else {
                            au = true;
                        }
                    }
                } else {
                    Set merged;
                    card = this.getAuCardData(cm.getAUCardDataConnector(this.getProfileName(), this.getUser()));
                    if (card == null) {
                        card = anyCws != null ? anyCws.getRemoteCard() : CardData.createData(this.getProfile().getCaId(), this.getProfile().getProviderIdents());
                    } else {
                        au = true;
                    }
                    if (this.getProfile().isMismatchedCards() && (merged = this.getProfile().getProviderSet()) != null) {
                        merged.removeAll(Arrays.asList(card.getProvidersAsInt()));
                        card = CardData.createMergedData(card, merged.toArray(new Integer[merged.size()]));
                    }
                }
                this.card = au ? card : new CardData(card.getData(true));
                CamdNetMessage cardDataMsg = new CamdNetMessage(228);
                cardDataMsg.setCustomData(card.getData(!au));
                this.sendMessageNative(cardDataMsg, msg.getSequenceNr(), true);
                this.fireCamdMessage(cardDataMsg, true);
            }
        }
        return true;
    }

    protected CardData getAuCardData(CwsConnector auCws) {
        if (auCws != null) {
            this.logger.info("Returning au-user card-data from " + auCws);
            return auCws.getRemoteCard();
        }
        return null;
    }

    private CardData getCardData(String type, String name) {
        if ("connector".equalsIgnoreCase(type)) {
            if (name == null) {
                this.logger.warning("No name specified for card-data type connector (" + this.getListenPort() + "), using empty data...");
                type = "empty";
            } else {
                type = "file";
                name = "etc/Cws[" + name + "].card";
            }
        }
        if ("file".equalsIgnoreCase(type)) {
            if (name == null) {
                this.logger.warning("No name specified for card-data type file (" + this.getListenPort() + "), using empty data...");
                type = "empty";
            } else {
                try {
                    CardData card = CardData.createFromFile(new File(name));
                    if (card.getParseException() != null) {
                        this.logger.warning("Parser exception occured while reading card-data file '" + name + "' (" + card.getParseException() + ")");
                        this.logger.throwing(card.getParseException());
                    }
                    this.logger.info("Returning specified card-data (for " + this.getListenPort() + ") from file: " + name);
                    return card;
                }
                catch (FileNotFoundException fne) {
                    this.logger.warning("Card-data file (for " + this.getListenPort() + ") not found '" + name + "', using empty data...");
                    type = "empty";
                }
                catch (IOException e) {
                    this.logger.throwing(e);
                    this.logger.warning("Error reading card-data file '" + name + "' (" + e + "), using empty data...");
                    type = "empty";
                }
            }
        }
        if ("config".equalsIgnoreCase(type)) {
            int caId = this.getProfile().getCaId();
            try {
                String providers;
                if (name != null) {
                    caId = Integer.parseInt(name, 16);
                }
                if ((providers = this.getListenPort().getStringProperty("card-data", "providers")) == null) {
                    providers = this.getListenPort().getStringProperty("card-data", "provider-idents");
                }
                if (providers == null || providers.length() == 0) {
                    CardData card = CardData.createEmptyData(caId);
                    Integer[] idents = this.getProfile().getProviderIdents();
                    if (idents.length != 0) {
                        card = CardData.createMergedData(card, idents);
                    }
                    return card;
                }
                return CardData.createData(caId, providers.split(","));
            }
            catch (Exception e) {
                this.logger.throwing(e);
                this.logger.warning("Failed to parse configured card-data for " + this.getListenPort() + ", returning empty... (" + e + ")");
                type = "empty";
            }
        }
        if (!"empty".equalsIgnoreCase(type)) {
            this.logger.warning("Invalid card-data type specified for '" + this.getListenPort() + "' (" + type + "), using empty data...");
        }
        this.logger.info("Returning empty card-data with ca-id " + this.getProfile().getCaIdStr());
        return CardData.createEmptyData(this.getProfile().getCaId());
    }

    private void loginFailure(String user, String cause, CamdNetMessage loginMsg) {
        if (ProxyConfig.getInstance().isLogFailures()) {
            this.logger.warning("User '" + user + "' (" + CustomFormatter.formatAddress(this.getRemoteAddress()) + ") login denied, " + cause);
        }
        SessionManager.getInstance().fireUserLoginFailed(user, this.listenPort + "/" + this.getProfileName(), this.getRemoteAddress(), cause);
        CamdNetMessage loginFailedMsg = new CamdNetMessage(226);
        this.sendMessageNative(loginFailedMsg, loginMsg.getSequenceNr(), true);
        this.fireCamdMessage(loginFailedMsg, true);
        this.close();
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.sessionThread != null) {
            this.sessionThread.interrupt();
        }
    }

    public boolean isConnected() {
        return this.conn != null && this.conn.isConnected();
    }

    CamdNetMessage readMessage() throws IOException {
        CamdNetMessage msg = this.conn.readMessage();
        if (msg != null) {
            ++this.msgCount;
            if (msg.isEcm()) {
                ++this.ecmCount;
                if (msg.getProviderIdent() == -1 && !this.noValidation) {
                    if (msg.getProviderFromHdr() != 0) {
                        msg.setProviderIdent(msg.getProviderFromHdr());
                    } else if ("CCcam".equals(this.clientId)) {
                        msg.setProviderIdent(msg.getProviderFromHdr());
                    }
                }
            } else if (msg.isEmm()) {
                ++this.emmCount;
            } else if (msg.isKeepAlive()) {
                ++this.keepAliveCount;
                this.lastKeepAliveTimeStamp = System.currentTimeMillis();
            }
            if (this.card != null) {
                msg.setProviderContext(this.card.getProviders());
            }
            msg.setCaId(this.listenPort.getProfile().getCaId());
            msg.setNetworkId(this.listenPort.getProfile().getNetworkId());
        }
        return msg;
    }

    public int sendMessage(CamdNetMessage msg) {
        int status = this.sendMessageNative(msg, -1, true);
        if (status != -1) {
            this.fireCamdMessage(msg, true);
        }
        return status;
    }

    public int sendEcmReplyNative(CamdNetMessage ecmRequest, CamdNetMessage ecmReply) {
        int result = this.sendMessageNative(ecmReply, ecmRequest.getSequenceNr(), true);
        this.endTransaction(ecmRequest, ecmReply, result);
        return result;
    }

    public synchronized int sendMessageNative(CamdNetMessage msg, int seqNr, boolean flush) {
        return this.conn.sendMessage(msg, seqNr, flush);
    }

    public String getProtocol() {
        return "Newcamd";
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public int getKeepAliveCount() {
        if (System.currentTimeMillis() - this.lastKeepAliveTimeStamp > 305000L) {
            return 0;
        }
        return this.keepAliveCount;
    }

    public long getIdleTime() {
        if (this.conn == null) {
            return -1L;
        }
        return System.currentTimeMillis() - this.conn.getLastTrafficTimeStamp();
    }

    public String getLastContext() {
        if (this.card == null) {
            return "?";
        }
        return this.card.toString();
    }

    public boolean sendOsdMessage(String message) {
        if ("Mgcamd".equals(this.clientId) || "Acamd".equals(this.clientId)) {
            CamdNetMessage osdMsg = new CamdNetMessage(209);
            try {
                osdMsg.setCustomData(message.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return this.sendMessage(osdMsg) != -1;
        }
        return false;
    }
}

