/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.tv;

import com.bowman.cardserv.tv.TvService;
import com.bowman.xml.XMLConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NeutrinoParser {
    private String fileName;
    private int conflicts;

    public NeutrinoParser(String fileName) {
        this.fileName = fileName;
    }

    public Map parse(String filter, String profile, int networkId) throws IOException {
        HashSet<String> filterSet = null;
        if (filter != null) {
            String[] s = filter.toLowerCase().split(",");
            filterSet = new HashSet<String>();
            for (int i = 0; i < s.length; ++i) {
                filterSet.add(s[i].trim().toLowerCase());
            }
        }
        if (filterSet != null && filterSet.isEmpty()) {
            filterSet = null;
        }
        XMLConfig xml = new XMLConfig((InputStream)new FixingFileInputStream(this.fileName), false, "UTF-8");
        HashMap services = new HashMap();
        int[] tokens = new int[6];
        int i = 1;
        Enumeration e = xml.getMultipleSubConfigs("sat");
        while (e.hasMoreElements()) {
            XMLConfig sat = (XMLConfig)e.nextElement();
            if (filterSet != null && !NeutrinoParser.matchesFilter(sat.getString("name"), filterSet)) continue;
            Enumeration n = sat.getMultipleSubConfigs("transponder");
            while (n.hasMoreElements()) {
                XMLConfig tp = (XMLConfig)n.nextElement();
                int tid = Integer.parseInt(tp.getString("id"), 16);
                int onid = Integer.parseInt(tp.getString("onid"), 16);
                if (filterSet == null && networkId != onid) continue;
                Enumeration m = tp.getMultipleSubConfigs("channel");
                while (m.hasMoreElements()) {
                    XMLConfig chan = (XMLConfig)m.nextElement();
                    tokens[0] = Integer.parseInt(chan.getString("service_id"), 16);
                    tokens[1] = 0;
                    tokens[2] = tid;
                    tokens[3] = filterSet == null ? onid : networkId;
                    tokens[4] = Integer.parseInt(chan.getString("service_type"), 16);
                    tokens[5] = i++;
                    TvService service = new TvService(tokens, profile);
                    service.setName(chan.getString("name"));
                    this.addService(services, service);
                }
            }
        }
        return services;
    }

    private static boolean matchesFilter(String s, Set filters) {
        s = s.toLowerCase();
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            if (!s.startsWith((String)iter.next())) continue;
            return true;
        }
        return false;
    }

    private void addService(Map services, TvService service) {
        if (!service.isTv()) {
            return;
        }
        Integer i = new Integer(service.getId());
        if (services.containsKey(i)) {
            TvService existing = (TvService)services.get(i);
            if (!service.getName().equalsIgnoreCase(existing.getName())) {
                existing.addConflicting(service);
                ++this.conflicts;
            }
        } else {
            services.put(i, service);
        }
    }

    public int getConflicts() {
        return this.conflicts;
    }

    private static class FixingFileInputStream
    extends FileInputStream {
        public FixingFileInputStream(String name) throws FileNotFoundException {
            super(name);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = super.read(b, off, len);
            int max = off + count;
            for (int i = off; i < max; ++i) {
                if (b[i] < 0 || b[i] > 6) continue;
                b[i] = 32;
            }
            return count;
        }
    }
}

