/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.xml.XMLEncoder;

public class XmlStringBuffer {
    private StringBuffer sb;
    private String contents;

    public XmlStringBuffer() {
        this.sb = new StringBuffer();
    }

    public XmlStringBuffer(StringBuffer sb) {
        this.sb = sb;
    }

    public XmlStringBuffer appendElement(String name) {
        return this.appendElement(name, new String[0], new String[0], false);
    }

    public XmlStringBuffer appendElement(String name, String attrib, int value) {
        return this.appendElement(name, new String[]{attrib}, new String[]{String.valueOf(value)}, false);
    }

    public XmlStringBuffer appendElement(String name, String attrib, String value) {
        return this.appendElement(name, new String[]{attrib}, new String[]{value}, false);
    }

    public XmlStringBuffer appendElement(String name, String attrib, String value, boolean close) {
        return this.appendElement(name, new String[]{attrib}, new String[]{value}, close);
    }

    public XmlStringBuffer appendElement(String name, String[] attribs, String[] values, boolean close) {
        this.sb.append('<').append(name);
        if (attribs != null && attribs.length > 0) {
            for (int i = 0; i < attribs.length; ++i) {
                if (values.length <= i || values[i] == null) continue;
                this.appendAttr(attribs[i], values[i]);
            }
        }
        if (close) {
            this.sb.append(" /");
        }
        this.sb.append(">\n");
        return this;
    }

    public XmlStringBuffer appendAttr(String name, boolean value) {
        return this.appendAttr(name, String.valueOf(value));
    }

    public XmlStringBuffer appendAttr(String name, int value) {
        return this.appendAttr(name, String.valueOf(value));
    }

    public XmlStringBuffer appendAttr(String name, long value) {
        return this.appendAttr(name, String.valueOf(value));
    }

    public XmlStringBuffer appendAttr(String name, String value) {
        if (value == null) {
            return this;
        }
        if (this.sb.charAt(this.sb.length() - 1) == '\n') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        if (this.sb.charAt(this.sb.length() - 1) == '>') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        if (this.sb.charAt(this.sb.length() - 1) == '/') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        if (this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
        this.sb.append(' ').append(name).append("=\"").append(XMLEncoder.encode((String)value)).append('\"');
        return this;
    }

    public XmlStringBuffer appendText(String text) {
        this.sb.append(XMLEncoder.encode((String)text));
        return this;
    }

    public XmlStringBuffer appendCdata(String text) {
        this.sb.append("<![CDATA[").append(text).append("]]>");
        return this;
    }

    public XmlStringBuffer closeElement() {
        this.sb.append(" />\n");
        return this;
    }

    public XmlStringBuffer closeElement(String name) {
        this.sb.append("</").append(name).append(">\n");
        return this;
    }

    public XmlStringBuffer endElement(boolean close) {
        if (close) {
            return this.closeElement();
        }
        this.sb.append(">\n");
        return this;
    }

    public String toString() {
        if (this.contents == null) {
            return this.sb.toString();
        }
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }
}

