/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.crypto.FishUtil;
import com.bowman.util.BasicHttpAuth;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FileFetcher {
    public static final int URLCONN_TIMEOUT = 30000;
    private static Map urlConnections = new HashMap();
    private static Properties props;
    public static SSLSocketFactory socketFactory;

    public static String[] fetchList(URL url, String key) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(FileFetcher.fetchFile(url, key, -1L)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static void fetchBinary(URL url, File targetFile) throws IOException {
        byte[] buf;
        URLConnection conn = url.openConnection();
        int len = conn.getContentLength();
        if (len > 0) {
            buf = new byte[len];
            DataInputStream dis = new DataInputStream(conn.getInputStream());
            dis.readFully(buf);
            dis.close();
            if (!targetFile.exists() && !targetFile.createNewFile()) {
                throw new IOException("Failed to create file: " + targetFile);
            }
        } else {
            throw new IOException("Content length missing.");
        }
        FileOutputStream fos = new FileOutputStream(targetFile);
        fos.write(buf);
        fos.flush();
        fos.close();
    }

    public static String fetchFile(URL url, String key, long lastModified) throws IOException {
        String line;
        FileFetcher.killConnections();
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection && url.getUserInfo() != null) {
            conn.setRequestProperty("Authorization", BasicHttpAuth.encode((String)url.getUserInfo()));
        }
        FileFetcher.addConnection(conn);
        if (lastModified > 0L && conn.getLastModified() > 0L && conn.getLastModified() <= lastModified) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), FileFetcher.getCharset(conn.getContentType())));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            if (key != null) continue;
            sb.append('\n');
        }
        if (key != null) {
            if ("*".equals(key)) {
                key = props.getProperty("key");
            }
            return FishUtil.decryptString((String)key, (String)sb.toString());
        }
        return sb.toString();
    }

    public static void encryptFile(String inFile, String outFile, String key) throws IOException {
        File in = new File(inFile);
        DataInputStream dis = new DataInputStream(new FileInputStream(in));
        byte[] data = new byte[(int)in.length()];
        dis.readFully(data);
        dis.close();
        String encStr = FishUtil.encryptString((String)key, (String)new String(data, "ISO-8859-1"));
        PrintWriter pw = new PrintWriter((Writer)new FileWriter(outFile), true);
        pw.println(encStr);
        pw.close();
    }

    private static void addConnection(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            urlConnections.put(new Long(System.currentTimeMillis()), conn);
        }
    }

    private static void killConnections() {
        Iterator iter = new ArrayList(urlConnections.keySet()).iterator();
        while (iter.hasNext()) {
            HttpURLConnection conn;
            Long key = (Long)iter.next();
            if (System.currentTimeMillis() - key <= 30000L || (conn = (HttpURLConnection)urlConnections.remove(key)) == null) continue;
            conn.disconnect();
        }
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return "ISO-8859-1";
        }
        int indx = (contentType = contentType.toLowerCase()).indexOf("charset=");
        if (indx == -1) {
            return "ISO-8859-1";
        }
        return contentType.substring(indx + "charset=".length()).trim();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: java -jar fishenc.jar <inputfile> <outputfile> <key>");
        } else {
            FileFetcher.encryptFile(args[0], args[1], args[2]);
        }
    }

    static {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new NaiveHostnameVerifier());
            socketFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        props = new Properties();
        try {
            props.load(FileFetcher.class.getResourceAsStream("filefetcher.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class NaiveHostnameVerifier
    implements HostnameVerifier {
        NaiveHostnameVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    static class NaiveTrustManager
    implements X509TrustManager {
        NaiveTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public boolean isClientTrusted(X509Certificate[] x509Certificates) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509Certificates) {
            return true;
        }
    }
}

