/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CacheCoverageMap;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.SourceCacheEntry;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.TimedAverageList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ServiceCacheEntry
implements Comparable {
    static final int TOLERANCE = 2000;
    static final int WINDOW_SIZE = 60;
    static final byte[] ZERO_CW = DESUtil.stringToBytes((String)"00 00 00 00 00 00 00 00");
    CamdNetMessage request;
    CamdNetMessage reply;
    TvService ts;
    private int updateCount;
    private int abortCount;
    private int duplicateCount;
    private int overwriteCount;
    private int continuityCount;
    private int continuityErrors;
    private int continuityErrorsTotal;
    private int multiple;
    private long lastInterval;
    private long expectedInterval;
    private long timeOffset = -1L;
    private TimedAverageList intervals = new TimedAverageList(60);
    private TimedAverageList variances = new TimedAverageList(60);
    private MessageCacheMap backLog = new MessageCacheMap(60000L);
    private Map sources = new TreeMap();
    private CacheCoverageMap parent;

    ServiceCacheEntry(TvService ts, CamdNetMessage request, long expectedInterval, CacheCoverageMap parent) {
        this.ts = ts;
        this.expectedInterval = expectedInterval;
        this.parent = parent;
        this.request = request;
    }

    public long getAge() {
        return this.request == null ? -1L : System.currentTimeMillis() - this.request.getTimeStamp();
    }

    public int getContinuityErrors() {
        return this.continuityErrors;
    }

    public int getContinuityErrorsTotal() {
        return this.continuityErrorsTotal + this.continuityErrors;
    }

    public int getDuplicateCount() {
        return this.duplicateCount;
    }

    public int getOverwriteCount() {
        return this.overwriteCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int getAbortCount() {
        return this.abortCount;
    }

    public int getMultiple() {
        return this.multiple;
    }

    public long getLastInterval() {
        return this.lastInterval;
    }

    public Set getSources(boolean current) {
        if (!current) {
            return this.sources.keySet();
        }
        long window = 60000L;
        long now = System.currentTimeMillis();
        TreeSet<SourceCacheEntry> currentSet = new TreeSet<SourceCacheEntry>();
        Iterator iter = this.sources.keySet().iterator();
        while (iter.hasNext()) {
            SourceCacheEntry source = (SourceCacheEntry)iter.next();
            Long timeStamp = (Long)this.sources.get(source);
            if (now - timeStamp >= window) continue;
            currentSet.add(source);
        }
        return currentSet;
    }

    public boolean isExpired() {
        int avg = this.getAvgInterval();
        return this.isExpired(2000L + (avg == -1 ? this.expectedInterval : (long)avg));
    }

    public boolean isExpired(long maxAge) {
        return this.getAge() > maxAge;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public boolean update(CamdNetMessage newRequest, CamdNetMessage newReply, SourceCacheEntry source) {
        long now = System.currentTimeMillis();
        this.sources.put(source, new Long(now));
        if (newReply == null || newReply.isEmpty()) {
            ++this.abortCount;
            ++source.abortCount;
            return false;
        }
        ++this.updateCount;
        ++source.updateCount;
        if (this.backLog.containsKey((Object)newRequest) && !newReply.equals(this.backLog.get((Object)newRequest))) {
            ++this.overwriteCount;
            source.reportOverWrite(this, newRequest, (CamdNetMessage)this.backLog.get((Object)newRequest), newReply);
            return false;
        }
        if (this.backLog.containsKey((Object)newRequest)) {
            ++this.duplicateCount;
            source.reportDuplicate(this, newRequest, (CamdNetMessage)this.backLog.get((Object)newRequest));
            return false;
        }
        if (this.reply != null) {
            if (ServiceCacheEntry.isOverlapping(this.reply.getCustomData(), newReply.getCustomData())) {
                this.setLastInterval(newRequest.getTimeStamp() - this.request.getTimeStamp());
                this.multiple = 0;
                ++this.continuityCount;
            } else {
                int index = this.findOverlapInBacklog(newReply);
                if (index == -1) {
                    if (this.getAge() > 60000L) {
                        this.resetContinuityErrors();
                    } else {
                        ++this.continuityErrors;
                    }
                    this.continuityCount = 0;
                } else {
                    if (index > this.multiple && this.continuityErrors > 0) {
                        --this.continuityErrors;
                    }
                    this.multiple = index;
                    ++this.continuityCount;
                }
            }
        }
        if ((long)this.continuityCount * this.expectedInterval > 3600000L) {
            if (this.continuityErrors > 0) {
                this.resetContinuityErrors();
            }
            this.continuityCount = 0;
        }
        this.request = newRequest;
        this.reply = newReply;
        this.backLog.put((Object)newRequest, (Object)newReply);
        if (this.multiple == 0) {
            if (this.parent.windowStart == 0L || now - this.parent.windowStart > this.expectedInterval) {
                this.timeOffset = 0L;
                this.parent.windowStart = now;
            } else {
                this.timeOffset = now - this.parent.windowStart;
            }
        } else {
            this.timeOffset = -1L;
        }
        return true;
    }

    private void resetContinuityErrors() {
        this.continuityErrorsTotal += this.continuityErrors;
        this.continuityErrors = 0;
    }

    private int findOverlapInBacklog(CamdNetMessage newReply) {
        long now = System.currentTimeMillis();
        CamdNetMessage[] oldReplies = this.backLog.values().toArray(new CamdNetMessage[this.backLog.size()]);
        for (int i = 0; i < oldReplies.length; ++i) {
            if ((double)(now - oldReplies[i].getTimeStamp()) > (double)this.expectedInterval * 1.4 || !ServiceCacheEntry.isOverlapping(oldReplies[i].getCustomData(), newReply.getCustomData())) continue;
            long interval = newReply.getTimeStamp() - oldReplies[i].getTimeStamp();
            if (Math.abs(this.expectedInterval - interval) < 2000L) {
                this.setLastInterval(interval);
            }
            return oldReplies.length - i;
        }
        return -1;
    }

    public void setLastInterval(long interval) {
        this.lastInterval = interval;
        this.intervals.addRecord((int)this.lastInterval);
        this.variances.addRecord((int)Math.abs(this.expectedInterval - this.lastInterval));
    }

    public int getAvgInterval() {
        return this.intervals.getAverage(true);
    }

    public int getAvgVariance() {
        return this.variances.getAverage(true);
    }

    public Map getBackLog() {
        return this.backLog;
    }

    public static boolean isOverlapping(byte[] reply, byte[] other) {
        byte[] cw1 = new byte[8];
        byte[] cw2 = new byte[8];
        byte[] cw3 = new byte[8];
        byte[] cw4 = new byte[8];
        System.arraycopy(reply, 0, cw1, 0, 8);
        System.arraycopy(reply, 8, cw2, 0, 8);
        System.arraycopy(other, 0, cw3, 0, 8);
        System.arraycopy(other, 8, cw4, 0, 8);
        return Arrays.equals(cw1, cw3) || Arrays.equals(cw2, cw4);
    }

    public String toString() {
        return this.ts.getName() + ":" + this.getAvgInterval() + ":" + this.getAge() + ":" + this.continuityErrors;
    }

    public int compareTo(Object o) {
        return this.ts.toString().compareTo(((ServiceCacheEntry)o).ts.toString());
    }
}

