/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.util.ProxyLogger;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class NewcamdConnection {
    private int sequenceNr = 0;
    private int maxSize = 240;
    private Socket conn;
    private DataInputStream is;
    private BufferedOutputStream os;
    private byte[] desKey16;
    private long lastTrafficTimeStamp = System.currentTimeMillis();
    private CamdNetMessage lastSent;
    private CamdNetMessage lastRead;
    private boolean noEncrypt = false;
    private boolean logDupes = false;
    private ProxyLogger logger;
    private String traceLabel;

    public NewcamdConnection(Socket conn, boolean noEncrypt, boolean logDupes) {
        this(conn, noEncrypt, logDupes, null);
    }

    private NewcamdConnection(Socket conn, boolean noEncrypt, boolean logDupes, String traceLabel) {
        this.conn = conn;
        this.noEncrypt = noEncrypt;
        this.logDupes = logDupes;
        this.traceLabel = traceLabel;
    }

    public void setDesKey16(byte[] desKey16) {
        this.desKey16 = desKey16;
    }

    public void init(ProxyLogger logger) throws IOException {
        this.logger = logger;
        if (this.noEncrypt) {
            logger.warning("Newcamd protocol encryption is disabled.");
        }
        this.is = new DataInputStream(this.conn.getInputStream());
        this.os = new BufferedOutputStream(this.conn.getOutputStream());
    }

    public void clientHandshake(int timeout, byte[] configKey14) throws IOException {
        this.os.write(this.generateLoginKey(configKey14));
        this.os.flush();
        this.conn.setSoTimeout(timeout);
    }

    public void serverHandshake(byte[] configKey14) throws IOException {
        byte[] random14 = new byte[14];
        this.is.readFully(random14);
        this.desKey16 = DESUtil.desKeySpread(DESUtil.xorKey(configKey14, random14));
        this.logger.finest("Read random 14: " + DESUtil.bytesToString(random14));
        this.logger.finest("Des key spread: " + DESUtil.bytesToString(this.desKey16));
    }

    private byte[] generateLoginKey(byte[] configKey14) {
        byte[] random = DESUtil.getRandomBytes(14);
        this.desKey16 = DESUtil.desKeySpread(DESUtil.xorKey(configKey14, random));
        return random;
    }

    public CamdNetMessage readMessage() throws IOException {
        if (this.is == null) {
            return null;
        }
        int len = this.is.read();
        if (len == -1) {
            this.close();
            return null;
        }
        len *= 256;
        this.logger.finest("Incoming message length: " + (len += this.is.read()) + " bytes");
        if (len < 0 || len > this.maxSize) {
            throw new IOException("Bad length: " + len);
        }
        byte[] data = new byte[len];
        this.is.readFully(data);
        byte[] decrypted = this.noEncrypt ? data : DESUtil.desDecrypt(data, len, this.desKey16);
        if (decrypted == null) {
            throw new IOException("Decryption failed, bad checksum.");
        }
        CamdNetMessage msg = CamdNetMessage.parseNewcamd(decrypted, this.getRemoteAddress());
        this.logger.finer("Received message: " + msg.toString());
        this.logger.finest("Decrypted message payload (" + decrypted.length + " bytes) -> " + DESUtil.bytesToString(decrypted));
        if (this.traceLabel != null) {
            System.out.println("Recv [" + this.traceLabel + "] " + DESUtil.bytesToString(decrypted));
        }
        this.lastTrafficTimeStamp = System.currentTimeMillis();
        if (this.logDupes && this.lastRead != null && this.lastRead.getSequenceNr() != 0 && this.lastRead.getSequenceNr() == msg.getSequenceNr() && this.lastRead.isEcm() && msg.isEcm()) {
            long time = msg.getTimeStamp() - this.lastRead.getTimeStamp();
            this.logger.warning("Duplicate newcamd message received.\n " + time + "\tPrevious: " + this.lastRead + "\n\tCurrent:  " + msg);
        }
        this.lastRead = msg;
        return msg;
    }

    public int sendMessage(CamdNetMessage msg) {
        return this.sendMessage(msg, -1, true);
    }

    public synchronized int sendMessage(CamdNetMessage msg, int seq, boolean flush) {
        byte[] encrypted;
        if (this.logger == null || this.desKey16 == null) {
            return -1;
        }
        if (seq == -1) {
            seq = this.sequenceNr++;
        }
        msg.setSequenceNr(seq);
        this.logger.finer("Sending message " + msg.hashCodeStr() + ": " + msg.toString());
        if (this.sequenceNr > 65535) {
            this.sequenceNr = 0;
        }
        byte[] fixedData = msg.getFixedData();
        byte[] customData = msg.getCustomData();
        byte[] buffer = new byte[13 + customData.length];
        System.arraycopy(fixedData, 0, buffer, 0, 10);
        buffer[10] = (byte)msg.getCommandTag();
        buffer[11] = (byte)(customData.length >> 8);
        buffer[11] = (byte)(buffer[11] | msg.getUpperBits());
        buffer[12] = (byte)(customData.length & 0xFF);
        System.arraycopy(customData, 0, buffer, 13, customData.length);
        this.logger.finest("Assembled message (" + buffer.length + " bytes) -> " + DESUtil.bytesToString(buffer));
        if (this.traceLabel != null) {
            System.out.println("Sent [" + this.traceLabel + "] " + DESUtil.bytesToString(buffer));
        }
        if (this.noEncrypt) {
            encrypted = buffer;
        } else {
            encrypted = DESUtil.desEncrypt(buffer, buffer.length, this.desKey16, this.maxSize);
            this.logger.finest("Encrypted message (" + encrypted.length + " bytes) -> " + DESUtil.bytesToString(encrypted));
        }
        try {
            this.os.write(encrypted.length >> 8);
            this.os.write(encrypted.length & 0xFF);
            this.os.write(encrypted);
            if (flush) {
                this.os.flush();
                this.lastTrafficTimeStamp = System.currentTimeMillis();
            }
            msg.setSent(this.getRemoteAddress(), buffer, "Newcamd");
            if (this.logDupes && this.lastSent != null && this.lastSent.getSequenceNr() != 0 && this.lastSent.getSequenceNr() == seq && this.lastSent.isEcm() && msg.isEcm()) {
                long time = msg.getTimeStamp() - this.lastSent.getTimeStamp();
                this.logger.warning("Duplicate newcamd message sent.\n " + time + "\tPrevious: " + this.lastSent + "\n\tCurrent:  " + msg);
            }
            this.lastSent = msg;
            return seq;
        }
        catch (IOException e) {
            this.logger.throwing("Connection closed while sending", e);
            this.close();
            return -1;
        }
    }

    public int sendMessage(CamdNetMessage msg, int seq, byte[] desKey16) {
        seq = this.sendMessage(msg, seq, false);
        this.desKey16 = desKey16;
        try {
            this.os.flush();
            this.lastTrafficTimeStamp = System.currentTimeMillis();
            return seq;
        }
        catch (IOException e) {
            this.logger.throwing("Connection closed while sending", e);
            this.close();
            return -1;
        }
    }

    public void close() {
        block3: {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
                this.conn = null;
            }
            catch (IOException e) {
                if (this.logger == null) break block3;
                this.logger.throwing("Exception while closing", e);
            }
        }
    }

    public boolean isConnected() {
        return this.conn != null;
    }

    public boolean isInitialized() {
        return this.logger != null;
    }

    public long getLastTrafficTimeStamp() {
        return this.lastTrafficTimeStamp;
    }

    public synchronized String getRemoteAddress() {
        if (this.isConnected()) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return "0.0.0.0";
    }

    public void setSoTimeout(int soTimeout) throws SocketException {
        if (this.isConnected()) {
            this.conn.setSoTimeout(soTimeout);
        }
    }

    public void setSequenceNr(int sequenceNr) {
        this.sequenceNr = sequenceNr;
    }

    public void setLogger(ProxyLogger logger) {
        this.logger = logger;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setTraceLabel(String traceLabel) {
        this.traceLabel = traceLabel;
    }
}

