/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.rmi.AbstractStatus;
import java.io.Serializable;
import java.util.Properties;

public class CwsStatus
extends AbstractStatus
implements Serializable {
    private static final long serialVersionUID = -1540786884183518436L;
    public static final int CWS_DISCONNECTED = 0;
    public static final int CWS_CONNECTED = 1;
    public static final int CWS_CONNECTING = 2;
    public static final int CWS_UNRESPONSIVE = 4;
    public static final int CWS_DISABLED = 5;
    private final String name;
    private final String profileName;
    private final String protocol;
    private String remoteHost;
    private String remoteUser;
    private String cardData1;
    private String cardData2;
    private String providerIdents;
    private int status;
    private final int metric;
    private final int sendQ;
    private final int utilization;
    private final int avgUtilization;
    private final int ecmCount;
    private final int ecmLoad;
    private final int emmCount;
    private final int timeoutCount;
    private final int capacity;
    private long connectTimeStamp;
    private long currentTime;
    private long averageTime;
    private long nextAttemptTimeStamp;
    private long disconnectTimeStamp;
    private int[] recentSids;

    public CwsStatus(CwsConnector cws) {
        this.name = cws.getName();
        if (cws.getRemoteInfo() != null) {
            this.setProperties(cws.getRemoteInfo());
        }
        this.profileName = cws.getProfileName();
        this.metric = cws.getMetric();
        this.sendQ = cws.getQueueSize();
        this.utilization = cws.getUtilization(false);
        this.avgUtilization = cws.getUtilization(true);
        this.capacity = cws.getCapacity();
        this.ecmCount = cws.getEcmCount(true);
        this.ecmLoad = cws.getEcmCount(false);
        this.emmCount = cws.getEmmCount();
        this.timeoutCount = cws.getTotalFailures();
        this.protocol = cws.getProtocol();
        this.providerIdents = ProxyConfig.providerIdentsToString(cws.getProviderIdents());
        if (!cws.isEnabled()) {
            this.status = 5;
        } else if (cws.isReady()) {
            this.status = 1;
            this.remoteHost = cws.getRemoteAddress();
            this.remoteUser = cws.getUser();
            if (cws.getRemoteCard() != null && "Newcamd".equals(cws.getProtocol())) {
                this.cardData1 = cws.getRemoteCard().toString();
                this.cardData2 = !cws.getRemoteCard().isAnonymous() ? cws.getRemoteCard().getCardNumber() + " (" + cws.getRemoteCard().getProvIdsStr() + ")" : null;
            }
            this.connectTimeStamp = cws.getConnectTimeStamp();
            this.currentTime = cws.getCurrentEcmTime();
            this.averageTime = cws.getAverageEcmTime();
            this.recentSids = cws.getRecentSids();
            if (cws.getTimeoutCount() > 0) {
                this.status = 4;
            }
        } else if (cws.isConnecting()) {
            this.status = 2;
        } else {
            this.nextAttemptTimeStamp = ProxyConfig.getInstance().getConnManager().getNextConnectAttempt(this.name);
            this.disconnectTimeStamp = cws.getLastDisconnectTimeStamp();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public int getMetric() {
        return this.metric;
    }

    public int getSendQ() {
        return this.sendQ;
    }

    public int getEcmCount() {
        return this.ecmCount;
    }

    public int getEcmLoad() {
        return this.ecmLoad;
    }

    public int[] getRecentSids() {
        return this.recentSids;
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public int getTimeoutCount() {
        return this.timeoutCount;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public int getStatus() {
        return this.status;
    }

    public long getConnectTimeStamp() {
        return this.connectTimeStamp;
    }

    public long getNextAttemptTimeStamp() {
        return this.nextAttemptTimeStamp;
    }

    public long getDisconnectTimeStamp() {
        return this.disconnectTimeStamp;
    }

    public long getCurrentEcmTime() {
        return this.currentTime;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getAverageEcmTime() {
        return this.averageTime;
    }

    public int getUtilization() {
        return this.utilization;
    }

    public int getAvgUtilization() {
        return this.avgUtilization;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getCardData1() {
        return this.cardData1;
    }

    public String getCardData2() {
        return this.cardData2;
    }

    public Properties getRemoteInfo() {
        return this.data;
    }

    public String getProviderIdents() {
        return this.providerIdents;
    }
}

