/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.rmi.AbstractStatus;
import com.bowman.cardserv.tv.TvService;
import java.io.Serializable;

public class SessionStatus
extends AbstractStatus
implements Serializable {
    private final long connectTimeStamp;
    private final long lastZapTimeStamp;
    private final long idleTime;
    private final int ecmCount;
    private final int emmCount;
    private final int msgCount;
    private final int avgEcmInterval;
    private final int lastTransactionTime;
    private final int pendingCount;
    private final int sessionId;
    private final int kaCount;
    private final String remoteHost;
    private final String profileName;
    private final String clientId;
    private final String protocol;
    private final String flags;
    private final String context;
    private final TvService currentService;
    private final TvService lastService;
    private final boolean active;
    private final int maxSessions;

    public SessionStatus(ProxySession session) {
        this.active = session.isActive();
        this.connectTimeStamp = session.getConnectTimeStamp();
        this.currentService = session.getCurrentService();
        this.lastService = session.getLastTransactionService();
        this.remoteHost = session.getRemoteAddress();
        this.profileName = session.getProfileName();
        this.clientId = session.getClientId();
        this.protocol = session.getProtocol();
        this.emmCount = session.getEmmCount();
        this.ecmCount = session.getEcmCount();
        this.msgCount = session.getMsgCount();
        this.maxSessions = session.getMaxSessions();
        this.kaCount = session.getKeepAliveCount();
        this.pendingCount = session.getPendingCount();
        this.sessionId = session.getId();
        this.avgEcmInterval = session.getAverageEcmInterval();
        this.lastTransactionTime = session.getLastTransactionTime();
        this.lastZapTimeStamp = session.getLastZapTimeStamp();
        this.idleTime = session.getIdleTime();
        this.flags = session.getLastTransactionFlags();
        this.context = session.getLastContext();
    }

    public boolean isActive() {
        return this.active;
    }

    public long getConnectTimeStamp() {
        return this.connectTimeStamp;
    }

    public int getEcmCount() {
        return this.ecmCount;
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public int getPendingCount() {
        return this.pendingCount;
    }

    public int getKaCount() {
        return this.kaCount;
    }

    public int getAvgEcmInterval() {
        return this.avgEcmInterval;
    }

    public int getLastTransactionTime() {
        return this.lastTransactionTime;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public TvService getCurrentService() {
        return this.currentService;
    }

    public TvService getLastService() {
        return this.lastService;
    }

    public long getLastZapTimeStamp() {
        return this.lastZapTimeStamp;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String getContext() {
        return this.context;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }
}

