/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ProxyXmlTracer {
    private Map nodes = new TreeMap();

    public ProxyXmlTracer() {
        try {
            new CtrlCommand("dump", "Dump trace", "Write gathered trace data to file.").register(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void trace(String node, String name, Object def, String typeInfo, StackTraceElement caller) {
        String sourceClass = caller == null ? "<unknown>" : ProxyXmlTracer.stripClassName(caller.getClassName());
        String sourceMethod = caller == null ? "<unknown>" : caller.getMethodName();
        sourceMethod = sourceMethod + "(" + caller.getFileName() + ":" + caller.getLineNumber() + ")";
        Set<String> values = new TreeSet();
        if (this.nodes.containsKey(node)) {
            values = (Set)this.nodes.get(node);
        } else {
            this.nodes.put(node, values);
        }
        if (name != null) {
            StringBuffer value = new StringBuffer(name);
            value.append("\n\t\ttype: ").append(typeInfo);
            if (def != null) {
                value.append("\n\t\tdefault: '").append(def).append("'");
            }
            value.append("\n\t\tcaller: ").append(sourceClass).append('.').append(sourceMethod);
            values.add(value.toString());
        }
    }

    private static String stripClassName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public void dump() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter("etc/xmlcfg.txt"));
        Iterator iter = this.nodes.keySet().iterator();
        while (iter.hasNext()) {
            String node = (String)iter.next();
            pw.println("\n" + node);
            Iterator i = ((Set)this.nodes.get(node)).iterator();
            while (i.hasNext()) {
                pw.println("\t" + i.next());
            }
        }
        pw.close();
    }

    public CtrlCommandResult runCtrlCmdDump() {
        try {
            this.dump();
            return new CtrlCommandResult(true, "Dump written to file (etc/xmlcfg.txt)");
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CtrlCommandResult(false, "Dump failed: " + e);
        }
    }
}

