/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.Command;
import com.bowman.cardserv.web.CtrlCommandResult;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class CtrlCommand
extends Command {
    boolean confirm;

    public static CtrlCommand createFromXml(ProxyXmlConfig def) throws ConfigException {
        boolean confirm = "true".equalsIgnoreCase(def.getStringValue("confirm", "false"));
        CtrlCommand cmd = new CtrlCommand(def.getStringValue("name"), def.getStringValue("label"), def.getStringValue("description"), confirm);
        Iterator iter = def.getMultipleSubConfigs("command-param");
        if (iter != null) {
            while (iter.hasNext()) {
                def = (ProxyXmlConfig)iter.next();
                Command.CommandParam prm = cmd.addParam(def.getStringValue("name"), def.getStringValue("label"));
                Iterator opts = def.getMultipleSubConfigs("option");
                if (opts == null) continue;
                ArrayList<String> options = new ArrayList<String>();
                while (opts.hasNext()) {
                    ProxyXmlConfig opt = (ProxyXmlConfig)opts.next();
                    try {
                        options.add(opt.getStringValue("value"));
                    }
                    catch (ConfigException e) {
                        // empty catch block
                    }
                    try {
                        options.add(opt.getStringValue("source"));
                    }
                    catch (ConfigException e) {}
                }
                prm.setOptions(options, "true".equalsIgnoreCase(def.getStringValue("allow-arbitrary", "false")));
            }
        }
        return cmd;
    }

    public CtrlCommand(String name, String label, String description, boolean confirm) {
        super(name, label, description);
        this.confirm = confirm;
    }

    public CtrlCommand(String name, String label, String description) {
        this(name, label, description, false);
    }

    public void register(Object handler, String label, boolean override) throws NoSuchMethodException {
        this.handler = handler;
        this.groupLabel = label == null ? this.getHandlerName() : label;
        String methodName = CtrlCommand.methodifyName(this.name, "runCtrlCmd");
        try {
            this.method = handler.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException e) {
            try {
                this.method = handler.getClass().getMethod(methodName, Map.class);
            }
            catch (NoSuchMethodException ex) {
                this.method = handler.getClass().getMethod(methodName, Map.class, String.class);
            }
        }
        if (CtrlCommandResult.class != this.method.getReturnType()) {
            throw new NoSuchMethodException("Method '" + methodName + "' has wrong return type (should return CtrlCommandResult)");
        }
        if (manager == null) {
            commands.add(this);
        } else {
            manager.registerCommand(this, override);
        }
    }

    public CtrlCommandResult invoke(Map params, String user) throws RemoteException {
        if (this.override != null) {
            return ((CtrlCommand)this.override).invoke(params, user);
        }
        try {
            if (this.method.getParameterTypes().length == 0) {
                return (CtrlCommandResult)this.method.invoke(this.handler, null);
            }
            if (this.method.getParameterTypes().length == 1) {
                return (CtrlCommandResult)this.method.invoke(this.handler, params);
            }
            return (CtrlCommandResult)this.method.invoke(this.handler, params, user);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RemoteException) {
                throw (RemoteException)e.getCause();
            }
            throw new RemoteException("Uncaught exception in runCtrlCmdMethod", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RemoteException("No access to runCtrlCmdMethod (" + this.method + ")", e);
        }
    }
}

