/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.Command;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class StatusCommand
extends Command {
    boolean adminOnly;

    public static StatusCommand createFromXml(ProxyXmlConfig def) throws ConfigException {
        boolean adminOnly = "true".equalsIgnoreCase(def.getStringValue("admin-only", "false"));
        StatusCommand cmd = new StatusCommand(def.getStringValue("name"), def.getStringValue("label"), def.getStringValue("description"), adminOnly);
        Iterator iter = def.getMultipleSubConfigs("command-param");
        if (iter != null) {
            while (iter.hasNext()) {
                def = (ProxyXmlConfig)iter.next();
                Command.CommandParam prm = cmd.addParam(def.getStringValue("name"), def.getStringValue("label"));
                prm.adminOnly = "true".equals(def.getStringValue("admin-only", "false"));
                prm.optional = "true".equals(def.getStringValue("optional", "true"));
                Iterator opts = def.getMultipleSubConfigs("option");
                if (opts == null) continue;
                ArrayList<String> options = new ArrayList<String>();
                while (opts.hasNext()) {
                    ProxyXmlConfig opt = (ProxyXmlConfig)opts.next();
                    try {
                        options.add(opt.getStringValue("value"));
                    }
                    catch (ConfigException e) {
                        // empty catch block
                    }
                    try {
                        options.add(opt.getStringValue("source"));
                    }
                    catch (ConfigException e) {}
                }
                prm.setOptions(options, true);
            }
        }
        return cmd;
    }

    public StatusCommand(String name, String label, String description, boolean adminOnly) {
        super(name, label, description);
        this.adminOnly = adminOnly;
    }

    public void register(Object handler, String label, boolean override) throws NoSuchMethodException {
        this.handler = handler;
        this.groupLabel = label == null ? this.getHandlerName() : label;
        String methodName = StatusCommand.methodifyName(this.name, "runStatusCmd");
        try {
            this.method = handler.getClass().getMethod(methodName, XmlStringBuffer.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.method = handler.getClass().getMethod(methodName, XmlStringBuffer.class, Map.class);
            }
            catch (NoSuchMethodException ex) {
                this.method = handler.getClass().getMethod(methodName, XmlStringBuffer.class, Map.class, String.class);
            }
        }
        if (manager == null) {
            commands.add(this);
        } else {
            manager.registerCommand(this, override);
        }
    }

    public void invoke(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (this.override != null) {
            ((StatusCommand)this.override).invoke(xb, params, user);
        } else {
            try {
                if (this.method.getParameterTypes().length == 1) {
                    this.method.invoke(this.handler, xb);
                } else if (this.method.getParameterTypes().length == 2) {
                    this.method.invoke(this.handler, xb, params);
                } else {
                    this.method.invoke(this.handler, xb, params, user);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RemoteException) {
                    throw (RemoteException)e.getCause();
                }
                throw new RemoteException("Uncaught exception in runStatusCmdMethod", e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RemoteException("No access to runStatusCmdMethod (" + this.method + ")", e);
            }
        }
    }
}

