<?php
// ============================================================
// INSTALADOR BLINDADO - CRIA, PREPARA E CORRIGE (TUDO EM UM)
// ============================================================
require_once 'conexao.php';
@set_time_limit(0);

echo "<body style='background:#151521; color:#fff; font-family:sans-serif; padding:20px;'>";
echo "<h2>🛡️ Instalador Blindado do Painel</h2><hr>";

// --- FUNÇÃO PARA EXECUTAR SQL SEM TRAVAR ---
function rodar($db, $sql) {
    try { $db->exec($sql); } catch (Exception $e) {}
}

// ------------------------------------------------------------
// FASE 1: CRIAR ESTRUTURA BÁSICA (PREVINE ERRO DE TABELA INEXISTENTE)
// ------------------------------------------------------------
echo "<h3>1. Verificando Tabelas Principais...</h3>";

// Se a tabela USUARIO não existir, criamos ela com colunas "Coringa" para aceitar qualquer backup
$checkUser = $connUser->query("SHOW TABLES LIKE 'usuario'")->rowCount();

if ($checkUser == 0) {
    echo "⚠️ Tabela 'usuario' não existia. Criando estrutura compatível...<br>";
    $sql_cria_user = "CREATE TABLE `usuario` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `usuario` varchar(255) DEFAULT NULL,
      `senha` varchar(255) DEFAULT NULL,
      `data_premio` date DEFAULT NULL,
      `id_perfil` int(11) DEFAULT 1,
      `dono` varchar(100) DEFAULT 'admin',
      `vencimento` varchar(100) DEFAULT NULL,
      `expire_date` varchar(100) DEFAULT NULL,
      `exp_date` varchar(100) DEFAULT NULL,
      `validade` varchar(100) DEFAULT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";
    rodar($connUser, $sql_cria_user);
} else {
    // Se já existe, adicionamos as colunas de "armadilha" para segurar os dados
    $cols = ['vencimento', 'expire_date', 'exp_date', 'validade', 'data_validade', 'data_premio', 'id_perfil', 'dono', 'limite'];
    foreach ($cols as $c) {
        rodar($connUser, "ALTER TABLE usuario ADD COLUMN IF NOT EXISTS `$c` VARCHAR(255) DEFAULT NULL");
    }
}

// Garante tabelas secundárias
rodar($connUser, "CREATE TABLE IF NOT EXISTS rev (id INT AUTO_INCREMENT PRIMARY KEY, login VARCHAR(255), senha VARCHAR(255), dono VARCHAR(100) DEFAULT 'admin')");
echo "<div style='color:#28c76f'>✔ Tabela de Usuários pronta para importação.</div>";


// ------------------------------------------------------------
// FASE 2: CRIAR TABELAS DO SISTEMA (PAGAMENTO, EMAIL, ETC)
// ------------------------------------------------------------
echo "<h3>2. Instalando Módulos do Sistema...</h3>";

$sqls_sistema = [
    // PAGAMENTOS
    "CREATE TABLE IF NOT EXISTS configuracoes_pagamento (id INT AUTO_INCREMENT PRIMARY KEY, access_token VARCHAR(255), public_key VARCHAR(255), client_id VARCHAR(255), client_secret VARCHAR(255), usuario_painel VARCHAR(100) DEFAULT 'admin', valor_padrao DECIMAL(10,2) DEFAULT 30.00, tipo VARCHAR(50) DEFAULT 'mercadopago', ativo INT(1) DEFAULT 1)",
    "ALTER TABLE configuracoes_pagamento ADD COLUMN IF NOT EXISTS usuario_painel VARCHAR(100) DEFAULT 'admin'",

    // EMAILS E SMTP
    "CREATE TABLE IF NOT EXISTS email_modelo (id INT AUTO_INCREMENT PRIMARY KEY, tipo VARCHAR(50), assunto VARCHAR(255), mensagem TEXT, dono VARCHAR(100) DEFAULT 'admin', ativo INT(1) DEFAULT 1)",
    "CREATE TABLE IF NOT EXISTS smtp_config (id INT AUTO_INCREMENT PRIMARY KEY, host VARCHAR(255) DEFAULT 'smtp.gmail.com', email VARCHAR(255), senha VARCHAR(255), porta VARCHAR(10) DEFAULT '587', dono VARCHAR(100) DEFAULT 'admin')",
    
    // BACKUPS
    "CREATE TABLE IF NOT EXISTS arquivo_backup (id INT AUTO_INCREMENT PRIMARY KEY, tipo VARCHAR(50), local VARCHAR(255), data DATETIME DEFAULT CURRENT_TIMESTAMP, size VARCHAR(50), link_externo VARCHAR(255))",
    "ALTER TABLE arquivo_backup ADD COLUMN IF NOT EXISTS link_externo VARCHAR(255) DEFAULT NULL",

    // PERFIS DE REVENDA
    "CREATE TABLE IF NOT EXISTS rev_perfil (id INT AUTO_INCREMENT PRIMARY KEY, id_rev INT, id_perfil INT, valor_custo DECIMAL(10,2) DEFAULT 0.00)"
];

foreach ($sqls_sistema as $sql) {
    rodar($connUser, $sql); // Tenta no User
    rodar($connGeral, $sql); // Tenta no Geral (por garantia)
}
echo "<div style='color:#28c76f'>✔ Tabelas de Configuração criadas.</div>";


// ------------------------------------------------------------
// FASE 3: CORREÇÃO DE DADOS (PÓS-IMPORTAÇÃO)
// ------------------------------------------------------------
echo "<h3>3. Verificando Dados Importados...</h3>";

$qtd = $connUser->query("SELECT count(*) FROM usuario")->fetchColumn();

if ($qtd == 0) {
    echo "<div style='background:#ff9f43; padding:15px; border-radius:5px; color:#000;'>";
    echo "<b>⏳ AGUARDANDO IMPORTAÇÃO...</b><br>";
    echo "O banco está vazio e pronto. <b>Vá no phpMyAdmin e importe seu SQL agora.</b><br>";
    echo "Assim que terminar, <b>ATUALIZE ESTA PÁGINA</b> para as datas serem corrigidas.";
    echo "</div>";
} else {
    echo "<p>Encontrados <b>$qtd</b> clientes. Iniciando correções...</p>";
    $fix = 0;

    // 1. CONVERTE DATAS (Procura em todas as colunas possíveis)
    $colunas_busca = ['vencimento', 'expire_date', 'exp_date', 'validade', 'data_validade'];
    foreach ($colunas_busca as $col) {
        // Tenta Unix (Número)
        $r1 = $connUser->exec("UPDATE usuario SET data_premio = FROM_UNIXTIME(`$col`, '%Y-%m-%d') WHERE `$col` > 1000000 AND (`$col` NOT LIKE '%/%') AND (data_premio IS NULL OR data_premio < '2020-01-01')");
        // Tenta Texto BR (dd/mm/aaaa)
        $r2 = $connUser->exec("UPDATE usuario SET data_premio = STR_TO_DATE(`$col`, '%d/%m/%Y') WHERE `$col` LIKE '%/%/%' AND (data_premio IS NULL OR data_premio < '2020-01-01')");
        $fix += ($r1 + $r2);
    }

    // 2. CORREÇÃO DE PERFIS E DONO
    rodar($connUser, "UPDATE usuario SET id_perfil = 1 WHERE id_perfil IS NULL OR id_perfil = 0");
    rodar($connUser, "UPDATE usuario SET dono = 'admin' WHERE dono IS NULL OR dono = ''");
    rodar($connUser, "UPDATE rev SET dono = 'admin' WHERE dono IS NULL OR dono = ''");

    // 3. ULTIMO RECURSO (30 Dias apenas para quem ficou zerado)
    $fallback = $connUser->exec("UPDATE usuario SET data_premio = DATE_ADD(CURDATE(), INTERVAL 30 DAY) WHERE data_premio IS NULL OR data_premio < '2020-01-01'");

    echo "<div style='background:#28c76f; padding:15px; border-radius:5px;'>";
    echo "✅ <b>PAINEL INSTALADO E CORRIGIDO!</b><br>";
    echo "• Datas Reais Recuperadas: <b>$fix</b><br>";
    echo "• Clientes Sem Data (Ganharam 30 dias): <b>$fallback</b><br>";
    echo "• Sistema de Pagamento e Email: <b>Ativado</b>";
    echo "</div>";
    
    echo "<br><center><a href='index.php' style='background:#7367f0; color:#fff; padding:15px 30px; text-decoration:none; border-radius:5px; font-weight:bold;'>ACESSAR PAINEL</a></center>";
}
?>
