<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste Automático</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <?php
    include 'conexao.php';
    // Puxa cor e nome do banco para o estilo
    $nomePainel = "IPTV PANEL"; $corPrimaria = "#7367f0"; 
    try {
        $conf = $connGeral->query("SELECT NomePainel, TemaPainel FROM site_config LIMIT 1")->fetch(PDO::FETCH_ASSOC);
        if ($conf) {
            if (!empty($conf['NomePainel'])) $nomePainel = $conf['NomePainel'];
            if (!empty($conf['TemaPainel'])) $corPrimaria = $conf['TemaPainel'];
        }
    } catch (Exception $e) { }
    ?>
    <style>
        :root { --primary: <?= $corPrimaria ?>; }
        body { background: linear-gradient(135deg, #0f0c29, #302b63, #24243e); color: #fff; min-height: 100vh; display: flex; align-items: center; justify-content: center; font-family: 'Segoe UI', sans-serif; padding: 20px; }
        .card-teste { background: rgba(25, 25, 35, 0.95); border: 1px solid rgba(255,255,255,0.1); border-radius: 15px; padding: 35px; width: 100%; max-width: 480px; box-shadow: 0 0 40px rgba(0,0,0,0.6); }
        .form-control, .form-select { background: #2b2b40 !important; border: 1px solid #444 !important; color: #ffffff !important; height: 55px; font-weight: 600; }
        .form-control::placeholder { color: #ffffff !important; opacity: 0.9 !important; }
        .btn-primary { background: var(--primary); border: none; font-weight: bold; height: 55px; transition: 0.3s; width: 100%; }
        .btn-primary:hover { filter: brightness(1.2); transform: translateY(-2px); }
        .info-box { background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 10px; padding: 20px; }
        .text-resumo { color: #00cfe8; font-weight: 800; font-family: monospace; font-size: 1.2rem; }
        label { color: #ffffff !important; font-weight: 700; margin-bottom: 5px; font-size: 0.9rem; }
        .aviso-informativo { background: rgba(0, 207, 232, 0.15); border: 1px dashed #00cfe8; border-radius: 8px; padding: 15px; font-size: 0.9rem; color: #00cfe8; text-align: center; margin-bottom: 20px; }
        
        /* Estilo da caixinha de instrução de renovação */
        .box-instrucoes { background: rgba(0,0,0,0.3); border-radius: 8px; border-left: 4px solid #00cfe8; padding: 15px; margin-top: 20px; text-align: left; font-size: 0.85rem; line-height: 1.5; }
        .box-instrucoes a { color: #ffc107; font-weight: bold; text-decoration: none; word-break: break-all; }
    </style>
</head>
<body>

<div class="card-teste">
    <?php
    $link_user = 'admin'; $perfis = []; $msg = ""; $msg_tipo = ""; $dados_exibir = null;

    if (isset($_GET['r'])) {
        $link_user = preg_replace('/[^a-zA-Z0-9_]/', '', base64_decode($_GET['r']));
        $stmt_rev = $connUser->prepare("SELECT perfil FROM rev WHERE usuario = ? LIMIT 1");
        $stmt_rev->execute([$link_user]);
        $res_rev = $stmt_rev->fetch(PDO::FETCH_ASSOC);
        $perfil_rev_str = $res_rev['perfil'] ?? '';
    }

    try {
        if (!isset($_GET['r']) || empty($perfil_rev_str)) {
            $perfis = $connGeral->query("SELECT id, nome FROM perfil WHERE bloqueado != 'sim' OR bloqueado IS NULL")->fetchAll(PDO::FETCH_ASSOC);
        } else {
            $nomes = explode(',', $perfil_rev_str);
            $in = str_repeat('?,', count($nomes) - 1) . '?';
            $st_p = $connGeral->prepare("SELECT id, nome FROM perfil WHERE nome IN ($in) AND (bloqueado != 'sim' OR bloqueado IS NULL)");
            $st_p->execute($nomes); $perfis = $st_p->fetchAll(PDO::FETCH_ASSOC);
        }
    } catch (Exception $e) {}

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $nome_cli = strip_tags($_POST['nome']);
        $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
        $pid = (int)$_POST['perfil']; 
        
        $check = $connUser->prepare("SELECT id FROM teste WHERE email = ?");
        $check->execute([$email]);
        
        if ($check->rowCount() > 0) {
            $msg = "Atenção: E-mail já utilizado para teste."; $msg_tipo = "warning";
        } else {
            $p_info = $connGeral->prepare("SELECT url, porta FROM perfil WHERE id = ?");
            $p_info->execute([$pid]);
            $perfil_dados = $p_info->fetch(PDO::FETCH_ASSOC);

            $user_t = "t" . rand(1000, 9999);
            $pass_t = rand(1000, 9999);
            $venc_timestamp = strtotime("+48 hours"); 
            $venc_formatado = date('d/m/Y H:i', $venc_timestamp);

            // 1. SALVA NO BANCO
            $sql = "INSERT INTO teste (CadUser, nome, usuario, senha, data_premio, perfil, email, bloqueado, data_cadastro, conexao) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, 'nao', NOW(), 1)";
            $connUser->prepare($sql)->execute([$link_user, $nome_cli, $user_t, $pass_t, $venc_timestamp, $pid, $email]);

            // =========================================================
            // 2. DISPARO DE E-MAIL DINÂMICO (COM TEMPLATE E SMTP GMAIL)
            // =========================================================
            
            $stmtTp = $connGeral->prepare("SELECT assunto, mensagem, bloqueado FROM email_modelo WHERE tipo = 'teste' AND CadUser = ? LIMIT 1");
            $stmtTp->execute([$link_user]);
            $template = $stmtTp->fetch(PDO::FETCH_ASSOC);

            if ($template && $template['bloqueado'] === 'nao') {
                $tags = [
                    '{nome}' => $nome_cli,
                    '{login}' => $user_t,
                    '{senha}' => $pass_t,
                    '{vencimento}' => $venc_formatado,
                    '{url}' => $perfil_dados['url'],
                    '{porta}' => $perfil_dados['porta']
                ];
                
                $assunto_email = strtr($template['assunto'], $tags);
                $mensagem_texto = strtr($template['mensagem'], $tags);
                $mensagem_html = nl2br($mensagem_texto);

                $corpo_email_final = "
                <div style='background: #f4f6f9; padding: 30px; font-family: Arial, sans-serif;'>
                    <div style='background: #ffffff; padding: 30px; border-radius: 10px; border: 1px solid #ddd; max-width: 600px; margin: 0 auto; color: #333; font-size: 16px; line-height: 1.6;'>
                        {$mensagem_html}
                    </div>
                </div>";

                $stmtSmtp = $connGeral->prepare("SELECT * FROM email_adicionar WHERE CadUser = ? LIMIT 1");
                $stmtSmtp->execute([$link_user]);
                $smtp = $stmtSmtp->fetch(PDO::FETCH_ASSOC);

                $email_enviado = false;

                if ($smtp && !empty($smtp['senha'])) {
                    if (file_exists('PHPMailer/src/PHPMailer.php')) {
                        require_once 'PHPMailer/src/Exception.php';
                        require_once 'PHPMailer/src/PHPMailer.php';
                        require_once 'PHPMailer/src/SMTP.php';

                        try {
                            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
                            $mail->isSMTP();
                            $mail->Host       = $smtp['Host'];
                            $mail->SMTPAuth   = true;
                            $mail->Username   = $smtp['email'];
                            $mail->Password   = $smtp['senha'];
                            $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
                            $mail->Port       = $smtp['Port'];
                            $mail->CharSet    = 'UTF-8';

                            $mail->setFrom($smtp['email'], $nomePainel);
                            $mail->addAddress($email, $nome_cli); 

                            $stmtPref = $connUser->prepare("SELECT email_copia, receber_copia FROM usuario_pref WHERE usuario = ? LIMIT 1");
                            $stmtPref->execute([$link_user]);
                            $pref = $stmtPref->fetch(PDO::FETCH_ASSOC);
                            if ($pref && $pref['receber_copia'] === 'sim' && !empty($pref['email_copia'])) {
                                $mail->addBCC($pref['email_copia']);
                            }

                            $mail->isHTML(true);
                            $mail->Subject = $assunto_email;
                            $mail->Body    = $corpo_email_final;

                            $mail->send();
                            $email_enviado = true;
                        } catch (Exception $e) {}
                    }
                }

                if (!$email_enviado) {
                    $dominio_remetente = $_SERVER['HTTP_HOST'];
                    $from_email = ($smtp && !empty($smtp['email'])) ? $smtp['email'] : "no-reply@{$dominio_remetente}";
                    $headers = "MIME-Version: 1.0\r\nContent-type:text/html;charset=UTF-8\r\nFrom: {$nomePainel} <{$from_email}>\r\n";
                    @mail($email, $assunto_email, $corpo_email_final, $headers);
                }
            }

            $dados_exibir = ['user' => $user_t, 'pass' => $pass_t, 'venc' => $venc_formatado, 'url' => $perfil_dados['url'], 'porta' => $perfil_dados['porta']];
            $msg = "Teste Gerado com Sucesso!"; $msg_tipo = "success";
        }
    }
    ?>

    <div class="text-center mb-4">
        <i class="fas fa-tv fa-3x mb-2" style="color: var(--primary);"></i>
        <h3 class="fw-bold"><?= htmlspecialchars($nomePainel) ?></h3>
        <p class="text-white-50 small">Gerador de Teste 48horas</p>
    </div>

    <?php if($msg): ?>
        <div class="alert alert-<?= $msg_tipo ?> text-center border-0 fw-bold"><?= $msg ?></div>
        
        <?php if($dados_exibir): ?>
            <div class="info-box mb-4 shadow-lg">
                <div class="mb-2"><label>USUÁRIO:</label><div class="text-resumo"><?= $dados_exibir['user'] ?></div></div>
                <div class="mb-2"><label>SENHA:</label><div class="text-resumo"><?= $dados_exibir['pass'] ?></div></div>
                <div class="mb-2"><label>VENCIMENTO:</label><div class="text-white fw-bold"><?= $dados_exibir['venc'] ?></div></div>
                <hr class="border-secondary">
                <div class="mb-2"><label>URL / DNS:</label><div class="text-info small fw-bold"><?= $dados_exibir['url'] ?></div></div>
                <div class="mb-2"><label>PORTA:</label><div class="text-warning fw-bold"><?= $dados_exibir['porta'] ?></div></div>
                <div class="mb-0"><label>DESKEY:</label><div class="text-success fw-bold" style="word-break: break-all;">0102030405060708091011121314</div></div>
                
                <div class="box-instrucoes">
                    <span class="d-block text-info fw-bold mb-2"><i class="fas fa-sync-alt me-1"></i> COMO RENOVAR</span>
                    Acesse a Área do Cliente pelo link:<br>
                    <a href="https://cspainel.tvsbr.top/servidor/clientes" target="_blank">https://cspainel.tvsbr.top/servidor/clientes</a><br><br>
                    Entre com este mesmo <b>Usuário</b> e <b>Senha</b>. Escolha um plano, pague e o sistema renovará <b>automaticamente</b>!<br><br>
                    <span class="text-success fw-bold"><i class="fab fa-whatsapp me-1"></i> Suporte: (47) 9 8887-0797</span>
                </div>

            </div>
            
            <button class="btn btn-primary mb-2" onclick="copiarDados()"><i class="fas fa-copy me-2"></i> COPIAR DADOS</button>
            <button class="btn btn-success w-100 fw-bold" onclick="enviarWhats()"><i class="fab fa-whatsapp me-2"></i> ENVIAR WHATSAPP</button>
        <?php endif; ?>
        
    <?php else: ?>
        <form method="POST">
            <div class="mb-3"><label>Seu Nome</label><input type="text" name="nome" class="form-control" placeholder="Ex: João Silva" required></div>
            <div class="mb-3"><label>Seu E-mail (Onde receberá o teste)</label><input type="email" name="email" class="form-control" placeholder="Ex: joao@email.com" required></div>
            <div class="mb-4"><label>Perfil da Operadora</label>
                <select name="perfil" class="form-select" required>
                    <?php if(empty($perfis)): ?><option value="">Indisponível</option><?php else: ?>
                    <option value="" selected disabled>Escolha a Operadora...</option>
                    <?php foreach($perfis as $p): ?><option value="<?= $p['id'] ?>"><?= $p['nome'] ?></option><?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </div>
            <div class="aviso-informativo">
                <i class="fas fa-info-circle me-1"></i> Os dados serão enviados para o seu e-mail e também exibidos na tela.
            </div>
            <button type="submit" class="btn btn-primary fw-bold" <?= empty($perfis)?'disabled':'' ?>>GERAR MEU ACESSO</button>
        </form>
    <?php endif; ?>
</div>

<script>
    // Função unificada para gerar o texto completo para Copiar e enviar pro WhatsApp
    function getMensagemFormatada() {
        return `🚀 *ACESSO GERADO - TESTE 48H*\n\n` +
               `👤 *Usuário:* <?= $dados_exibir['user'] ?? '' ?>\n` +
               `🔑 *Senha:* <?= $dados_exibir['pass'] ?? '' ?>\n` +
               `📅 *Vence em:* <?= $dados_exibir['venc'] ?? '' ?>\n\n` +
               `🌐 *URL/DNS:* <?= $dados_exibir['url'] ?? '' ?>\n` +
               `🔌 *Porta:* <?= $dados_exibir['porta'] ?? '' ?>\n` +
               `🔐 *DESKEY:* 0102030405060708091011121314\n\n` +
               `🔄 *COMO RENOVAR SEU ACESSO:*\n` +
               `Acesse nossa Área do Cliente pelo link abaixo:\n` +
               `🔗 https://cspainel.tvsbr.top/servidor/clientes\n\n` +
               `Entre com este mesmo usuário e senha gerados, escolha o seu plano e realize o pagamento. A renovação cai no seu receptor *AUTOMATICAMENTE* na hora!\n\n` +
               `📞 *Suporte WhatsApp:* (47) 9 8887-0797`;
    }

    function copiarDados() {
        navigator.clipboard.writeText(getMensagemFormatada()).then(() => alert("Todos os dados foram copiados com sucesso!"));
    }
    
    function enviarWhats() {
        const txt = encodeURIComponent(getMensagemFormatada());
        window.open(`https://api.whatsapp.com/send?text=${txt}`, '_blank');
    }
</script>
</body>
</html>
