<?php
session_start();
require_once '../conexao.php';

// Verifica Login
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php"); exit;
}

$isAdmin = (strtolower($_SESSION['nivel']) === 'admin');
$usuarioLogado = $_SESSION['usuario'];

// --- PROCESSAMENTO DO FORMULÁRIO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $token = trim($_POST['token_mp']);
    $banco = trim($_POST['dados_bancarios']);
    
    // Salva ou atualiza os dados
    $sql = "INSERT INTO mp_revendedores (usuario_revendedor, access_token, dados_bancarios) VALUES (?, ?, ?) 
            ON DUPLICATE KEY UPDATE access_token = VALUES(access_token), dados_bancarios = VALUES(dados_bancarios)";
    try {
        $connUser->prepare($sql)->execute([$usuarioLogado, $token, $banco]);
        echo "<script>alert('✅ Configurações salvas com sucesso!'); location.href='config_mp_revenda.php';</script>";
    } catch (Exception $e) {
        echo "<script>alert('Erro ao salvar: " . $e->getMessage() . "');</script>";
    }
}

// Busca dados atuais
$token_atual = "";
$banco_atual = "";
try {
    $stmt = $connUser->prepare("SELECT access_token, dados_bancarios FROM mp_revendedores WHERE usuario_revendedor = ?");
    $stmt->execute([$usuarioLogado]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);
    if($dados) {
        $token_atual = $dados['access_token'];
        $banco_atual = $dados['dados_bancarios'];
    }
} catch (Exception $e) {}

$nomePainel = "IPTV PANEL"; 
try {
    $conf = $connGeral->query("SELECT NomePainel FROM site_config LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if ($conf && !empty($conf['NomePainel'])) $nomePainel = $conf['NomePainel'];
} catch (Exception $e) { }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Config. Financeira | <?= htmlspecialchars($nomePainel) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --primary: #7367f0; --bg-body: #151521; --bg-card: #1e1e2d; --text-color: #e4e6eb; --border-color: #2b2b40; }
        body { background-color: var(--bg-body); color: var(--text-color); font-family: 'Segoe UI', sans-serif; overflow-x: hidden; }
        
        /* Sidebar */
        .sidebar { width: 260px; height: 100vh; position: fixed; background: var(--bg-card); border-right: 1px solid #333; z-index: 1050; padding: 20px; overflow-y: auto; transition: 0.3s; }
        .nav-link { color: #a6a6b7; padding: 12px 15px; border-radius: 8px; display: flex; align-items: center; gap: 12px; text-decoration: none; margin-bottom: 5px; font-weight: 500; transition: 0.2s; }
        .nav-link:hover, .nav-link.active { background: var(--primary); color: #fff; box-shadow: 0 4px 15px rgba(0,0,0,0.2); }
        .nav-group-title { font-size: 0.75rem; text-transform: uppercase; color: #5e5873; font-weight: 700; margin: 25px 0 10px 12px; letter-spacing: 1px; }
        
        /* Layout */
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }
        
        /* Cards */
        .card-config { background: var(--bg-card); border: 1px solid var(--border-color); border-radius: 12px; padding: 25px; box-shadow: 0 4px 20px rgba(0,0,0,0.2); }
        .form-label { color: #fff; font-weight: 700; margin-bottom: 8px; font-size: 0.95rem; }
        .form-control { background-color: #2b2b40; border: 1px solid #555; color: #fff; padding: 12px; border-radius: 8px; font-size: 1rem; }
        .form-control:focus { background-color: #2b2b40; border-color: var(--primary); color: #fff; box-shadow: 0 0 0 0.25rem rgba(115, 103, 240, 0.25); }
        .form-control::placeholder { color: #888; }
        
        /* Ajuda */
        .help-box { background-color: #252535; border: 1px solid var(--primary); border-radius: 10px; padding: 20px; color: #fff; }
        .help-title { color: #fff; font-weight: bold; font-size: 1.1rem; margin-bottom: 15px; border-bottom: 1px solid #444; padding-bottom: 10px; }
        .help-text { color: #e0e0e0; font-size: 0.95rem; line-height: 1.6; }

        /* Mobile */
        .mobile-toggle { display: none; color: #fff; font-size: 1.5rem; background: none; border: none; margin-bottom: 20px; }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 1040; }
        .overlay.show { display: block; }
        
        @media (max-width: 992px) { 
            .sidebar { transform: translateX(-100%); } 
            .sidebar.show { transform: translateX(0); } 
            .main-content { margin-left: 0; padding: 20px; } 
            .mobile-toggle { display: block; } 
        }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<nav class="sidebar" id="sidebar">
    <div class="nav flex-column mt-4">
        <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
        <?php if ($isAdmin): ?>
            <div class="nav-group-title">ADMINISTRATIVO</div>
            <a href="gerenciar_perfis.php" class="nav-link"><i class="fas fa-layer-group"></i> Perfis</a>
            <a href="gerenciar_dns.php" class="nav-link"><i class="fas fa-network-wired"></i> Servidores</a>
            <a href="gerenciar_admins.php" class="nav-link"><i class="fas fa-user-shield"></i> Admins</a>
            <a href="personalizar_painel.php" class="nav-link"><i class="fas fa-paint-brush"></i> Personalizar</a>
            <a href="gerenciar_email.php" class="nav-link"><i class="fas fa-envelope"></i> SMTP Email</a>
            <a href="config_geral.php" class="nav-link"><i class="fas fa-cogs"></i> Configurações</a>
        <?php endif; ?>
        <div class="nav-group-title">MENU</div>
        <a href="revendedores.php" class="nav-link"><i class="fas fa-store"></i> Revendedores</a>
        <a href="clientes.php" class="nav-link"><i class="fas fa-users"></i> Clientes</a>
        <a href="testes.php" class="nav-link"><i class="fas fa-stopwatch"></i> Testes</a>
        <a href="clientes_online.php" class="nav-link"><i class="fas fa-wifi"></i> Online Agora</a>
        <a href="monitor.php" class="nav-link"><i class="fas fa-bell"></i> Monitor</a>
        <a href="config_mp_revenda.php" class="nav-link active"><i class="fas fa-wallet"></i> Config. Financeira</a>
        <a href="sair.php" class="nav-link text-danger mt-4"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold m-0"><i class="fas fa-wallet me-2 text-primary"></i> Configuração Financeira</h3>
    </div>

    <form method="POST">
        <div class="row">
            <div class="col-12 col-lg-7 mb-4">
                <div class="card-config">
                    
                    <h5 class="text-white mb-3"><i class="fas fa-bolt text-warning me-2"></i> Automático (Mercado Pago)</h5>
                    <div class="mb-4">
                        <label class="form-label">Access Token (Produção)</label>
                        <div class="input-group">
                            <span class="input-group-text bg-dark border-secondary text-secondary"><i class="fas fa-key"></i></span>
                            <input type="text" name="token_mp" class="form-control" 
                                   placeholder="Cole seu Token aqui: APP_USR-..." 
                                   value="<?= htmlspecialchars($token_atual) ?>">
                        </div>
                        <div class="mt-2 text-info small fw-bold">
                            <i class="fas fa-info-circle me-1"></i> Preencha para ativar Pix/Cartão automático.
                        </div>
                    </div>

                    <hr class="border-secondary my-4">

                    <h5 class="text-white mb-3"><i class="fas fa-university text-success me-2"></i> Manual (Conta / Pix)</h5>
                    <div class="mb-4">
                        <label class="form-label">Dados Bancários para Depósito</label>
                        <textarea name="dados_bancarios" class="form-control" rows="5" 
                                  placeholder="Exemplo:&#10;Chave Pix: (11) 99999-9999&#10;Banco: Nubank&#10;Nome: Seu Nome"><?= htmlspecialchars($banco_atual) ?></textarea>
                        <div class="mt-2 text-white-50 small">
                            Esses dados aparecerão quando o cliente clicar em "Conta Bancária" na área dele.
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg fw-bold p-3">
                            <i class="fas fa-save me-2"></i> SALVAR TUDO
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="col-12 col-lg-5">
                <div class="help-box">
                    <div class="help-title"><i class="fas fa-lightbulb text-warning me-2"></i> Como funciona?</div>
                    <div class="help-text">
                        <p class="mb-3">Configure aqui como seus clientes poderão pagar pela renovação.</p>
                        
                        <strong class="text-warning">Opção 1: Mercado Pago (Automático)</strong>
                        <ul class="ps-3 mb-3 small">
                            <li>O cliente paga via Pix ou Cartão.</li>
                            <li>O sistema renova a data dele <strong>na hora</strong>.</li>
                            <li>Você não precisa fazer nada.</li>
                        </ul>

                        <strong class="text-success">Opção 2: Dados Bancários (Manual)</strong>
                        <ul class="ps-3 small">
                            <li>O cliente vê sua chave Pix ou Conta.</li>
                            <li>Ele faz a transferência e te manda o comprovante.</li>
                            <li>Você renova o cliente manualmente no painel.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </form>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { 
        document.getElementById('sidebar').classList.toggle('show'); 
        document.getElementById('overlay').classList.toggle('show'); 
    }
</script>
</body>
</html>
