<?php
session_start();
require_once '../conexao.php'; // Volta uma pasta para achar a conexão

// --- LÓGICA DE LOGIN ---
$erro = "";
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user = trim($_POST['usuario']);
    $pass = trim($_POST['senha']);

    if(empty($user) || empty($pass)) {
        $erro = "Preencha todos os campos!";
    } else {
        // Verifica apenas na tabela USUARIO (clientes finais)
        $sql = "SELECT * FROM usuario WHERE usuario = :u AND senha = :s";
        $stmt = $connUser->prepare($sql);
        $stmt->execute([':u' => $user, ':s' => $pass]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cliente) {
            $_SESSION['cliente_logado'] = true;
            $_SESSION['cliente_user'] = $cliente['usuario'];
            header("Location: area_cliente.php");
            exit;
        } else {
            $erro = "Usuário ou senha incorretos!";
        }
    }
}

// --- BUSCAR NOME DO PAINEL ---
$nomePainel = "Área do Cliente"; 
try {
    $conf = $connGeral->query("SELECT NomePainel FROM site_config LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if ($conf && !empty($conf['NomePainel'])) $nomePainel = $conf['NomePainel'];
} catch (Exception $e) { }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | <?= htmlspecialchars($nomePainel) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --primary: #7367f0; --primary-hover: #5e50ee; --bg-body: #151521; --bg-card: #1e1e2d; --text-color: #d0d2d6; }
        
        body { 
            background-color: var(--bg-body); 
            color: var(--text-color); 
            font-family: 'Segoe UI', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-image: radial-gradient(circle at 50% 50%, #252535 0%, #151521 100%);
        }

        .login-card {
            background-color: var(--bg-card);
            border-radius: 15px;
            padding: 40px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
            border: 1px solid #2b2b40;
        }

        .brand-logo {
            width: 60px;
            height: 60px;
            background: rgba(115, 103, 240, 0.15);
            color: var(--primary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            margin: 0 auto 20px;
        }

        .form-label { font-weight: 600; color: #fff; margin-bottom: 8px; font-size: 0.9rem; }
        
        .form-control {
            background-color: #2b2b40;
            border: 1px solid #3b3b50;
            color: #fff;
            padding: 12px 15px;
            border-radius: 8px;
            font-size: 1rem;
        }
        
        .form-control:focus {
            background-color: #2b2b40;
            border-color: var(--primary);
            box-shadow: 0 0 0 0.25rem rgba(115, 103, 240, 0.25);
            color: #fff;
        }

        .btn-login {
            background-color: var(--primary);
            color: #fff;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-weight: 700;
            width: 100%;
            margin-top: 20px;
            transition: 0.3s;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-login:hover {
            background-color: var(--primary-hover);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(115, 103, 240, 0.4);
        }

        .input-group-text {
            background-color: #2b2b40;
            border: 1px solid #3b3b50;
            border-right: none;
            color: #7d7d90;
        }
        
        .form-control { border-left: none; }
        .input-group:focus-within .input-group-text { border-color: var(--primary); }

        .footer-text { text-align: center; margin-top: 25px; color: #6e6b7b; font-size: 0.85rem; }
    </style>
</head>
<body>

    <div class="login-card">
        <div class="brand-logo">
            <i class="fas fa-tv"></i>
        </div>
        
        <h4 class="text-center fw-bold text-white mb-1"><?= htmlspecialchars($nomePainel) ?></h4>
        <p class="text-center text-secondary mb-4 small">Área do Cliente</p>

        <?php if(!empty($erro)): ?>
            <div class="alert alert-danger py-2 text-center border-0 bg-danger bg-opacity-10 text-danger">
                <i class="fas fa-exclamation-circle me-1"></i> <?= $erro ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Usuário</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                    <input type="text" name="usuario" class="form-control" placeholder="Digite seu usuário" required>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Senha</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" name="senha" class="form-control" placeholder="Digite sua senha" required>
                </div>
            </div>

            <button type="submit" class="btn-login">
                <i class="fas fa-sign-in-alt me-2"></i> ACESSAR CONTA
            </button>
        </form>

        <div class="footer-text">
            &copy; <?= date('Y') ?> Todos os direitos reservados.
        </div>
    </div>

</body>
</html>
