<?php
// Arquivo: clientes/webhook_asaas.php
require_once '../conexao.php';

$json = file_get_contents('php://input');
$evento = json_decode($json, true);

if (isset($evento['event']) && $evento['event'] == 'PAYMENT_RECEIVED') {
    
    $pagamento = $evento['payment'];
    $referencia = $pagamento['externalReference']; 
    
    // O externalReference vem como: joaozinho||365
    $partes = explode('||', $referencia);
    $usuario = trim($partes[0]);
    $dias_plano = (isset($partes[1]) && is_numeric($partes[1])) ? (int)$partes[1] : 30;
    
    if (!empty($usuario)) {
        
        // 1. Busca primeiro se ele já é CLIENTE
        $stmtUser = $connUser->prepare("SELECT data_premio, perfil, CadUser, senha FROM usuario WHERE usuario = ?");
        $stmtUser->execute([$usuario]);
        $userDados = $stmtUser->fetch();
        $is_teste = false;

        // 2. Se NÃO achar cliente, busca se ele é TESTE
        if (!$userDados) {
            $stmtTeste = $connUser->prepare("SELECT data_premio, perfil, CadUser, senha, nome FROM teste WHERE usuario = ?");
            $stmtTeste->execute([$usuario]);
            $userDados = $stmtTeste->fetch();
            $is_teste = true;
        }

        if ($userDados) {
            $venc_atual = is_numeric($userDados['data_premio']) ? $userDados['data_premio'] : strtotime($userDados['data_premio']);
            
            // Calcula o novo vencimento somando os dias exatos
            if ($venc_atual < time()) {
                $nova_data = strtotime("+$dias_plano days"); 
            } else {
                $nova_data = strtotime("+$dias_plano days", $venc_atual);
            }

            if ($is_teste) {
                // ==========================================
                // MAGIA AQUI: TRANSFORMA O TESTE EM CLIENTE
                // ==========================================
                $nome = $userDados['nome'] ?? $usuario;
                $sql_ins = "INSERT INTO usuario (CadUser, nome, usuario, senha, conexao, data_premio, perfil, bloqueado, data_cadastro) VALUES (?, ?, ?, ?, 1, ?, ?, 'nao', NOW())";
                $connUser->prepare($sql_ins)->execute([$userDados['CadUser'], $nome, $usuario, $userDados['senha'], $nova_data, $userDados['perfil']]);
                
                // Exclui da tabela de testes para não ficar duplicado
                $connUser->prepare("DELETE FROM teste WHERE usuario = ?")->execute([$usuario]);
            } else {
                // SE JÁ ERA CLIENTE, SÓ ATUALIZA A DATA E DESBLOQUEIA
                $sql = "UPDATE usuario SET data_premio = ?, bloqueado = 'nao' WHERE usuario = ?";
                $connUser->prepare($sql)->execute([$nova_data, $usuario]);
            }
            
            // Opcional: Registra o pagamento na tabela do painel
            try {
                $connUser->prepare("INSERT INTO pagamentos (id_pagamento_mp, usuario_id, status, valor, data_pagamento) VALUES (?, ?, 'aprovado', ?, NOW())")
                         ->execute([$pagamento['id'], $usuario, $pagamento['value']]);
            } catch (Exception $e) { /* Ignora se tabela não existir */ }
        }
    }
}

http_response_code(200);
echo json_encode(["status" => "recebido e processado"]);
?>
